/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;

public class MethodPathRouting
implements HttpHandler {
    private final Map<String, Map<String, HttpHandler>> routes = new HashMap<String, Map<String, HttpHandler>>();
    private HttpHandler fallback = httpServerExchange -> httpServerExchange.setStatusCode(404);

    public static MethodPathRouting methodPathRouting() {
        return new MethodPathRouting();
    }

    public MethodPathRouting fallback(HttpHandler httpHandler) {
        this.fallback = httpHandler;
        return this;
    }

    public MethodPathRouting head(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("HEAD", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    public MethodPathRouting get(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("GET", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    public MethodPathRouting put(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("PUT", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    public MethodPathRouting post(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("POST", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    public MethodPathRouting patch(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("PATCH", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    public MethodPathRouting delete(String string2, HttpHandler httpHandler) {
        this.routes.computeIfAbsent("DELETE", string -> new HashMap()).put(string2, httpHandler);
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        Map<String, HttpHandler> map = this.routes.get(httpServerExchange.getRequestMethod());
        HttpHandler httpHandler = map == null ? this.fallback : map.getOrDefault(httpServerExchange.getRequestPath(), this.fallback);
        httpHandler.handleRequest(httpServerExchange);
    }
}

