/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.FormPart;
import httpserver.core.HttpServerExchange;
import httpserver.util.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FormParsing
extends Enum<FormParsing> {
    private static final /* synthetic */ FormParsing[] $VALUES;

    public static FormParsing[] values() {
        return (FormParsing[])$VALUES.clone();
    }

    public static FormParsing valueOf(String string) {
        return Enum.valueOf(FormParsing.class, string);
    }

    public static Map<String, String> parseUrlEncodedForm(HttpServerExchange httpServerExchange, Charset charset) throws IOException {
        String[] stringArray;
        String string = httpServerExchange.getRequestHeader("Content-Type");
        if (!"application/x-www-form-urlencoded".equals(string)) {
            throw new IOException("Content type no url encoded form. Found '" + string + "' instead.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = new String(httpServerExchange.getInputStream().readAllBytes(), charset).split("&")) {
            int n = string2.indexOf(61);
            if (n == -1) {
                hashMap.put(string2, "");
                continue;
            }
            String string3 = Encoding.decodeUrl(string2.substring(0, n));
            String string4 = Encoding.decodeUrl(string2.substring(n + 1));
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    public static List<FormPart> parseMultipartForm(String string, int n, InputStream inputStream) throws IOException {
        if (!string.startsWith("multipart/form-data")) {
            throw new IOException("Not multipart form data");
        }
        if (n > 65536) {
            throw new IOException("Form content too large");
        }
        byte[] byArray = ("--" + string.substring(string.indexOf(61) + 1)).getBytes(StandardCharsets.US_ASCII);
        byte[] byArray2 = new byte[n];
        ArrayList<FormPart> arrayList = new ArrayList<FormPart>();
        int n2 = FormParsing.readUntil(byArray2, 0, inputStream, byArray);
        int n3 = -1;
        while (n2 != -1) {
            byArray2[n2] = (byte)inputStream.read();
            byArray2[n2 + 1] = (byte)inputStream.read();
            n3 = FormParsing.readUntil(byArray2, n2 + 2, inputStream, byArray);
            if (n3 == -1) break;
            arrayList.add(new FormPart(byArray2, n2, n3 - byArray.length - 2));
            n2 = n3;
        }
        return arrayList;
    }

    private static int readUntil(byte[] byArray, int n, InputStream inputStream, byte[] byArray2) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) != -1) {
            byArray[n++] = (byte)n2;
            if (FormParsing.containsAt(byArray, byArray2, n)) {
                return n;
            }
            if (n <= byArray.length) continue;
            throw new IOException("Filled buffer but more data still available");
        }
        return -1;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n, int n2) {
        if (byArray2.length == 0) {
            return 0;
        }
        for (int i = n; i < n2; ++i) {
            if (!FormParsing.containsAt(byArray, byArray2, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean containsAt(byte[] byArray, byte[] byArray2, int n) {
        if (n > byArray.length) {
            return false;
        }
        if (byArray2.length == 0) {
            return true;
        }
        if (n - byArray2.length < 0) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n - byArray2.length + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ FormParsing[] $values() {
        return new FormParsing[0];
    }

    static {
        $VALUES = FormParsing.$values();
    }
}

