/*
 * Decompiled with CFR 0.152.
 */
package httpserver.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.StringCharacterIterator;
import java.util.HexFormat;

public final class Encoding
extends Enum<Encoding> {
    private static final /* synthetic */ Encoding[] $VALUES;

    public static Encoding[] values() {
        return (Encoding[])$VALUES.clone();
    }

    public static Encoding valueOf(String string) {
        return Enum.valueOf(Encoding.class, string);
    }

    public static byte[] sha256(String string, Charset charset) {
        return Encoding.sha256(string.getBytes(charset));
    }

    public static byte[] sha256(byte[] byArray) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static String encodeHex(byte[] byArray) {
        return HexFormat.of().formatHex(byArray);
    }

    public static String encodeUrl(String string) {
        return string != null ? URLEncoder.encode(string, StandardCharsets.UTF_8) : "";
    }

    public static String decodeUrl(String string) {
        return string != null ? URLDecoder.decode(string, StandardCharsets.UTF_8) : "";
    }

    public static String escapeJson(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    break;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    break;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    break;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    private static /* synthetic */ Encoding[] $values() {
        return new Encoding[0];
    }

    static {
        $VALUES = Encoding.$values();
    }
}

