/*
 * Decompiled with CFR 0.152.
 */
package httpserver.util;

import java.io.IOException;
import java.io.InputStream;

public class LengthRestrictedInputStream
extends InputStream {
    private final InputStream in;
    private long toRead;

    public LengthRestrictedInputStream(InputStream inputStream, long l) {
        this.in = inputStream;
        this.toRead = l;
    }

    @Override
    public int available() throws IOException {
        if (this.toRead <= 0L) {
            return 0;
        }
        return Math.min(this.in.available(), (int)this.toRead);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int n) {
        this.in.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        int n = (int)Math.min(Math.min((long)byArray.length, this.toRead), 8192L);
        int n2 = this.in.read(byArray, 0, n);
        this.toRead -= (long)n;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        int n3 = Math.min((int)Math.min(Math.min((long)byArray.length, this.toRead), 8192L), n2);
        int n4 = this.in.read(byArray, n, n3);
        this.toRead -= (long)n3;
        return n4;
    }

    @Override
    public int read() throws IOException {
        if (this.toRead <= 0L) {
            return -1;
        }
        --this.toRead;
        return this.in.read();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.toRead <= 0L) {
            return 0L;
        }
        long l2 = Math.min(l, this.toRead);
        long l3 = this.in.skip(l2);
        this.toRead -= l3;
        return l3;
    }
}

