/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.javabuilder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class Generator {
    private Generator() {
    }

    public static Builder pkg(String pkg) {
        return new Builder(pkg);
    }

    private static String declaredType(Field f) {
        if (f.mandatory || f.defaultValue != null) {
            return f.type;
        }
        return "Optional<" + f.type + ">";
    }

    private static String parameterType(String type) {
        if (type.equals("Integer")) {
            return "int";
        }
        if (type.equals("Double")) {
            return "double";
        }
        if (type.equals("Short")) {
            return "short";
        }
        if (type.equals("Boolean")) {
            return "boolean";
        }
        if (type.equals("Long")) {
            return "long";
        }
        return type;
    }

    public static final class Builder4 {
        private final Builder3 b;

        Builder4(Builder3 b) {
            this.b = b;
        }

        public Builder4 mandatory() {
            this.b.mandatory = true;
            return this;
        }

        public Builder4 entryMethod() {
            this.b.isEntryMethod = true;
            return this;
        }

        public Builder4 defaultValue(String defaultValue) {
            this.b.defaultValue = defaultValue;
            return this;
        }

        public Builder2 build() {
            ((Builder2)((Builder3)this.b).b).b.fields.add(new Field(this.b.type, this.b.name, this.b.defaultValue, this.b.mandatory, this.b.isEntryMethod));
            return this.b.b;
        }
    }

    public static final class Builder3 {
        private final Builder2 b;
        private final String type;
        private String name;
        private String defaultValue;
        private boolean mandatory;
        private boolean isEntryMethod;

        Builder3(Builder2 b, String type) {
            this.b = b;
            this.type = type;
        }

        public Builder4 name(String name) {
            this.name = name;
            return new Builder4(this);
        }
    }

    public static final class GeneratorMore {
        private final Builder2 b;

        GeneratorMore(Builder2 b) {
            this.b = b;
        }

        public GeneratorMore generate() {
            this.b.generate();
            return this;
        }

        public GeneratorMore generate(OutputStream os) {
            this.b.generate(os);
            return this;
        }

        public GeneratorMore generate(String directory) {
            this.b.generate(directory);
            return this;
        }
    }

    public static final class Builder2 {
        private final Builder b;

        Builder2(Builder b) {
            this.b = b;
        }

        public Builder2 imports(Class<?> cls) {
            return this.imports(cls.getName());
        }

        public Builder2 imports(String cls) {
            this.b.imports.add(cls);
            return this;
        }

        public Builder3 type(String type) {
            return new Builder3(this, type);
        }

        public GeneratorMore generate(String directory) {
            try (FileOutputStream os = new FileOutputStream(directory + File.separator + this.b.className + ".java");){
                this.generate(os);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new GeneratorMore(this);
        }

        public GeneratorMore generate() {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.generate(bytes);
            try {
                Files.write(new File("target" + File.separator + this.b.className + ".java").toPath(), bytes.toByteArray(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.out.println(new String(bytes.toByteArray(), StandardCharsets.UTF_8));
            return new GeneratorMore(this);
        }

        public GeneratorMore generate(OutputStream os) {
            try (PrintStream out = new PrintStream(os);){
                List mandatory = this.b.fields.stream().filter(f -> ((Field)f).mandatory).collect(Collectors.toList());
                List nonMandatory = this.b.fields.stream().filter(f -> !((Field)f).mandatory).collect(Collectors.toList());
                boolean allNonMandatoryHaveDefaults = this.b.fields.stream().allMatch(f -> ((Field)f).mandatory || ((Field)f).defaultValue != null);
                out.format("package %s;\n\n", this.b.pkg);
                if (!nonMandatory.isEmpty() && !allNonMandatoryHaveDefaults) {
                    out.println("import java.util.Optional;\n");
                }
                for (String imp : this.b.imports) {
                    if ("java.util.Optional".equals(imp)) continue;
                    out.format("import %s;\n", imp);
                }
                out.println();
                out.format("public final class %s {\n\n", this.b.className);
                out.println(this.b.fields.stream().map(f -> "    private final " + Generator.declaredType(f) + " " + ((Field)f).name + ";").collect(Collectors.joining("\n")));
                out.println();
                String constructorParameters = this.b.fields.stream().map(f -> Generator.declaredType(f) + " " + ((Field)f).name).collect(Collectors.joining(", "));
                out.format("    private %s(%s) {\n", this.b.className, constructorParameters);
                String notNulls = this.b.fields.stream().map(f -> String.format("        notNull(%s, \"%s\");", ((Field)f).name, ((Field)f).name)).collect(Collectors.joining("\n"));
                out.println(notNulls);
                String constructorAssignments = this.b.fields.stream().map(f -> "        this." + ((Field)f).name + " = " + ((Field)f).name + ";").collect(Collectors.joining("\n"));
                out.println(constructorAssignments);
                out.format("    }\n\n", new Object[0]);
                out.println("    public static Builder1 builder() {");
                out.println("        return new Builder1();");
                out.println("    }\n");
                if (!mandatory.isEmpty()) {
                    Field f2 = (Field)mandatory.get(0);
                    if (f2.isEntryMethod) {
                        out.format("    public static Builder2 %s(%s %s) {\n;", f2.name, Generator.parameterType(f2.type), f2.name);
                        out.format("        return builder().%s(%s);\n", f2.name, f2.name);
                        out.format("    }\n\n", new Object[0]);
                    }
                } else {
                    for (Field f3 : nonMandatory) {
                        if (!f3.isEntryMethod) continue;
                        out.format("    public static Builder1 %s(%s %s) {\n;", f3.name, Generator.parameterType(f3.type), f3.name);
                        out.format("        return builder().%s(%s);\n", f3.name, f3.name);
                        out.format("    }\n\n", new Object[0]);
                    }
                }
                for (Field f3 : this.b.fields) {
                    out.format("    public %s %s() {\n", Generator.declaredType(f3), f3.name);
                    out.format("        return %s;\n", f3.name);
                    out.format("    }\n\n", new Object[0]);
                }
                int n = 1;
                for (int i = 0; i < mandatory.size(); ++i) {
                    out.format("    public static final class Builder%s {\n\n", n);
                    if (n == 1) {
                        this.writeBuilder1Fields(out);
                        out.println();
                        out.format("        Builder%s(){\n", n);
                    } else {
                        out.format("        private final Builder1 b;\n\n", new Object[0]);
                        out.format("        Builder%s(Builder1 b){\n", n);
                        out.format("            this.b = b;\n", new Object[0]);
                    }
                    out.format("        }\n\n", new Object[0]);
                    Field f4 = (Field)mandatory.get(i);
                    if (i < mandatory.size() - 1 || !nonMandatory.isEmpty()) {
                        out.format("        public Builder%s %s(%s %s) {\n", n + 1, f4.name, Generator.parameterType(f4.type), f4.name);
                        out.format("            notNull(%s, \"%s\");\n", f4.name, f4.name);
                        if (n == 1) {
                            out.format("            this.%s = %s;\n", f4.name, f4.name);
                        } else {
                            out.format("            b.%s = %s;\n", f4.name, f4.name);
                        }
                        if (n == 1) {
                            out.format("            return new Builder%s(this);\n", n + 1);
                        } else {
                            out.format("            return new Builder%s(b);\n", n + 1);
                        }
                        out.format("        }\n\n", new Object[0]);
                    } else {
                        out.format("        public %s %s(%s %s) {\n", this.b.className, f4.name, Generator.parameterType(f4.type), f4.name);
                        out.format("            notNull(%s, \"%s\");\n", f4.name, f4.name);
                        out.format("            b.%s = %s;\n", f4.name, f4.name);
                        out.format("            return new %s(%s);\n", this.b.className, this.parameters());
                        out.format("        }\n\n", new Object[0]);
                    }
                    out.format("    }\n\n", new Object[0]);
                    ++n;
                }
                if (!nonMandatory.isEmpty()) {
                    out.format("    public static final class Builder%s {\n", n);
                    out.println();
                    if (mandatory.isEmpty()) {
                        this.writeBuilder1Fields(out);
                    } else {
                        out.format("        private final Builder1 b;\n", new Object[0]);
                    }
                    out.println();
                    if (mandatory.isEmpty()) {
                        out.format("        Builder%s() {\n", n);
                        out.format("        }\n", new Object[0]);
                    } else {
                        out.format("        Builder%s(Builder1 b) {\n", n);
                        out.format("             this.b = b;\n", new Object[0]);
                        out.format("        }\n", new Object[0]);
                    }
                    for (Field m : nonMandatory) {
                        out.format("\n", new Object[0]);
                        out.format("        public Builder%s %s(%s %s) {\n", n, m.name, Generator.parameterType(m.type), m.name);
                        out.format("            notNull(%s, \"%s\");\n", m.name, m.name);
                        String field = mandatory.isEmpty() ? "this" : "b";
                        if (m.defaultValue != null) {
                            out.format("            %s.%s = %s;\n", field, m.name, m.name);
                        } else {
                            out.format("            %s.%s = Optional.of(%s);\n", field, m.name, m.name);
                        }
                        out.format("            return this;\n", new Object[0]);
                        out.format("        }\n", new Object[0]);
                    }
                    out.format("\n        public %s build() {\n", this.b.className);
                    out.format("            return new %s(%s);\n", this.b.className, this.parameters(mandatory.isEmpty()));
                    out.format("        }\n", new Object[0]);
                    out.format("    }\n\n", new Object[0]);
                }
                out.format("    private static void notNull(Object o, String name) {\n", new Object[0]);
                out.format("        if (o == null) {\n", new Object[0]);
                out.format("            throw new NullPointerException(name + \" cannot be null\");\n", new Object[0]);
                out.format("        }\n", new Object[0]);
                out.format("    }\n", new Object[0]);
                out.format("}", new Object[0]);
                GeneratorMore generatorMore = new GeneratorMore(this);
                return generatorMore;
            }
        }

        private void writeBuilder1Fields(PrintStream out) {
            for (Field field : this.b.fields) {
                String d = field.defaultValue != null ? " = " + field.defaultValue : (!field.mandatory ? " = Optional.empty()" : "");
                out.format("        private %s %s%s;\n", Generator.declaredType(field), field.name, d);
            }
        }

        private String parameters() {
            return this.parameters(false);
        }

        private String parameters(boolean useThis) {
            String field = useThis ? "this" : "b";
            return this.b.fields.stream().map(x -> field + "." + ((Field)x).name).collect(Collectors.joining(", "));
        }
    }

    public static final class Builder {
        private final String pkg;
        private String className;
        final List<Field> fields = new ArrayList<Field>();
        final List<String> imports = new ArrayList<String>();

        Builder(String pkg) {
            this.pkg = pkg;
        }

        public Builder2 className(String className) {
            this.className = className;
            return new Builder2(this);
        }
    }

    public static final class Field {
        private final String type;
        private final String name;
        private final String defaultValue;
        private final boolean mandatory;
        private final boolean isEntryMethod;

        Field(String type, String name, String defaultValue, boolean mandatory, boolean isEntryMethod) {
            this.type = type;
            this.name = name;
            this.defaultValue = defaultValue;
            this.mandatory = mandatory;
            this.isEntryMethod = isEntryMethod;
        }
    }
}

