/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.client.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.davidmoten.oa3.codegen.http.DefaultSerializer;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.http.service.DefaultHttpService;
import org.davidmoten.oa3.codegen.http.service.HttpService;
import org.davidmoten.oa3.codegen.runtime.Config;

public final class ClientBuilder<T> {
    private final Function<ClientBuilder<T>, T> creator;
    private final String basePath;
    private final List<Interceptor> interceptors;
    private Serializer serializer;
    private HttpService httpService;

    public ClientBuilder(Function<ClientBuilder<T>, T> creator, Config config, String basePath) {
        this.creator = creator;
        this.serializer = new DefaultSerializer(config.mapper());
        this.interceptors = new ArrayList<Interceptor>();
        this.basePath = ClientBuilder.trimAndRemoveFinalSlash(basePath);
        this.httpService = DefaultHttpService.INSTANCE;
    }

    public ClientBuilder<T> serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ClientBuilder<T> interceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public ClientBuilder<T> interceptors(Iterable<? extends Interceptor> list) {
        list.forEach(x -> this.interceptor((Interceptor)x));
        return this;
    }

    public ClientBuilder<T> httpService(HttpService httpService) {
        this.httpService = httpService;
        return this;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public String basePath() {
        return this.basePath;
    }

    public HttpService httpService() {
        return this.httpService;
    }

    public T build() {
        return this.creator.apply(this);
    }

    private static String trimAndRemoveFinalSlash(String s) {
        if ((s = s.trim()).endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }
}

