/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Maps;
import com.github.davidmoten.guavamini.Preconditions;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.SchemaWithName;
import org.davidmoten.oa3.codegen.generator.Visitor;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.util.ImmutableList;

class Apis {
    private static final List<Class<? extends Schema<?>>> COMPLEX_SCHEMA_CLASSES = Lists.of((Object[])new Class[]{ObjectSchema.class, MapSchema.class, ComposedSchema.class, ArraySchema.class});

    Apis() {
    }

    static void visitSchemas(OpenAPI api, Visitor visitor) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((name, pathItem) -> Apis.visitSchemas(SchemaCategory.PATH, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{name}), pathItem, visitor, api));
        }
        if (api.getComponents() != null) {
            if (api.getComponents().getParameters() != null) {
                api.getComponents().getParameters().forEach((name, parameter) -> Apis.visitSchemas(SchemaCategory.PARAMETER, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{name}), parameter, visitor, api));
            }
            if (api.getComponents().getPathItems() != null) {
                api.getComponents().getPathItems().forEach((name, pathItem) -> Apis.visitSchemas(SchemaCategory.PATH_ITEM, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{name}), pathItem, visitor, api));
            }
            if (api.getComponents().getRequestBodies() != null) {
                api.getComponents().getRequestBodies().forEach((name, requestBody) -> Apis.visitSchemas(SchemaCategory.REQUEST_BODY, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{name}), requestBody, visitor, api));
            }
            if (api.getComponents().getResponses() != null) {
                api.getComponents().getResponses().forEach((name, response) -> Apis.visitSchemas(SchemaCategory.RESPONSE, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{name}), response, visitor, api));
            }
            if (api.getComponents().getHeaders() != null) {
                api.getComponents().getHeaders().forEach((key, header) -> Apis.visitSchemas(SchemaCategory.HEADER, (ImmutableList<String>)ImmutableList.of((Object[])new String[]{key}), header, visitor, api));
            }
            if (api.getComponents().getSchemas() != null) {
                api.getComponents().getSchemas().forEach((key, value) -> Apis.visitSchemas(key, value, visitor));
            }
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> names, Header header, Visitor visitor, OpenAPI api) {
        if (header != null) {
            header = Apis.resolveRefs(api, header);
            Apis.visitSchemas(category, names, header.getSchema(), Maps.empty(), visitor);
        }
    }

    private static Header resolveRefs(OpenAPI api, Header header) {
        while (header.get$ref() != null) {
            header = (Header)api.getComponents().getHeaders().get(Names.lastComponent(header.get$ref()));
        }
        return header;
    }

    private static void visitSchemas(String name, Schema<?> schema, Visitor visitor) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0);
        Apis.visitSchemas(SchemaCategory.SCHEMA, (ImmutableList<SchemaWithName>)ImmutableList.of((Object[])new SchemaWithName[]{new SchemaWithName(Apis.stripLeadingSlash(name), schema)}), Maps.empty(), visitor);
    }

    private static String stripLeadingSlash(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> names, PathItem pathItem, Visitor visitor, OpenAPI api) {
        if ((pathItem = Apis.resolveRefs(api, pathItem)).readOperationsMap() != null) {
            pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
                ImmutableList names2 = operation.getOperationId() != null ? ImmutableList.of((Object[])new String[]{operation.getOperationId()}) : names.add((Object)Names.upperFirst(httpMethod.toString().toLowerCase(Locale.ENGLISH)));
                Apis.visitSchemas(category, (ImmutableList<String>)names2, operation, visitor, api);
            });
        }
        if (pathItem.getParameters() != null) {
            pathItem.getParameters().forEach(p -> {
                p = Apis.resolveRefs(api, p);
                Apis.visitSchemas(category, (ImmutableList<String>)names.add((Object)p.getName()), p, visitor, api);
            });
        }
    }

    static PathItem resolveRefs(OpenAPI api, PathItem item) {
        while (item.get$ref() != null) {
            item = (PathItem)api.getComponents().getPathItems().get(Names.lastComponent(item.get$ref()));
        }
        return item;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Operation operation, Visitor visitor, OpenAPI api) {
        if (operation == null) {
            return;
        }
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(p -> {
                p = Apis.resolveRefs(api, p);
                Apis.visitSchemas(category, (ImmutableList<String>)list.add((Object)p.getName()), p, visitor, api);
            });
        }
        Apis.visitSchemas(category, list, operation.getRequestBody(), visitor, api);
        if (operation.getResponses() != null) {
            operation.getResponses().forEach((statusCode, response) -> {
                response = Apis.resolveRefs(api, response);
                Apis.visitSchemas(category, (ImmutableList<String>)list.add(statusCode), response, visitor, api);
            });
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, ApiResponse response, Visitor visitor, OpenAPI api) {
        response = Apis.resolveRefs(api, response);
        Apis.visitSchemas(category, (ImmutableList<String>)(category == SchemaCategory.RESPONSE ? list : list.add((Object)"Response")), response.getContent(), visitor);
    }

    private static ApiResponse resolveRefs(OpenAPI api, ApiResponse response) {
        while (response.get$ref() != null) {
            if (api.getComponents() == null || api.getComponents().getResponses() == null) {
                throw new IllegalStateException("ref not found: " + response.get$ref());
            }
            response = (ApiResponse)api.getComponents().getResponses().get(Names.lastComponent(response.get$ref()));
        }
        return response;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, RequestBody requestBody, Visitor visitor, OpenAPI api) {
        if (requestBody != null) {
            requestBody = Apis.resolveRefs(api, requestBody);
            Apis.visitSchemas(category, (ImmutableList<String>)list.add((Object)"Request"), requestBody.getContent(), visitor);
        }
    }

    private static RequestBody resolveRefs(OpenAPI api, RequestBody requestBody) {
        while (requestBody.get$ref() != null) {
            requestBody = (RequestBody)api.getComponents().getRequestBodies().get(Names.lastComponent(requestBody.get$ref()));
        }
        return requestBody;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Content content, Visitor visitor) {
        if (content != null) {
            content.forEach((mimeType, mediaType) -> {
                if (mimeType.equals("application/json")) {
                    Apis.visitSchemas(category, list, mediaType, visitor);
                } else {
                    Apis.visitSchemas(category, (ImmutableList<String>)list.add(mimeType), mediaType, visitor);
                }
            });
        }
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, MediaType mediaType, Visitor visitor) {
        Apis.visitSchemas(category, list, mediaType.getSchema(), mediaType.getEncoding(), visitor);
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Parameter parameter, Visitor visitor, OpenAPI api) {
        if (parameter != null) {
            if ((parameter = Apis.resolveRefs(api, parameter)).getSchema() != null && (!Util.isPrimitive(parameter.getSchema()) || Util.isEnum(parameter.getSchema()))) {
                Apis.visitSchemas(category, list, parameter.getSchema(), Maps.empty(), visitor);
            }
            Apis.visitSchemas(category, (ImmutableList<String>)list.add((Object)"Parameter").add((Object)parameter.getName()), parameter.getContent(), visitor);
        }
    }

    private static Parameter resolveRefs(OpenAPI api, Parameter parameter) {
        while (parameter.get$ref() != null) {
            parameter = (Parameter)api.getComponents().getParameters().get(Names.lastComponent(parameter.get$ref()));
        }
        return parameter;
    }

    private static void visitSchemas(SchemaCategory category, ImmutableList<String> list, Schema<?> schema, Map<String, Encoding> propertyEncoding, Visitor visitor) {
        if (schema != null) {
            ImmutableList schemaPath = ImmutableList.of((Object[])new SchemaWithName[]{new SchemaWithName(Names.toIdentifier(list), schema)});
            Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath, propertyEncoding, visitor);
        }
    }

    static void visitSchemas(SchemaCategory category, ImmutableList<SchemaWithName> schemaPath, Map<String, Encoding> propertyEncoding, Visitor visitor) {
        Schema<?> schema = ((SchemaWithName)schemaPath.last()).schema;
        visitor.startSchema(category, schemaPath);
        if (schema instanceof ComposedSchema && ((ComposedSchema)schema).getAnyOf() != null && (schema.getProperties() != null || schema.getAdditionalProperties() != null || schema.getAdditionalItems() != null)) {
            schema.setProperties(null);
            schema.setAdditionalProperties(null);
            schema.setAdditionalItems(null);
            System.out.println("[WARN] anyOf with extra properties not supported yet, extra properties stripped");
        } else if (schema instanceof ObjectSchema && schema.getProperties() == null && schema.getAdditionalProperties() == null) {
            schema.setAdditionalProperties((Object)Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(schema.getAdditionalProperties())) {
            schema.setAdditionalProperties((Object)new Schema());
        }
        if (schema.getAdditionalProperties() instanceof Schema && schema.getEnum() == null) {
            Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName("properties", (Schema)schema.getAdditionalProperties())), Maps.empty(), visitor);
        } else if (schema.getNot() != null) {
            Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName("not", schema.getNot())), Maps.empty(), visitor);
        }
        if (schema.getProperties() != null && !(schema instanceof ArraySchema)) {
            schema.getProperties().forEach((key, value) -> {
                Schema sch;
                if (propertyEncoding != null && propertyEncoding.containsKey(key)) {
                    Encoding encoding = (Encoding)propertyEncoding.get(key);
                    if (encoding.getContentType() != null) {
                        List<String> contentTypes = Arrays.stream(encoding.getContentType().split(",")).map(String::trim).collect(Collectors.toList());
                        Schema<String> contentTypeSchema = Apis.enumSchema(contentTypes);
                        if (contentTypes.size() == 1) {
                            contentTypeSchema.setDefault((Object)contentTypes.get(0));
                        }
                        contentTypeSchema.setExtensions(Maps.hashMap().put((Object)"x-openapi-codegen-internal-has-encoding", (Object)Boolean.TRUE).build());
                        ObjectSchema combined = new ObjectSchema();
                        combined.setProperties(new LinkedHashMap());
                        combined.getProperties().put("contentType", contentTypeSchema);
                        combined.getProperties().put("value", value);
                        combined.setRequired(Lists.of((Object[])new String[]{"value", "contentType"}));
                        combined.setExtensions(Maps.hashMap().put((Object)"x-openapi-codegen-internal-has-encoding", (Object)Boolean.TRUE).build());
                        sch = combined;
                    } else {
                        sch = value;
                    }
                } else {
                    sch = value;
                }
                Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName((String)key, (Schema<?>)sch)), Maps.empty(), visitor);
            });
        }
        if (schema instanceof ArraySchema) {
            ArraySchema a = (ArraySchema)schema;
            if (a.getItems() != null) {
                Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName(((SchemaWithName)schemaPath.last()).name + "Item", a.getItems())), Maps.empty(), visitor);
            }
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema a = (ComposedSchema)schema;
            if (a.getAllOf() != null) {
                a.getAllOf().forEach(x -> Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName(null, (Schema<?>)x)), Maps.empty(), visitor));
            }
            if (a.getOneOf() != null) {
                a.getOneOf().forEach(x -> Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName(null, (Schema<?>)x)), Maps.empty(), visitor));
            }
            if (a.getAnyOf() != null) {
                a.getAnyOf().forEach(x -> Apis.visitSchemas(category, (ImmutableList<SchemaWithName>)schemaPath.add((Object)new SchemaWithName(null, (Schema<?>)x)), Maps.empty(), visitor));
            }
        }
        visitor.finishSchema(category, schemaPath);
    }

    private static Schema<String> enumSchema(List<String> values) {
        Schema schema = new Schema();
        schema.setType("string");
        schema.setEnum(values);
        return schema;
    }

    static boolean isComplexSchema(Schema<?> schema) {
        for (Class<Schema<?>> cls : COMPLEX_SCHEMA_CLASSES) {
            if (!cls.isAssignableFrom(schema.getClass())) continue;
            return true;
        }
        return schema.getProperties() != null;
    }
}

