/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.CookieParameter;
import io.swagger.v3.oas.models.parameters.HeaderParameter;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Apis;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.internal.Mutable;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.writer.ClientCodeWriter;
import org.davidmoten.oa3.codegen.generator.writer.ServerCodeWriterSpringBoot;
import org.davidmoten.oa3.codegen.util.ImmutableList;

public class ClientServerGenerator {
    private final Names names;
    private final Map<String, Generator.Cls> refCls;
    private final Map<Schema<?>, Generator.Cls> schemaCls;

    public ClientServerGenerator(Definition definition) {
        this.names = new Names(definition);
        HashMap<String, Generator.Cls> refCls = new HashMap<String, Generator.Cls>();
        HashMap schemaCls = new HashMap();
        Generator.MyVisitor v = new Generator.MyVisitor(this.names);
        Apis.visitSchemas(this.names.api(), v);
        for (Generator.MyVisitor.Result result : v.results()) {
            Generator.Cls c = result.cls;
            if (!c.topLevel) continue;
            String refPrefix = c.category.refPrefix();
            String ref = refPrefix + c.name.get();
            refCls.put(ref, c);
            schemaCls.put(c.schema.get(), c);
        }
        this.refCls = refCls;
        this.schemaCls = schemaCls;
    }

    public void generateServer() {
        List<Method> methods = this.collectMethods();
        ServerCodeWriterSpringBoot.writeServiceClasses(this.names, methods);
    }

    public void generateClient() {
        List<Method> methods = this.collectMethods();
        ClientCodeWriter.writeClientClass(this.names, methods);
    }

    private List<Method> collectMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (this.names.api().getPaths() != null) {
            this.names.api().getPaths().forEach((pathName, pathItem) -> this.gatherMethods((String)pathName, (PathItem)pathItem, (List<Method>)methods));
        }
        return methods;
    }

    private void gatherMethods(String pathName, PathItem pathItem, List<Method> methods) {
        pathItem = Apis.resolveRefs(this.names.api(), pathItem);
        pathItem.readOperationsMap().forEach((method, operation) -> this.gatherMethods(pathName, (PathItem.HttpMethod)method, (Operation)operation, methods));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherMethods(String pathName, PathItem.HttpMethod method, Operation operation, List<Method> methods) {
        void var10_22;
        void var9_19;
        void var8_16;
        Content content;
        String methodName = !Util.isNullOrBlank(operation.getOperationId()) ? Names.toIdentifier(operation.getOperationId()) : Names.toIdentifier((ImmutableList<String>)ImmutableList.of((Object[])new String[]{pathName, method.toString().toLowerCase(Locale.ENGLISH)}));
        Optional<String> statusCode = Optional.empty();
        ArrayList<Param> params = new ArrayList<Param>();
        Optional optional = Optional.empty();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        HashSet parameterNames = new HashSet();
        if (operation.getParameters() != null) {
            operation.getParameters().forEach(p -> {
                Param param;
                p = this.resolveParameterRefs((Parameter)p);
                boolean isArray = false;
                Schema s = p.getSchema();
                if (s == null) {
                    System.out.println("[WARN] parameter skipped because without schema (not yet supported): " + ClientServerGenerator.operationName(pathName, method, operation));
                    return;
                }
                if (p.getName().isEmpty()) {
                    System.out.println("[WARN] parameter skipped because name empty: " + ClientServerGenerator.operationName(pathName, method, operation));
                    return;
                }
                Schema<?> resolvedOriginal = this.resolveRefs(s);
                if (Util.isArray(s)) {
                    isArray = true;
                    s = s.getItems();
                }
                s = this.resolveRefs(s);
                Optional<Object> defaultValue = Optional.ofNullable(s.getDefault());
                String parameterName = Names.toIdentifier(p.getName());
                int i = 2;
                while (parameterNames.contains(parameterName)) {
                    parameterName = Names.toIdentifier(p.getName()) + i;
                    ++i;
                }
                parameterNames.add(parameterName);
                if (Util.isPrimitive(s) && !Util.isEnum(s)) {
                    Class<?> c = Util.toClass(Util.getTypeOrThrow(s), s.getFormat(), s.getExtensions(), this.names.mapIntegerToBigInteger(), this.names.mapNumberToBigDecimal());
                    param = new Param(p.getName(), parameterName, defaultValue, p.getRequired(), c.getCanonicalName(), isArray, false, ClientServerGenerator.constraints(s), ClientServerGenerator.toParamType(p), false, Optional.ofNullable(p.getDescription()), Optional.empty(), Optional.empty());
                } else {
                    Generator.Cls cls = this.schemaCls.get(resolvedOriginal);
                    param = new Param(p.getName(), parameterName, defaultValue, p.getRequired(), cls.fullClassName, isArray, false, ClientServerGenerator.constraints(s), ClientServerGenerator.toParamType(p), true, Optional.ofNullable(p.getDescription()), Optional.empty(), Optional.empty());
                }
                params.add(param);
            });
        }
        if (operation.getRequestBody() != null) {
            RequestBody b = this.resolveRefs(operation.getRequestBody());
            MediaType mediaType = this.mediaType(b.getContent(), "application/json").map(Map.Entry::getValue).orElse(null);
            if (mediaType == null) {
                mediaType = this.mediaType(b.getContent(), "application/xml").map(Map.Entry::getValue).orElse(null);
            }
            boolean isMultipartFormData = mediaType == null ? (mediaType = (MediaType)this.mediaType(b.getContent(), "multipart/form-data").map(Map.Entry::getValue).orElse(null)) != null : false;
            boolean isFormUrlEncoded = mediaType == null ? (mediaType = (MediaType)this.mediaType(b.getContent(), "application/x-www-form-urlencoded").map(Map.Entry::getValue).orElse(null)) != null : false;
            if (mediaType != null) {
                Schema schema = mediaType.getSchema();
                if (schema != null) {
                    if (this.schemaCls.get(schema) == null) throw new RuntimeException("unexpected");
                    String fullClassName = this.resolveRefsFullClassName(schema);
                    ParamType paramType = isMultipartFormData ? ParamType.MULTIPART_FORM_DATA : (isFormUrlEncoded ? ParamType.FORM_URLENCODED : ParamType.BODY);
                    params.add(new Param("requestBody", "requestBody", Optional.ofNullable(schema.getDefault()), (Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)b.getRequired(), (Object)true), fullClassName, false, true, ClientServerGenerator.constraints(schema), paramType, false, Optional.ofNullable(schema.getDescription()), Optional.empty(), Optional.empty()));
                } else {
                    this.addRequestBodyOctetStreamParameter(params, b, Optional.empty());
                }
            } else {
                System.out.println("TODO handle request body with media types " + b.getContent().keySet());
            }
            ArrayList arrayList3 = new ArrayList(b.getContent().keySet());
        }
        Optional<StatusCodeApiResponse> response = ClientServerGenerator.primaryResponse(operation.getResponses());
        Optional<String> primaryStatusCode = response.map(x -> x.statusCode);
        Mutable<Object> primaryMimeType = Mutable.create(null);
        if (response.isPresent() && response.get().response != null && (content = this.resolveResponseRefs(response.get().response).getContent()) != null) {
            primaryMimeType.value = "application/json";
            MediaType mediaType = this.mediaType(content, "application/json").map(Map.Entry::getValue).orElse(null);
            if (mediaType == null) {
                primaryMimeType.value = "application/xml";
                mediaType = this.mediaType(content, (String)primaryMimeType.value).map(Map.Entry::getValue).orElse(null);
            }
            if (mediaType != null) {
                if (mediaType.getSchema() == null) {
                    Optional<String> optional2 = Optional.of(Object.class.getCanonicalName());
                } else {
                    Optional<String> optional3 = Optional.of(this.resolveRefsFullClassName(mediaType.getSchema()));
                }
            } else {
                void var8_14;
                String defaultReturnClassFullName = byte[].class.getCanonicalName();
                Optional<String> optional4 = content.keySet().stream().filter(x -> !"default".equals(x)).map(x -> {
                    primaryMimeType.value = x;
                    if (x.startsWith("text/")) {
                        return String.class.getCanonicalName();
                    }
                    return defaultReturnClassFullName;
                }).findFirst();
                if (!optional4.isPresent()) {
                    primaryMimeType.value = "default";
                    MediaType a = (MediaType)content.get(primaryMimeType.value);
                    if (a == null) {
                        Optional optional5 = Optional.empty();
                    } else {
                        Optional<String> optional6 = Optional.of(this.resolveRefsFullClassName(a.getSchema()));
                    }
                }
                if (!var8_14.isPresent()) {
                    primaryMimeType.value = null;
                }
            }
            statusCode = Optional.of(response.get().statusCode);
            ArrayList arrayList4 = new ArrayList(content.keySet());
        }
        List<ResponseDescriptor> responseDescriptors = this.responseDescriptors(operation);
        boolean includeForServerGeneration = operation.getExtensions() != null ? Boolean.TRUE.equals(operation.getExtensions().getOrDefault("x-openapi-codegen-include-for-server-generation", "")) : true;
        Method m = new Method(methodName, statusCode, params, (Optional<String>)var8_16, pathName, method, (List<String>)var9_19, (List<String>)var10_22, Optional.ofNullable(operation.getDescription()), primaryStatusCode, Optional.ofNullable((String)primaryMimeType.value), responseDescriptors, includeForServerGeneration);
        methods.add(m);
    }

    private static String operationName(String pathName, PathItem.HttpMethod method, Operation operation) {
        return pathName + " " + method + Optional.ofNullable(operation.getOperationId()).map(x -> " [" + x + "]").orElse("");
    }

    private static ParamType toParamType(Parameter p) {
        if (p instanceof QueryParameter) {
            return ParamType.QUERY;
        }
        if (p instanceof PathParameter) {
            return ParamType.PATH;
        }
        if (p instanceof HeaderParameter) {
            return ParamType.HEADER;
        }
        if (p instanceof CookieParameter) {
            return ParamType.COOKIE;
        }
        return ParamType.valueOf(p.getIn().toUpperCase(Locale.ENGLISH));
    }

    private void addRequestBodyOctetStreamParameter(List<Param> params, RequestBody b, Optional<String> contentType) {
        String fullClassName = byte[].class.getCanonicalName();
        params.add(new Param("requestBody", "requestBody", Optional.empty(), (Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)b.getRequired(), (Object)true), fullClassName, false, true, Constraints.empty(), ParamType.BODY, false, Optional.empty(), contentType, Optional.empty()));
    }

    private Optional<Map.Entry<String, MediaType>> mediaType(Content content, String mimeType) {
        return content.entrySet().stream().filter(x -> ((String)x.getKey()).replaceAll(";.*", "").equalsIgnoreCase(mimeType)).findFirst();
    }

    private List<ResponseDescriptor> responseDescriptors(Operation operation) {
        ArrayList<ResponseDescriptor> list = new ArrayList<ResponseDescriptor>();
        operation.getResponses().forEach((statusCode, response) -> {
            if ((response = this.resolveResponseRefs((ApiResponse)response)).getContent() != null) {
                response.getContent().forEach((contentType, mediaType) -> {
                    String fullClassName = mediaType.getSchema() == null ? byte[].class.getCanonicalName() : this.resolveRefsFullClassName(mediaType.getSchema());
                    list.add(new ResponseDescriptor((String)statusCode, (String)contentType, fullClassName));
                });
            }
        });
        return list;
    }

    private RequestBody resolveRefs(RequestBody b) {
        while (b.get$ref() != null) {
            b = this.names.lookupRequestBody(b.get$ref());
        }
        return b;
    }

    private static Constraints constraints(Schema<?> schema) {
        return new Constraints(Optional.ofNullable(schema.getMinLength()), Optional.ofNullable(schema.getMaxLength()), Optional.ofNullable(schema.getMinimum()), Optional.ofNullable(schema.getMaximum()), Optional.ofNullable(schema.getExclusiveMinimumValue()), Optional.ofNullable(schema.getExclusiveMaximumValue()), Optional.ofNullable(schema.getMinItems()), Optional.ofNullable(schema.getMaxItems()), Optional.ofNullable(schema.getPattern()));
    }

    private static Optional<StatusCodeApiResponse> primaryResponse(ApiResponses responses) {
        if (responses.get((Object)"200") != null) {
            return Optional.of(new StatusCodeApiResponse("200", (ApiResponse)responses.get((Object)"200")));
        }
        for (Map.Entry r : responses.entrySet()) {
            if (!ClientServerGenerator.is2XX((String)r.getKey())) continue;
            return Optional.of(new StatusCodeApiResponse((String)r.getKey(), (ApiResponse)r.getValue()));
        }
        return Optional.empty();
    }

    private static boolean is2XX(String key) {
        return key.length() == 3 && key.startsWith("2");
    }

    private Parameter resolveParameterRefs(Parameter p) {
        while (p.get$ref() != null) {
            p = this.names.lookupParameter(p.get$ref());
        }
        return p;
    }

    private ApiResponse resolveResponseRefs(ApiResponse r) {
        while (r.get$ref() != null) {
            String ref = r.get$ref();
            if ((r = this.names.lookupResponse(ref)) != null) continue;
            throw new RuntimeException("could not find response " + ref);
        }
        return r;
    }

    private String resolveRefsFullClassName(Schema<?> schema) {
        return this.schemaCls.get(this.resolveRefs(schema)).fullClassName;
    }

    private Schema<?> resolveRefs(Schema<?> schema) {
        Schema<?> s = schema;
        while (s.get$ref() != null) {
            String ref = s.get$ref();
            Generator.Cls c = this.refCls.get(ref);
            if (c == null) {
                throw new IllegalArgumentException("Cls not found for schema=\n" + schema + "\nrefCls map keys=\n" + this.refCls.keySet());
            }
            s = c.schema.get();
            if (s != null) continue;
            throw new IllegalArgumentException("$ref not found: " + ref);
        }
        return s;
    }

    public static final class Param {
        public final String name;
        public final String identifier;
        public final Optional<Object> defaultValue;
        public final boolean required;
        public final String fullClassName;
        public final boolean isArray;
        public final boolean isRequestBody;
        public final Constraints constraints;
        public final ParamType type;
        public final boolean isComplexQueryParameter;
        public final Optional<String> description;
        public final Optional<String> contentType;
        public final Optional<String> filename;

        public Param(String name, String identifier, Optional<Object> defaultValue, boolean required, String fullClassName, boolean isArray, boolean isRequestBody, Constraints constraints, ParamType type, boolean isComplexQueryParameter, Optional<String> description, Optional<String> contentType, Optional<String> filename) {
            this.name = name;
            this.identifier = identifier;
            this.defaultValue = defaultValue;
            this.required = required;
            this.fullClassName = fullClassName;
            this.isArray = isArray;
            this.isRequestBody = isRequestBody;
            this.constraints = constraints;
            this.type = type;
            this.isComplexQueryParameter = isComplexQueryParameter;
            this.description = description;
            this.contentType = contentType;
            this.filename = filename;
        }

        public String toString() {
            return "Param [" + this.identifier + ", name=" + this.name + ", defaultValue=" + this.defaultValue.orElse("") + ", required=" + this.required + ", cls=" + this.fullClassName + ", isArray=" + this.isArray + ", contentType=" + this.contentType.orElse("") + ", filename=" + this.filename.orElse("") + ", desc='" + this.description.orElse("") + "']";
        }
    }

    public static final class Constraints {
        public final Optional<Integer> minLength;
        public final Optional<Integer> maxLength;
        public final Optional<BigDecimal> min;
        public final Optional<BigDecimal> max;
        public final Optional<BigDecimal> minExclusive;
        public final Optional<BigDecimal> maxExclusive;
        public final Optional<Integer> minItems;
        public final Optional<Integer> maxItems;
        public final Optional<String> pattern;

        public Constraints(Optional<Integer> minLength, Optional<Integer> maxLength, Optional<BigDecimal> min, Optional<BigDecimal> max, Optional<BigDecimal> minExclusive, Optional<BigDecimal> maxExclusive, Optional<Integer> minItems, Optional<Integer> maxItems, Optional<String> pattern) {
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.min = min;
            this.max = max;
            this.minExclusive = minExclusive;
            this.maxExclusive = maxExclusive;
            this.minItems = minItems;
            this.maxItems = maxItems;
            this.pattern = pattern;
        }

        public static Constraints empty() {
            return new Constraints(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public boolean atLeastOnePresent() {
            return this.minLength.isPresent() || this.maxLength.isPresent() || this.min.isPresent() || this.max.isPresent() || this.minExclusive.isPresent() || this.maxExclusive.isPresent() || this.minItems.isPresent() || this.maxItems.isPresent() || this.pattern.isPresent();
        }
    }

    public static final class StatusCodeApiResponse {
        final String statusCode;
        final ApiResponse response;

        StatusCodeApiResponse(String statusCode, ApiResponse response) {
            this.statusCode = statusCode;
            this.response = response;
        }
    }

    public static final class Method {
        public final String methodName;
        public final List<Param> parameters;
        public final Optional<String> returnFullClassName;
        public final String path;
        public final PathItem.HttpMethod httpMethod;
        public final Optional<String> statusCode;
        public final List<String> consumes;
        public final List<String> produces;
        public final Optional<String> description;
        public final Optional<String> primaryStatusCode;
        public final Optional<String> primaryMediaType;
        public final List<ResponseDescriptor> responseDescriptors;
        public final boolean includeForServerGeneration;

        Method(String methodName, Optional<String> statusCode, List<Param> parameters, Optional<String> returnFullClassName, String path, PathItem.HttpMethod httpMethod, List<String> consumes, List<String> produces, Optional<String> description, Optional<String> primaryStatusCode, Optional<String> primaryMediaType, List<ResponseDescriptor> responseDescriptors, boolean ignoreForServerGeneration) {
            this.methodName = methodName;
            this.statusCode = statusCode;
            this.parameters = parameters;
            this.returnFullClassName = returnFullClassName;
            this.path = path;
            this.httpMethod = httpMethod;
            this.consumes = consumes;
            this.produces = produces;
            this.description = description;
            this.primaryStatusCode = primaryStatusCode;
            this.primaryMediaType = primaryMediaType;
            this.responseDescriptors = responseDescriptors;
            this.includeForServerGeneration = ignoreForServerGeneration;
        }

        public Optional<Integer> statusCodeFirstInRange() {
            return this.statusCode.map(x -> x.toUpperCase(Locale.ENGLISH)).map(x -> {
                if (x.endsWith("XX")) {
                    return Integer.parseInt(x.substring(0, 1)) * 100;
                }
                return Integer.parseInt(x);
            });
        }

        public String toString() {
            return "Method [path=" + this.path + ", httpMethod=" + this.httpMethod + ", methodName=" + this.methodName + ", returnCls=" + this.returnFullClassName.orElse("") + ", parameters=" + this.parameters.stream().map(Object::toString).map(x -> "\n    " + x).collect(Collectors.joining()) + ", ignoreForServerGeneration=" + this.includeForServerGeneration;
        }
    }

    public static final class ResponseDescriptor {
        private final String statusCode;
        private final String mediaType;
        private final String fullClassName;

        public ResponseDescriptor(String statusCode, String mediaType, String fullClassName) {
            this.statusCode = statusCode;
            this.mediaType = mediaType;
            this.fullClassName = fullClassName;
        }

        public String statusCode() {
            return this.statusCode;
        }

        public String mediaType() {
            return this.mediaType;
        }

        public String fullClassName() {
            return this.fullClassName;
        }
    }
}

