/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Apis;
import org.davidmoten.oa3.codegen.generator.Definition;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.SchemaWithName;
import org.davidmoten.oa3.codegen.generator.Visitor;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.LinkedStack;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.generator.writer.SchemasCodeWriter;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.util.ImmutableList;
import org.openapitools.jackson.nullable.JsonNullable;

public class Generator {
    private final Definition definition;
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Sets.of((Object[])new String[]{"int", "long", "byte", "float", "double", "boolean", "short"});

    public Generator(Definition definition) {
        this.definition = definition;
    }

    public void generate() {
        Names names = new Names(this.definition);
        Generator.writeSchemaClasses(this.definition, names);
        SchemasCodeWriter.writeGlobalsClass(names);
    }

    private static void writeSchemaClasses(Definition definition, Names names) {
        MyVisitor v = new MyVisitor(names);
        Apis.visitSchemas(names.api(), v);
        for (MyVisitor.Result result : v.results()) {
            Cls cls = result.cls;
            String schemaName = result.name;
            if (!definition.includeSchemas().isEmpty() && !definition.includeSchemas().contains(schemaName) || definition.excludeSchemas().contains(schemaName)) continue;
            names.registerCls(cls);
        }
        HashMap<String, Set<Cls>> fullClassNameInterfaces = new HashMap<String, Set<Cls>>();
        for (MyVisitor.Result result : v.results()) {
            Generator.findFullClassNameInterfaces(result.cls, fullClassNameInterfaces);
        }
        for (MyVisitor.Result result : v.results()) {
            Cls cls = result.cls;
            String schemaName = result.name;
            if (!definition.includeSchemas().isEmpty() && !definition.includeSchemas().contains(schemaName) || definition.excludeSchemas().contains(schemaName)) continue;
            SchemasCodeWriter.writeSchemaClass(names, fullClassNameInterfaces, cls, schemaName);
        }
    }

    private static void findFullClassNameInterfaces(Cls cls, Map<String, Set<Cls>> fullClassNameInterfaces) {
        if (cls.classType == ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            cls.fields.forEach(x -> {
                Set list = fullClassNameInterfaces.computeIfAbsent(x.fullClassName, k -> new HashSet());
                list.add(cls);
            });
        }
    }

    private static boolean isNullable(Schema<?> schema) {
        return Boolean.TRUE.equals(schema.getNullable()) || schema.getTypes() != null && schema.getTypes().contains("null");
    }

    private static Encoding encoding(Schema<?> schema) {
        if ("binary".equals(schema.getFormat())) {
            return Encoding.OCTET;
        }
        return Encoding.DEFAULT;
    }

    private static void updateLinks(Cls cls, Optional<Cls> previous) {
        previous.ifPresent(p -> {
            p.classes.add(cls);
            cls.owner = Optional.of(p);
        });
    }

    private static void handleObject(ImmutableList<SchemaWithName> schemaPath, SchemaWithName last, Schema<?> schema, Cls cls, boolean isArray, Optional<Cls> previous, Optional<String> fieldName) {
        cls.classType = ClassType.CLASS;
        cls.hasProperties = Util.isObject(schema);
        if (!cls.schema.isPresent()) {
            cls.schema = Optional.of(schema);
        }
        boolean required = Generator.fieldIsRequired(schemaPath);
        Optional<MapType> mt = Generator.mapType(schemaPath);
        if (mt.isPresent() && mt.get() == MapType.FIELD) {
            mt = Optional.empty();
        }
        Optional<MapType> mt2 = mt;
        previous.ifPresent(p -> p.addField(cls.fullClassName, last.name, (String)fieldName.get(), required, isArray, mt2, Generator.isNullable(schema)));
    }

    private static boolean isString(Schema<?> schema) {
        return "string".equals(Util.getType(schema).orElse("object"));
    }

    private static boolean fieldIsRequired(ImmutableList<SchemaWithName> schemaPath) {
        SchemaWithName last = (SchemaWithName)schemaPath.last();
        if (schemaPath.size() <= 1) {
            return Util.isPrimitive(last.schema) || Util.isRef(last.schema) || Util.isArray(last.schema);
        }
        return Generator.contains(((SchemaWithName)schemaPath.secondLast()).schema.getRequired(), last.name) || Util.isAllOf(((SchemaWithName)schemaPath.secondLast()).schema) || Util.isArray(((SchemaWithName)schemaPath.secondLast()).schema) || Generator.mapType(schemaPath).equals(Optional.of(MapType.ADDITIONAL_PROPERTIES));
    }

    private static Optional<MapType> mapType(ImmutableList<SchemaWithName> schemaPath) {
        Schema<?> schema = ((SchemaWithName)schemaPath.last()).schema;
        if (schemaPath.size() > 1 && ((SchemaWithName)schemaPath.secondLast()).schema.getAdditionalProperties() == ((SchemaWithName)schemaPath.last()).schema) {
            return Optional.of(MapType.ADDITIONAL_PROPERTIES);
        }
        if (Util.isMap(schema) || Generator.allNulls(schema)) {
            return Optional.of(MapType.FIELD);
        }
        return Optional.empty();
    }

    private static boolean allNulls(Schema<?> s) {
        return s.getClass().equals(Schema.class) && !Util.getType(s).isPresent() && s.getProperties() == null && s.getAdditionalProperties() == null && s.get$ref() == null && s.getAdditionalItems() == null;
    }

    private static void handlePolymorphism(ImmutableList<SchemaWithName> schemaPath, Cls cls, Names names, Optional<Cls> previous, Optional<String> fieldName, boolean isArray) {
        SchemaWithName last = (SchemaWithName)schemaPath.last();
        cls.polymorphicType = Generator.polymorphicType(last.schema);
        io.swagger.v3.oas.models.media.Discriminator discriminator = last.schema.getDiscriminator();
        if (discriminator != null) {
            String propertyName = discriminator.getPropertyName();
            Map<String, String> map = discriminator.getMapping() != null ? discriminator.getMapping().entrySet().stream().collect(Collectors.toMap(x -> names.refToFullClassName((String)x.getValue()), Map.Entry::getKey)) : Collections.emptyMap();
            cls.discriminator = new Discriminator(propertyName, Names.toFieldName(propertyName), map);
        }
        cls.classType = cls.polymorphicType == PolymorphicType.ONE_OF || cls.polymorphicType == PolymorphicType.ANY_OF ? (discriminator != null ? ClassType.ONE_OR_ANY_OF_DISCRIMINATED : (cls.polymorphicType == PolymorphicType.ONE_OF ? ClassType.ONE_OF_NON_DISCRIMINATED : ClassType.ANY_OF_NON_DISCRIMINATED)) : ClassType.ALL_OF;
        boolean required = Generator.fieldIsRequired(schemaPath);
        previous.ifPresent(p -> p.addField(cls.fullClassName, last.name, (String)fieldName.get(), required, isArray, Generator.mapType(schemaPath), Generator.isNullable(((SchemaWithName)schemaPath.last()).schema)));
    }

    private static PolymorphicType polymorphicType(Schema<?> schema) {
        PolymorphicType pt = Util.isOneOf(schema) ? PolymorphicType.ONE_OF : (Util.isAnyOf(schema) ? PolymorphicType.ANY_OF : PolymorphicType.ALL_OF);
        return pt;
    }

    private static void handleEnum(ImmutableList<SchemaWithName> schemaPath, Cls cls, Optional<Cls> previous, boolean isArray, Optional<String> fieldName, Names names) {
        Schema<?> schema = ((SchemaWithName)schemaPath.last()).schema;
        cls.classType = ClassType.ENUM;
        if (!cls.schema.isPresent()) {
            cls.schema = Optional.of(schema);
        }
        Class<?> valueCls = Util.toClass(Util.getTypeOrThrow(schema), schema.getFormat(), schema.getExtensions(), names.mapIntegerToBigInteger(), names.mapNumberToBigDecimal());
        cls.enumValueFullType = valueCls.getCanonicalName();
        Map<String, String> map = Names.getEnumValueToIdentifierMap(schema.getEnum());
        HashSet<String> used = new HashSet<String>();
        for (Object o : schema.getEnum()) {
            if (used.contains(String.valueOf(o))) continue;
            cls.enumMembers.add(new EnumMember(map.get(String.valueOf(o)), o, Generator.isNullable(schema)));
            used.add(String.valueOf(o));
        }
        if (schema.getExtensions() != null && schema.getExtensions().get("x-openapi-codegen-names") != null) {
            List a = (List)schema.getExtensions().get("x-openapi-codegen-names");
            if (a.size() == cls.enumMembers.size()) {
                cls.enumNames = a;
            } else {
                System.out.println("[WARN] x-openapi-codegen-names array length must match number of enum members");
            }
        }
        cls.addField(cls.enumValueFullType, "value", "value", true, false, Generator.mapType(schemaPath), Generator.isNullable(schema));
        boolean required = Generator.fieldIsRequired(schemaPath);
        previous.ifPresent(p -> p.addField(cls.fullClassName, ((SchemaWithName)schemaPath.last()).name, (String)fieldName.get(), required, isArray, Generator.mapType(schemaPath), Generator.isNullable(schema)));
    }

    private static <T> boolean contains(Collection<? extends T> collection, T t) {
        return collection != null && t != null && collection.contains(t);
    }

    private static String toList(String fullClassName, Imports imports, boolean useOptional) {
        if (useOptional) {
            return String.format("%s<%s<%s>>", imports.add(Optional.class), imports.add(List.class), imports.add(fullClassName));
        }
        return String.format("%s<%s>", imports.add(List.class), imports.add(fullClassName));
    }

    private static String resolveCandidateFullClassName(Cls cls, String candidateFullClassName) {
        String s = candidateFullClassName;
        Set<String> ownersAndSiblings = cls.ownersAndSiblingsSimpleNames();
        if (ownersAndSiblings.contains(Names.simpleClassName(s)) || s.equals(cls.fullClassName)) {
            int i = 2;
            while (ownersAndSiblings.contains(Names.simpleClassName(s + i))) {
                ++i;
            }
            s = s + i;
        }
        return s;
    }

    private static ClassType classType(Schema<?> schema) {
        if (Util.isOneOf(schema)) {
            return ClassType.ONE_OF_NON_DISCRIMINATED;
        }
        if (Util.isAnyOf(schema)) {
            return ClassType.ANY_OF_NON_DISCRIMINATED;
        }
        if (Util.isEnum(schema)) {
            return ClassType.ENUM;
        }
        if (Util.isArray(schema)) {
            return ClassType.ARRAY_WRAPPER;
        }
        return ClassType.CLASS;
    }

    public static enum Encoding {
        DEFAULT,
        OCTET;

    }

    public static final class Cls {
        public SchemaCategory category;
        public String fullClassName;
        public Optional<String> description = Optional.empty();
        public ClassType classType;
        public final List<Field> fields = new ArrayList<Field>();
        public List<EnumMember> enumMembers = new ArrayList<EnumMember>();
        public List<String> enumNames = Collections.emptyList();
        public final List<Cls> classes = new ArrayList<Cls>();
        public Discriminator discriminator = null;
        public String enumValueFullType;
        public boolean topLevel = false;
        public boolean hasProperties = false;
        public PolymorphicType polymorphicType;
        public Optional<Cls> owner = Optional.empty();
        public Optional<String> name = Optional.empty();
        public Optional<Schema<?>> schema = Optional.empty();
        private int num = 0;
        private final Set<String> fieldNames = new HashSet<String>();

        public String nextAnonymousFieldName() {
            ++this.num;
            return "option" + this.num;
        }

        public String nextFieldName(String name, Schema<?> schema) {
            String next;
            Optional<String> nameOverride = Util.extensionString(schema, "x-openapi-codegen-name");
            if (nameOverride.isPresent()) {
                name = nameOverride.get();
            }
            if (Util.isNullOrBlank(name)) {
                next = this.nextAnonymousFieldName();
            } else {
                String a;
                String s = Names.toFieldName(name);
                int i = 0;
                while (this.fieldNames.contains(a = i > 0 ? s + i : s)) {
                    ++i;
                }
                next = a;
            }
            this.fieldNames.add(next);
            return next;
        }

        public String fieldName(Field f) {
            if (this.unwrapSingleField()) {
                return "value";
            }
            return f.fieldName;
        }

        void addField(String fullType, String name, String fieldName, boolean required, boolean isArray, Optional<MapType> mapType, boolean nullable, boolean readOnly, boolean writeOnly) {
            this.addField(fullType, name, fieldName, required, isArray, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Encoding.DEFAULT, mapType, nullable, readOnly, writeOnly);
        }

        void addField(String fullType, String name, String fieldName, boolean required, boolean isArray, Optional<MapType> mapType, boolean nullable) {
            this.addField(fullType, name, fieldName, required, isArray, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Encoding.DEFAULT, mapType, nullable, false, false);
        }

        void addField(String fullType, String name, String fieldName, boolean required, boolean isArray, Optional<Integer> minItems, Optional<Integer> maxItems, Optional<Integer> minLength, Optional<Integer> maxLength, Optional<String> pattern, Optional<BigDecimal> min, Optional<BigDecimal> max, boolean exclusiveMin, boolean exclusiveMax, Encoding encoding, Optional<MapType> mapType, boolean nullable, boolean readOnly, boolean writeOnly) {
            this.fields.add(new Field(fullType, name, fieldName, required, isArray, minItems, maxItems, minLength, maxLength, pattern, min, max, exclusiveMin, exclusiveMax, encoding, mapType, nullable, readOnly, writeOnly));
        }

        public String pkg() {
            return Names.pkg(this.fullClassName);
        }

        public String simpleName() {
            return Names.simpleClassName(this.fullClassName);
        }

        public boolean unwrapSingleField() {
            return !this.hasProperties && (this.classType == ClassType.ENUM || this.classType == ClassType.ARRAY_WRAPPER || this.topLevel && this.fields.size() == 1) || this.classType == ClassType.ONE_OF_NON_DISCRIMINATED;
        }

        public Set<String> ownersAndSiblingsSimpleNames() {
            Cls c = this;
            HashSet<String> set = new HashSet<String>();
            while (c.owner.isPresent()) {
                set.add(c.owner.get().simpleName());
                c = c.owner.get();
            }
            this.classes.stream().filter(x -> x.fullClassName != null).forEach(x -> set.add(x.simpleName()));
            return set;
        }

        public boolean isNullableEnum() {
            return !this.enumMembers.isEmpty() && this.enumMembers.get((int)0).nullable;
        }

        public boolean hasEnumNullValue() {
            return this.enumMembers.stream().anyMatch(x -> x.parameter == null);
        }

        public boolean hasEncoding() {
            return this.schema.isPresent() && this.schema.get().getExtensions() != null && Boolean.TRUE.equals(Util.extension(this.schema.get(), "x-openapi-codegen-internal-has-encoding").orElse(null));
        }
    }

    public static enum ClassType {
        CLASS("class"),
        ENUM("enum"),
        ONE_OR_ANY_OF_DISCRIMINATED("interface"),
        ONE_OF_NON_DISCRIMINATED("class"),
        ANY_OF_NON_DISCRIMINATED("class"),
        ALL_OF("class"),
        ARRAY_WRAPPER("class");

        private final String word;

        private ClassType(String word) {
            this.word = word;
        }

        public String word() {
            return this.word;
        }
    }

    public static final class MyVisitor
    implements Visitor {
        private final Names names;
        private final LinkedStack<Cls> stack = new LinkedStack();
        private final List<Result> results = new ArrayList<Result>();

        public MyVisitor(Names names) {
            this.names = names;
        }

        @Override
        public void startSchema(SchemaCategory category, ImmutableList<SchemaWithName> schemaPath) {
            Optional<Integer> maxItems;
            SchemaWithName last = (SchemaWithName)schemaPath.last();
            Schema<?> schema = last.schema;
            Cls cls = new Cls();
            cls.category = category;
            cls.description = Optional.ofNullable(schema.getDescription());
            if (this.stack.isEmpty()) {
                cls.fullClassName = this.names.schemaNameToFullClassName(cls.category, last.name);
                cls.name = Optional.of(last.name);
                cls.schema = Optional.of(schema);
                cls.classType = Generator.classType(schema);
                cls.topLevel = true;
            }
            if (Util.isArray(schema)) {
                Optional<Cls> previous = Optional.ofNullable(this.stack.peek());
                Generator.updateLinks(cls, previous);
                if (previous.isPresent()) {
                    Optional<String> fieldName = Optional.of(previous.get().nextFieldName(last.name, schema));
                    String candidate = previous.get().fullClassName + "." + this.names.simpleClassNameFromSimpleName(fieldName.get());
                    cls.fullClassName = Generator.resolveCandidateFullClassName(cls, candidate);
                    boolean required = Generator.fieldIsRequired((ImmutableList<SchemaWithName>)schemaPath);
                    previous.ifPresent(p -> p.addField(cls.fullClassName, last.name, (String)fieldName.get(), required, ((Cls)previous.get()).classType == ClassType.ARRAY_WRAPPER, Generator.mapType((ImmutableList<SchemaWithName>)schemaPath), Generator.isNullable(schema)));
                } else {
                    cls.fullClassName = this.names.schemaNameToFullClassName(cls.category, last.name);
                }
                cls.classType = ClassType.ARRAY_WRAPPER;
                this.stack.push(cls);
                return;
            }
            boolean isArray = schemaPath.size() >= 2 && ((SchemaWithName)schemaPath.secondLast()).schema instanceof ArraySchema;
            Optional<Integer> minItems = isArray ? Optional.ofNullable(((SchemaWithName)schemaPath.secondLast()).schema.getMinItems()) : Optional.empty();
            Optional<Integer> optional = maxItems = isArray ? Optional.ofNullable(((SchemaWithName)schemaPath.secondLast()).schema.getMaxItems()) : Optional.empty();
            if (Util.isObject(schema) || Util.isMap(schema) || Util.isEnum(schema) || Util.isOneOf(schema) || Util.isAnyOf(schema) || Util.isAllOf(schema)) {
                Optional<Object> fieldName;
                Optional<Cls> previous = Optional.ofNullable(this.stack.peek());
                this.stack.push(cls);
                Generator.updateLinks(cls, previous);
                if (previous.isPresent()) {
                    fieldName = Optional.of(previous.get().nextFieldName(last.name, schema));
                    String candidate = previous.get().fullClassName + "." + this.names.simpleClassNameFromSimpleName((String)fieldName.get());
                    String candidate2 = Generator.resolveCandidateFullClassName(cls, candidate);
                    cls.fullClassName = Generator.resolveCandidateFullClassName(cls.owner.get(), candidate2);
                } else {
                    String candidate;
                    fieldName = Optional.empty();
                    cls.fullClassName = candidate = this.names.schemaNameToFullClassName(cls.category, last.name);
                }
                if (Util.isEnum(schema)) {
                    Generator.handleEnum((ImmutableList<SchemaWithName>)schemaPath, cls, previous, isArray, fieldName, this.names);
                } else if (Util.isObject(schema)) {
                    Generator.handleObject((ImmutableList<SchemaWithName>)schemaPath, last, schema, cls, isArray, previous, fieldName);
                } else if (Util.isOneOf(schema) || Util.isAnyOf(schema) || Util.isAllOf(schema)) {
                    Generator.handlePolymorphism((ImmutableList<SchemaWithName>)schemaPath, cls, this.names, previous, fieldName, isArray);
                } else {
                    cls.fullClassName = previous + ".Unknown";
                    cls.classType = ClassType.CLASS;
                }
            } else {
                boolean writeOnly;
                if (this.stack.isEmpty()) {
                    this.stack.push(cls);
                }
                Cls current = this.stack.peek();
                boolean readOnly = Boolean.TRUE.equals(schema.getReadOnly()) && this.names.applyReadOnly();
                boolean bl = writeOnly = Boolean.TRUE.equals(schema.getWriteOnly()) && this.names.applyWriteOnly();
                if (Util.isPrimitive(schema)) {
                    Optional<String> pattern;
                    Optional<Integer> maxLength;
                    Optional<Integer> minLength;
                    Class<?> c = Util.toClass(Util.getTypeOrThrow(schema), schema.getFormat(), schema.getExtensions(), this.names.mapIntegerToBigInteger(), this.names.mapNumberToBigDecimal());
                    String fullClassName = c.getCanonicalName();
                    if (Generator.isString(schema)) {
                        minLength = Optional.ofNullable(schema.getMinLength());
                        maxLength = Optional.ofNullable(schema.getMaxLength());
                        pattern = Optional.ofNullable(schema.getPattern());
                    } else {
                        minLength = Optional.empty();
                        maxLength = Optional.empty();
                        pattern = Optional.empty();
                    }
                    String fieldName = schemaPath.size() == 1 ? "value" : current.nextFieldName(last.name, schema);
                    boolean required = Generator.fieldIsRequired((ImmutableList<SchemaWithName>)schemaPath);
                    Encoding encoding = Generator.encoding(schema);
                    Optional<BigDecimal> min = Optional.ofNullable(schema.getMinimum());
                    Optional<BigDecimal> max = Optional.ofNullable(schema.getMaximum());
                    boolean exclusiveMin = (Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)schema.getExclusiveMinimum(), (Object)false);
                    boolean exclusiveMax = (Boolean)org.davidmoten.oa3.codegen.util.Util.orElse((Object)schema.getExclusiveMaximum(), (Object)false);
                    current.addField(fullClassName, last.name, fieldName, required, isArray, minItems, maxItems, minLength, maxLength, pattern, min, max, exclusiveMin, exclusiveMax, encoding, Generator.mapType((ImmutableList<SchemaWithName>)schemaPath), Generator.isNullable(schema), readOnly, writeOnly);
                } else if (Util.isRef(schema)) {
                    String fullClassName = this.names.refToFullClassName(schema.get$ref());
                    String fieldNameCandidate = (String)org.davidmoten.oa3.codegen.util.Util.orElse((Object)last.name, (Object)Names.simpleClassName(fullClassName));
                    String fieldName = current.nextFieldName(fieldNameCandidate, schema);
                    boolean required = Generator.fieldIsRequired((ImmutableList<SchemaWithName>)schemaPath);
                    current.addField(fullClassName, last.name, fieldName, required, isArray, minItems, maxItems, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, false, Encoding.DEFAULT, Generator.mapType((ImmutableList<SchemaWithName>)schemaPath), Generator.isNullable(schema), false, false);
                } else {
                    String fieldName = current.nextFieldName(last.name, schema);
                    boolean required = Generator.fieldIsRequired((ImmutableList<SchemaWithName>)schemaPath);
                    current.addField(Object.class.getCanonicalName(), last.name, fieldName, required, isArray, Generator.mapType((ImmutableList<SchemaWithName>)schemaPath), Generator.isNullable(schema));
                }
            }
        }

        @Override
        public void finishSchema(SchemaCategory category, ImmutableList<SchemaWithName> schemaPath) {
            Cls cls = this.stack.peek();
            if (Apis.isComplexSchema(((SchemaWithName)schemaPath.last()).schema) || Util.isEnum(((SchemaWithName)schemaPath.last()).schema) || schemaPath.size() == 1) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.results.add(new Result(cls, ((SchemaWithName)schemaPath.first()).name));
                }
            }
        }

        List<Result> results() {
            return this.results;
        }

        static final class Result {
            final Cls cls;
            final String name;

            Result(Cls cls, String name) {
                this.cls = cls;
                this.name = name;
            }
        }
    }

    public static enum MapType {
        ADDITIONAL_PROPERTIES,
        FIELD;

    }

    public static final class Discriminator {
        public final String propertyName;
        public final String fieldName;
        public final Map<String, String> fullClassNameToPropertyValue;

        public Discriminator(String propertyName, String fieldName, Map<String, String> fullClassNameToPropertyValue) {
            this.propertyName = propertyName;
            this.fieldName = fieldName;
            this.fullClassNameToPropertyValue = fullClassNameToPropertyValue;
        }

        public String discriminatorValueFromFullClassName(String fullClassName) {
            String value = this.fullClassNameToPropertyValue.get(fullClassName);
            if (value == null) {
                return Names.simpleClassName(fullClassName);
            }
            return value;
        }
    }

    public static class EnumMember {
        public final String name;
        public final Object parameter;
        public final boolean nullable;

        public EnumMember(String name, Object parameter, boolean nullable) {
            this.name = name;
            this.parameter = parameter;
            this.nullable = nullable;
        }
    }

    public static final class Field {
        public final String fullClassName;
        public final String name;
        public final String fieldName;
        private static final Set<String> NUMERIC_CLASS_NAMES = Sets.of((Object[])new String[]{"int", "long", "float", "double", "short", Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), Short.class.getCanonicalName(), BigInteger.class.getCanonicalName(), BigDecimal.class.getCanonicalName()});
        public final boolean required;
        public final Optional<Integer> minLength;
        public final Optional<Integer> maxLength;
        public final Optional<String> pattern;
        public final Optional<BigDecimal> min;
        public final Optional<BigDecimal> max;
        public final boolean isArray;
        public final Encoding encoding;
        public final boolean exclusiveMin;
        public final boolean exclusiveMax;
        public final Optional<Integer> minItems;
        public final Optional<Integer> maxItems;
        public final Optional<MapType> mapType;
        public final boolean readOnly;
        public final boolean writeOnly;
        public final boolean nullable;

        Field(String fullClassName, String name, String fieldName, boolean required, boolean isArray, Optional<Integer> minItems, Optional<Integer> maxItems, Optional<Integer> minLength, Optional<Integer> maxLength, Optional<String> pattern, Optional<BigDecimal> min, Optional<BigDecimal> max, boolean exclusiveMin, boolean exclusiveMax, Encoding encoding, Optional<MapType> mapType, boolean nullable, boolean readOnly, boolean writeOnly) {
            this.fullClassName = fullClassName;
            this.name = name;
            this.fieldName = fieldName;
            this.required = required;
            this.isArray = isArray;
            this.minItems = minItems;
            this.maxItems = maxItems;
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.pattern = pattern;
            this.exclusiveMin = exclusiveMin;
            this.exclusiveMax = exclusiveMax;
            this.encoding = encoding;
            this.min = min;
            this.max = max;
            this.mapType = mapType;
            this.nullable = nullable;
            this.readOnly = readOnly;
            this.writeOnly = writeOnly;
        }

        public String fieldName(Cls cls) {
            return cls.fieldName(this);
        }

        public Optional<String> resolvedTypePublicConstructorNonOptional(Imports imports) {
            if (this.isOctets()) {
                if (this.required) {
                    return Optional.empty();
                }
                return Optional.of("byte[]");
            }
            if (this.isArray) {
                return Optional.empty();
            }
            if (this.nullable) {
                return Optional.of(imports.add(this.fullClassName));
            }
            if (this.required) {
                return Optional.empty();
            }
            return Optional.of(imports.add(Util.toPrimitive(this.fullClassName)));
        }

        public String resolvedType(Imports imports) {
            if (this.mapType.isPresent()) {
                return this.resolvedTypeMapPublic(imports);
            }
            return this.resolvedTypePublicConstructor(imports);
        }

        public String resolvedTypePublicConstructor(Imports imports) {
            if (this.isOctets()) {
                if (this.isArray) {
                    if (this.required && !this.readOnly && !this.writeOnly) {
                        return String.format("%s<byte[]>", imports.add(List.class));
                    }
                    return String.format("%s<%s<byte[]>>", imports.add(Optional.class), imports.add(List.class));
                }
                if (!this.required && this.nullable) {
                    return String.format("%s<%s>", imports.add(JsonNullable.class), "byte[]");
                }
                if (!this.required || this.nullable || this.readOnly || this.writeOnly) {
                    return String.format("%s<%s>", imports.add(Optional.class), "byte[]");
                }
                return "byte[]";
            }
            if (this.isArray) {
                if (this.nullable) {
                    return String.format("%s<%s<%s>>", imports.add(List.class), imports.add(JsonNullable.class), imports.add(this.fullClassName));
                }
                return Generator.toList(this.fullClassName, imports, !this.required || this.readOnly || this.writeOnly);
            }
            if (this.nullable) {
                if (this.required) {
                    return String.format("%s<%s>", imports.add(Optional.class), imports.add(this.fullClassName));
                }
                return String.format("%s<%s>", imports.add(JsonNullable.class), imports.add(this.fullClassName));
            }
            if (this.required && !this.readOnly && !this.writeOnly) {
                return imports.add(Util.toPrimitive(this.fullClassName));
            }
            return imports.add(Optional.class) + "<" + imports.add(this.fullClassName) + ">";
        }

        private String resolvedTypeMapIsArray(Imports imports, String t) {
            if (this.nullable) {
                return String.format("%s<%s<%s<%s, %s>>>", imports.add(List.class), imports.add(JsonNullable.class), imports.add(Map.class), imports.add(String.class), t);
            }
            return String.format("%s<%s<%s, %s>>", imports.add(List.class), imports.add(Map.class), imports.add(String.class), t);
        }

        public String resolvedTypeMapPublic(Imports imports) {
            String t = this.isOctets() ? "byte[]" : (this.isMapType(MapType.ADDITIONAL_PROPERTIES) && this.nullable ? String.format("%s<%s>", imports.add(JsonNullable.class), imports.add(this.fullClassName)) : imports.add(this.fullClassName));
            if (this.isArray) {
                return this.resolvedTypeMapIsArray(imports, t);
            }
            if (this.nullable && !this.isMapType(MapType.ADDITIONAL_PROPERTIES)) {
                if (this.required) {
                    return String.format("%s<%s<%s, %s>>", imports.add(Optional.class), imports.add(Map.class), imports.add(String.class), t);
                }
                return String.format("%s<%s<%s, %s>>", imports.add(JsonNullable.class), imports.add(Map.class), imports.add(String.class), t);
            }
            if (this.required) {
                return String.format("%s<%s, %s>", imports.add(Map.class), imports.add(String.class), t);
            }
            return String.format("%s<%s<%s, %s>>", imports.add(Optional.class), imports.add(Map.class), imports.add(String.class), t);
        }

        public boolean isPrimitive() {
            return this.required && PRIMITIVE_CLASS_NAMES.contains(Util.toPrimitive(this.fullClassName));
        }

        public boolean isOctets() {
            return this.encoding == Encoding.OCTET;
        }

        public boolean isByteArray() {
            return this.fullClassName.equals("byte[]");
        }

        public boolean isAdditionalProperties() {
            return this.mapType.equals(Optional.of(MapType.ADDITIONAL_PROPERTIES));
        }

        public boolean isMapType(MapType mt) {
            Preconditions.checkNotNull((Object)((Object)mt));
            return this.mapType.equals(Optional.of(mt));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Field [fullClassName=");
            builder.append(this.fullClassName);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", fieldName=");
            builder.append(this.fieldName);
            builder.append(", required=");
            builder.append(this.required);
            builder.append(", isArray=");
            builder.append(this.isArray);
            builder.append(", mapType=");
            builder.append(this.mapType);
            builder.append(", nullable=");
            builder.append(this.nullable);
            builder.append(", readOnly=");
            builder.append(this.readOnly);
            builder.append(", writeOnly=");
            builder.append(this.writeOnly);
            builder.append("]");
            return builder.toString();
        }

        public boolean isDateOrTime() {
            return this.fullClassName.equals(LocalDate.class.getCanonicalName()) || this.fullClassName.equals(OffsetDateTime.class.getCanonicalName());
        }

        public boolean isNumber() {
            return NUMERIC_CLASS_NAMES.contains(this.fullClassName);
        }
    }
}

