/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.exception.ReadContentException;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.ScalarStyle;

public final class EnhancedOpenAPIV3Parser
extends OpenAPIV3Parser {
    private static final String encoding = StandardCharsets.UTF_8.displayName();
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhancedOpenAPIV3Parser.class);

    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        try {
            String content = EnhancedOpenAPIV3Parser.doubleQuoteStrings(this.readContentFromLocation(url, EnhancedOpenAPIV3Parser.emptyListIfNull(auth)));
            LOGGER.debug("Loaded raw data: {}", (Object)content);
            return this.readContents(content, auth, options, url);
        }
        catch (ReadContentException e) {
            LOGGER.warn("Exception while reading:", (Throwable)e);
            return SwaggerParseResult.ofError((String)e.getMessage());
        }
    }

    private static String doubleQuoteStrings(String data) {
        if (data.startsWith("{")) {
            return data;
        }
        Load load = new Load(LoadSettings.builder().setCodePointLimit(Integer.MAX_VALUE).build());
        Iterator it = load.loadAllFromString(data).iterator();
        DumpSettings settings = DumpSettings.builder().setDefaultScalarStyle(ScalarStyle.DOUBLE_QUOTED).build();
        Dump dump = new Dump(settings);
        return dump.dumpAllToString(it);
    }

    private String readContentFromLocation(String location, List<AuthorizationValue> auth) {
        String adjustedLocation = location.replaceAll("\\\\", "/");
        try {
            Path path;
            if (adjustedLocation.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                return RemoteUrl.urlToString((String)adjustedLocation, auth);
            }
            if (adjustedLocation.toLowerCase(Locale.ENGLISH).startsWith("jar:")) {
                InputStream in = new URI(adjustedLocation).toURL().openStream();
                return IOUtils.toString((InputStream)in, (String)encoding);
            }
            String fileScheme = "file:";
            Path path2 = path = adjustedLocation.toLowerCase(Locale.ENGLISH).startsWith("file:") ? Paths.get(URI.create(adjustedLocation)) : Paths.get(adjustedLocation, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                return FileUtils.readFileToString((File)path.toFile(), (String)encoding);
            }
            return ClasspathHelper.loadFileFromClasspath((String)adjustedLocation);
        }
        catch (SSLHandshakeException e) {
            String message = String.format("Unable to read location `%s` due to a SSL configuration error. It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority.", adjustedLocation);
            throw new ReadContentException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new ReadContentException(String.format("Unable to read location `%s`", adjustedLocation), (Throwable)e);
        }
    }

    private static <T> List<T> emptyListIfNull(List<T> list) {
        return Objects.isNull(list) ? new ArrayList() : list;
    }
}

