/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.internal.Util;

public final class Imports {
    private final String fullClassName;
    private final Predicate<String> simpleNameInPackage;
    private final String basePackagePrefix;
    private final Map<String, String> map = new HashMap<String, String>();

    public Imports(String fullClassName, Predicate<String> simpleNameInPackage) {
        this.fullClassName = fullClassName;
        this.simpleNameInPackage = simpleNameInPackage;
        this.basePackagePrefix = Imports.packagePrefix(fullClassName);
        this.add(fullClassName);
    }

    public String add(Class<?> cls) {
        return this.add(cls.getCanonicalName().replace("$", "."));
    }

    public String add(String className) {
        if (className.endsWith("[]") && Util.isPrimitiveFullClassName(className.substring(0, className.length() - 2))) {
            return className;
        }
        String extendedSimpleName = Imports.extendedSimpleName(this.fullClassName, className);
        String c = this.map.get(extendedSimpleName);
        String pp = Imports.packagePrefix(className);
        boolean inPackage = this.simpleNameInPackage.test(Imports.packagePrefix(this.fullClassName) + Imports.firstSegment(extendedSimpleName));
        if (className.equals(this.fullClassName)) {
            return extendedSimpleName;
        }
        if (!(c != null || extendedSimpleName.equals(Imports.simpleName(this.fullClassName)) || this.basePackagePrefix.equals(pp) && inPackage && !Imports.pkg(this.fullClassName).equals(Imports.pkg(className)))) {
            this.map.put(Imports.simpleName(extendedSimpleName), className);
            return extendedSimpleName;
        }
        if (c != null && c.equals(className)) {
            return extendedSimpleName;
        }
        return className;
    }

    private static String packagePrefix(String fullClassName) {
        int i = fullClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return fullClassName.substring(0, i + 1);
    }

    private static String extendedSimpleName(String baseClassName, String className) {
        if (className.equals(baseClassName)) {
            return Imports.simpleName(className);
        }
        if (className.startsWith(baseClassName + ".")) {
            return className.substring(baseClassName.length() + 1);
        }
        return Imports.simpleName(className);
    }

    private static String simpleName(String className) {
        int i = className.lastIndexOf(46);
        String simpleName = i == -1 ? className : className.substring(i + 1);
        return simpleName;
    }

    public String toString() {
        String pkgFullClassName = Imports.pkg(this.fullClassName);
        String x = this.map.values().stream().sorted().filter(c -> !c.equals("boolean")).filter(c -> !c.equals("short")).filter(c -> !c.equals("float")).filter(c -> !c.equals("double")).filter(c -> !c.equals("int")).filter(c -> !c.equals("byte")).filter(c -> !c.equals("long")).filter(c -> !c.equals(this.fullClassName)).filter(c -> !c.startsWith(this.fullClassName + ".")).filter(c -> !Imports.pkg(c).equals(pkgFullClassName)).map(Imports.process()).collect(Collectors.joining("\n"));
        if (!x.isEmpty()) {
            x = x + "\n";
        }
        return x;
    }

    private static Function<String, String> process() {
        return new Function<String, String>(){
            String previous;

            @Override
            public String apply(String c) {
                String firstSegment = Imports.firstSegment(c);
                boolean insertBlankLine = this.previous != null && !firstSegment.equals(this.previous);
                this.previous = firstSegment;
                return (insertBlankLine ? "\n" : "") + "import " + c + ";";
            }
        };
    }

    private static String pkg(String fullClassName) {
        int i = fullClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return fullClassName.substring(0, i);
    }

    private static String firstSegment(String s) {
        int i = s.indexOf(46);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    public String fullClassName() {
        return this.fullClassName;
    }
}

