/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import com.github.davidmoten.guavamini.Maps;
import com.github.davidmoten.guavamini.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.davidmoten.oa3.codegen.generator.internal.Annotation;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.text.utils.WordWrap;

public final class Javadoc {
    private static final int MAX_JAVADOC_WIDTH = 80;

    public static boolean printJavadoc(CodePrintWriter out, Indent indent, String text, boolean isHtml) {
        Preconditions.checkNotNull((Object)text);
        return Javadoc.printJavadoc(out, Optional.of(text), Collections.emptyList(), Optional.empty(), Optional.empty(), Collections.emptyMap(), isHtml, Maps.empty());
    }

    public static boolean printJavadoc(CodePrintWriter p, Optional<String> text, List<Annotation> annotations, Optional<String> preamble, Optional<String> returns, Map<String, String> parameterDoc, boolean isHtml, Map<String, String> throwing) {
        boolean hasText = text.isPresent() || !annotations.isEmpty() || returns.isPresent();
        boolean addParagraph = false;
        if (hasText) {
            p.println();
            p.line("/**", new Object[0]);
            if (preamble.isPresent()) {
                p.line(" * %s", Javadoc.encodeAndWrapForJavadoc(preamble.get(), p.indent(), false));
                addParagraph = true;
            }
        }
        if (text.isPresent()) {
            if (addParagraph) {
                p.line(" * <p>", new Object[0]);
            }
            p.line(" * %s", Javadoc.encodeAndWrapForJavadoc(text.get(), p.indent(), isHtml));
        }
        annotations.forEach(a -> {
            p.line(" * <p>", new Object[0]);
            p.line(" * <b>%s</b>", a.getTerm());
            if (a.getString().isPresent()) {
                p.line(" * <p>", new Object[0]);
                p.line(" * %s", a.getString().get());
            }
            if (a.getBool().isPresent()) {
                p.line(" * <p>", new Object[0]);
                p.line(" * %s", a.getBool().get());
            }
            for (String record : a.getRecords()) {
                p.line(" * <p>", new Object[0]);
                p.line(" * %s", record);
            }
        });
        if (hasText) {
            boolean first = true;
            for (Map.Entry<String, String> entry2 : parameterDoc.entrySet()) {
                if (first) {
                    p.line(" * ", new Object[0]);
                    first = false;
                }
                p.line(" * @param %s", entry2.getKey());
                String encoded = Javadoc.encodeAndWrapForJavadoc(entry2.getValue(), true, String.format("\n%s *            ", p.indent()));
                p.line(" *            %s", encoded);
            }
            if (returns.isPresent()) {
                if (first) {
                    p.line(" * ", new Object[0]);
                }
                p.line(" * @return %s", returns.get());
            }
            if (!throwing.isEmpty()) {
                if (first) {
                    p.line(" * ", new Object[0]);
                }
                throwing.entrySet().stream().forEach(entry -> {
                    p.line(" * @throws %s", entry.getKey());
                    p.line(" *             %s", entry.getValue());
                });
            }
            p.line(" */", new Object[0]);
        }
        return hasText;
    }

    private static String encodeAndWrapForJavadoc(String s, Indent indent, boolean isHtml) {
        return Javadoc.encodeAndWrapForJavadoc(s, isHtml, String.format("\n%s * ", indent));
    }

    private static String encodeAndWrapForJavadoc(String s, boolean isHtml, String linePrefix) {
        s = s.trim().replace("{@link ", "{@code ").replace("{@", "zxxz");
        if (!isHtml) {
            s = Javadoc.wrap(s);
        }
        return Javadoc.encodeJavadoc(s, isHtml).replace("\n", linePrefix).replace("zxxz", "{@");
    }

    private static String encodeJavadoc(String x, boolean isHtml) {
        x = x.replace("@", "&#064;").replace("\\", "{@literal \\}");
        x = isHtml ? x.replace("</p>", "") : x.replace("<", "&lt;").replace(">", "&gt;");
        return x.replace("*/", "*&#47;");
    }

    private static String wrap(String s) {
        return WordWrap.from((CharSequence)s).breakWords(false).extraWordChars("0123456789").maxWidth((Number)80).newLine("\n").wrap().trim();
    }
}

