/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Util {
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Sets.of((Object[])new String[]{"int", "double", "float", "long", "boolean", "byte", "short"});

    public static String getTypeOrThrow(Schema<?> schema) {
        return Util.getType(schema).orElseThrow(() -> new IllegalStateException("no type found for\n" + schema));
    }

    public static Optional<String> getType(Schema<?> schema) {
        if (schema.getType() == null) {
            if (schema.getTypes() != null) {
                return schema.getTypes().stream().filter(x -> !"null".equals(x)).findFirst();
            }
            return Optional.empty();
        }
        return Optional.of(schema.getType());
    }

    public static boolean isPrimitiveFullClassName(String className) {
        return PRIMITIVE_CLASS_NAMES.contains(className);
    }

    public static boolean isPrimitive(Schema<?> schema) {
        String type = Util.getType(schema).orElse("object");
        return !"array".equals(type) && !"object".equals(type);
    }

    public static boolean isEnum(Schema<?> schema) {
        return schema.getEnum() != null && !schema.getEnum().isEmpty();
    }

    public static boolean isRef(Schema<?> schema) {
        return schema.get$ref() != null;
    }

    public static boolean isObject(Schema<?> schema) {
        Optional<String> type = Util.getType(schema);
        return !type.isPresent() && schema.getProperties() != null || "object".equals(type.orElse(""));
    }

    public static boolean isArray(Schema<?> schema) {
        return schema instanceof ArraySchema;
    }

    public static boolean isOneOf(Schema<?> schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema sch = (ComposedSchema)schema;
        return sch.getOneOf() != null && !sch.getOneOf().isEmpty();
    }

    public static boolean isAnyOf(Schema<?> schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema sch = (ComposedSchema)schema;
        return sch.getAnyOf() != null && !sch.getAnyOf().isEmpty();
    }

    public static boolean isAllOf(Schema<?> schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        ComposedSchema sch = (ComposedSchema)schema;
        return sch.getAllOf() != null && !sch.getAllOf().isEmpty();
    }

    public static boolean isMap(Schema<?> schema) {
        return schema instanceof MapSchema;
    }

    public static Class<?> toClass(String type, String format, Map<String, Object> extensions, boolean mapIntegerToBigInteger, boolean mapDoubleToBigDouble) {
        Preconditions.checkNotNull((Object)type);
        switch (type) {
            case "string": {
                if ("date-time".equals(format)) {
                    return OffsetDateTime.class;
                }
                if ("date".equals(format)) {
                    return LocalDate.class;
                }
                if ("time".equals(format)) {
                    return OffsetTime.class;
                }
                if ("byte".equals(format)) {
                    return byte[].class;
                }
                if ("binary".equals(format)) {
                    return byte[].class;
                }
                return String.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "integer": {
                if ("int32".equals(format)) {
                    return Integer.class;
                }
                if ("int64".equals(format)) {
                    return Long.class;
                }
                return mapIntegerToBigInteger || Util.isArbitraryPrecision(extensions) ? BigInteger.class : Long.class;
            }
            case "number": {
                if ("float".equals(format)) {
                    return Float.class;
                }
                if ("double".equals(format)) {
                    return Double.class;
                }
                return mapDoubleToBigDouble || Util.isArbitraryPrecision(extensions) ? BigDecimal.class : Double.class;
            }
            case "array": {
                return List.class;
            }
            case "object": {
                return Map.class;
            }
        }
        throw new RuntimeException("unexpected type and format: " + type + ", " + format);
    }

    private static boolean isArbitraryPrecision(Map<String, Object> extensions) {
        return extensions != null && "true".equalsIgnoreCase(String.valueOf(extensions.get("x-openapi-codegen-arbitrary-precision")));
    }

    public static String toPrimitive(String canonicalClassName) {
        if (canonicalClassName.equals(Integer.class.getCanonicalName())) {
            return "int";
        }
        if (canonicalClassName.equals(Short.class.getCanonicalName())) {
            return "short";
        }
        if (canonicalClassName.equals(Long.class.getCanonicalName())) {
            return "long";
        }
        if (canonicalClassName.equals(Float.class.getCanonicalName())) {
            return "float";
        }
        if (canonicalClassName.equals(Double.class.getCanonicalName())) {
            return "double";
        }
        if (canonicalClassName.equals(Boolean.class.getCanonicalName())) {
            return "boolean";
        }
        if (canonicalClassName.equals(Byte.class.getCanonicalName())) {
            return "byte";
        }
        return canonicalClassName;
    }

    public static Class<?> toPrimitive(Class<?> c) {
        if (c.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (c.equals(Long.class)) {
            return Long.TYPE;
        }
        if (c.equals(Float.class)) {
            return Float.TYPE;
        }
        if (c.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (c.equals(Short.class)) {
            return Short.TYPE;
        }
        if (c.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (c.equals(BigInteger.class)) {
            return c;
        }
        return c;
    }

    public static Optional<String> extensionString(Schema<?> schema, String key) {
        return Util.extension(schema, key);
    }

    public static Optional<Object> extension(Schema<?> schema, String key) {
        Preconditions.checkNotNull((Object)key);
        Map map = schema.getExtensions();
        if (map == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(map.get(key));
    }

    public static boolean isNullOrBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

