/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.internal;

import jakarta.annotation.Generated;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;

public final class WriterUtil {
    private static final String OPENAPI_CODEGEN_PROPERTIES = "/openapi-codegen.properties";
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("debug", "false"));
    public static final String IMPORTS_HERE = "IMPORTS_HERE";
    public static final String GROUP_ID_ARTIFACT_ID_VERSION = WriterUtil.readMavenCoordinates();

    private static String readMavenCoordinates() {
        String string;
        block8: {
            Properties p = new Properties();
            InputStream in = Generator.class.getResourceAsStream(OPENAPI_CODEGEN_PROPERTIES);
            try {
                p.load(in);
                string = p.get("groupId") + ":" + p.get("artifactId") + ":" + p.get("version");
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public static String readVersion() {
        String string;
        block8: {
            Properties p = new Properties();
            InputStream in = Generator.class.getResourceAsStream(OPENAPI_CODEGEN_PROPERTIES);
            try {
                p.load(in);
                string = String.valueOf(p.get("version"));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public static void closeParen(PrintWriter out, Indent indent) {
        indent.left();
        out.format("%s}\n", indent);
    }

    public static void writeContent(Names names, CodePrintWriter out) {
        String content = out.text().replace(IMPORTS_HERE, out.imports().toString());
        if (DEBUG) {
            System.out.println("////////////////////////////////////////////////");
            System.out.println(content);
        }
        out.close();
        File file = names.fullClassNameToJavaFile(out.fullClassName());
        file.getParentFile().mkdirs();
        try {
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String markdownToHtml(String description) {
        Parser parser = Parser.builder().build();
        Node document = parser.parse(description);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return renderer.render(document);
    }

    public static void writeApiJavadoc(CodePrintWriter out, Names names) {
        String text = Stream.of(Optional.ofNullable(names.api().getInfo().getTitle()), Optional.ofNullable(names.api().getInfo().getSummary()), Optional.ofNullable(names.api().getInfo().getDescription())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("\n\n"));
        if (!Javadoc.printJavadoc(out, out.indent(), WriterUtil.markdownToHtml(text), true)) {
            out.println();
        }
    }

    public static void addGeneratedAnnotation(CodePrintWriter out) {
        out.line("@%s(value = \"%s\")", Generated.class, GROUP_ID_ARTIFACT_ID_VERSION);
    }

    public static String escapePattern(String pattern) {
        return pattern.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

