/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.oa3.codegen.generator.internal.Util;
import org.davidmoten.oa3.codegen.runtime.MapBuilder;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.openapitools.jackson.nullable.JsonNullable;

public class BuilderWriter {
    public static void write(CodePrintWriter out, List<Field> fields, String importedBuiltType) {
        BuilderWriter.write(out, fields, importedBuiltType, false);
    }

    public static void write(CodePrintWriter out, List<Field> fields, String importedBuiltType, boolean useOf) {
        if (fields.isEmpty()) {
            return;
        }
        List settableFields = fields.stream().filter(x -> !((Field)x).valueExpressionFactory.isPresent()).collect(Collectors.toList());
        if (settableFields.size() == 1) {
            BuilderWriter.writeSingleValueStaticFactoryMethods(out, fields, (Field)settableFields.get(0), importedBuiltType);
            return;
        }
        if (settableFields.isEmpty()) {
            BuilderWriter.writeSingletonInstanceGetter(out, fields, importedBuiltType);
            return;
        }
        ArrayList sortedFields = new ArrayList(settableFields);
        sortedFields.sort((a, b) -> Boolean.compare(b.mandatory(), a.mandatory()));
        String builderName = "Builder";
        boolean passBuilderIntoConstructor = false;
        boolean previousWasMandatory = true;
        boolean inFirstBuilder = true;
        Field last = (Field)sortedFields.get(sortedFields.size() - 1);
        Optional<Object> firstFieldStaticMethod = Optional.empty();
        for (Field f : sortedFields) {
            String nextBuilderName = f.mandatory() ? Names.removeLowerCaseVowels("BuilderWith" + Names.upperFirst(f.fieldName), 80) : builderName;
            if (previousWasMandatory) {
                if (!passBuilderIntoConstructor) {
                    out.println();
                    out.line("public static @%s %s builder() {", Nonnull.class, builderName);
                    out.line("return new %s();", builderName);
                    out.closeParen();
                }
                out.println();
                out.line("public static final class %s {", builderName);
                if (passBuilderIntoConstructor) {
                    out.println();
                    out.line("private final Builder b;", new Object[0]);
                    out.println();
                    out.line("%s(Builder b) {", builderName);
                    out.line("this.b = b;", new Object[0]);
                    out.closeParen();
                    inFirstBuilder = false;
                } else {
                    boolean first = true;
                    for (Field fld : sortedFields) {
                        if (first) {
                            out.println();
                            first = false;
                        }
                        if (fld.mapType.isPresent()) {
                            if (fld.isArray) {
                                if (fld.nullable) {
                                    out.line("private %s<%s<%s<%s, %s> %s = new %s<>();", List.class, JsonNullable.class, Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, ArrayList.class);
                                    continue;
                                }
                                out.line("private %s<%s<%s, %s>> %s = new %s<>();", List.class, Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, ArrayList.class);
                                continue;
                            }
                            if (fld.nullable) {
                                if (fld.required && fld.isMapType(Generator.MapType.FIELD)) {
                                    out.line("private %s<%s<%s, %s>> %s = %s.empty();", Optional.class, Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, Optional.class);
                                    continue;
                                }
                                out.line("private %s<%s<%s, %s>> %s = %s.undefined();", JsonNullable.class, Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, JsonNullable.class);
                                continue;
                            }
                            if (fld.required || fld.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
                                out.line("private %s<%s, %s> %s = new %s<>();", Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, HashMap.class);
                                continue;
                            }
                            out.line("private %s<%s<%s, %s>> %s = %s.empty();", Optional.class, Map.class, String.class, out.add(fld.fullClassName), fld.fieldName, Optional.class);
                            continue;
                        }
                        if (fld.nullable) {
                            if (fld.required) {
                                out.line("private %s<%s> %s = %s.empty();", Optional.class, out.add(fld.fullClassName), fld.fieldName, Optional.class);
                                continue;
                            }
                            out.line("private %s<%s> %s = %s.undefined();", JsonNullable.class, out.add(fld.fullClassName), fld.fieldName, JsonNullable.class);
                            continue;
                        }
                        if (fld.required) {
                            if (fld.isArray) {
                                out.line("private %s<%s> %s;", List.class, out.add(fld.fullClassName), fld.fieldName);
                                continue;
                            }
                            out.line("private %s %s;", out.add(Util.toPrimitive(fld.fullClassName)), fld.fieldName);
                            continue;
                        }
                        out.line("private %s %s = %s.empty();", BuilderWriter.enhancedImportedType(fld, out.imports()), fld.fieldName, Optional.class);
                    }
                    out.println();
                    out.line("%s() {", builderName);
                    out.closeParen();
                }
            }
            String builderField = inFirstBuilder ? "" : ".b";
            out.println();
            if (f.mapType.isPresent() && f.mapType.get() == Generator.MapType.ADDITIONAL_PROPERTIES) {
                out.line("public @%s %s<%s, %s> addTo%s(@%s %s key, @%s %s value) {", Nonnull.class, MapBuilder.class, out.add(f.fullClassName), nextBuilderName, Names.upperFirst(f.fieldName), Nonnull.class, String.class, Nonnull.class, out.add(f.fullClassName));
                out.line("%s.checkNotNull(key, \"key\");", Preconditions.class);
                out.line("%s.checkNotNull(value, \"value\");", Preconditions.class);
                out.line("return new %s<%s, %s>(this, x -> this%s.%s = x).add(key, value);", MapBuilder.class, out.add(f.fullClassName), nextBuilderName, builderField, f.fieldName);
                out.closeParen();
                out.println();
                out.line("public @%s %s<%s, %s> addAllTo%s(@%s %s<%s, %s> map) {", Nonnull.class, MapBuilder.class, out.add(f.fullClassName), nextBuilderName, Names.upperFirst(f.fieldName), Nonnull.class, Map.class, String.class, out.add(f.fullClassName));
                out.line("%s.checkNotNull(map, \"map\");", Preconditions.class);
                out.line("return new %s<%s, %s>(this, x -> this%s.%s = x).addAll(map);", MapBuilder.class, out.add(f.fullClassName), nextBuilderName, builderField, f.fieldName);
                out.closeParen();
                out.println();
            }
            out.line("public @%s %s %s(@%s %s %s) {", Nonnull.class, nextBuilderName, f.fieldName, Nonnull.class, BuilderWriter.baseImportedType(f, out.imports()), f.fieldName);
            if (f.mapType.isPresent()) {
                out.line("this%s.%s = %s;", builderField, f.fieldName, f.fieldName);
            } else if (f.mandatory()) {
                out.line("this%s.%s = %s;", builderField, f.fieldName, f.fieldName);
            } else if (f.nullable && !f.required) {
                out.line("this%s.%s = %s.of(%s);", builderField, f.fieldName, JsonNullable.class, f.fieldName);
            } else {
                out.line("this%s.%s = %s.of(%s);", builderField, f.fieldName, Optional.class, f.fieldName);
            }
            if (f.mandatory()) {
                out.line("return new %s(this%s);", nextBuilderName, builderField);
            } else {
                out.line("return this;", new Object[0]);
            }
            out.closeParen();
            if (!f.mandatory() && !f.mapType.isPresent()) {
                out.println();
                out.line("public @%s %s %s(@%s %s %s) {", Nonnull.class, nextBuilderName, f.fieldName, Nonnull.class, BuilderWriter.enhancedImportedType(f, out.imports()), f.fieldName);
                out.line("this%s.%s = %s;", builderField, f.fieldName, f.fieldName);
                out.line("return this;", new Object[0]);
                out.closeParen();
                if (f == last) {
                    BuilderWriter.writeBuildMethod(out, fields, importedBuiltType, builderField, useOf);
                }
            }
            if (!firstFieldStaticMethod.isPresent()) {
                if (f.mandatory()) {
                    Indent indent = out.indent().copy().left();
                    String s = String.format("%spublic static @%s %s %s(@%s %s %s) {\n", indent, out.add(Nonnull.class), nextBuilderName, f.fieldName, out.add(Nonnull.class), BuilderWriter.baseImportedType(f, out.imports()), f.fieldName) + String.format("%sreturn builder().%s(%s);\n", indent.right(), f.fieldName, f.fieldName) + String.format("%s}\n", indent.left());
                    firstFieldStaticMethod = Optional.of(s);
                } else {
                    firstFieldStaticMethod = Optional.of("");
                }
            }
            if (f.mapType.isPresent() && f == last) {
                BuilderWriter.writeBuildMethod(out, fields, importedBuiltType, builderField, useOf);
            }
            if (f.mandatory() || f == last) {
                out.closeParen();
            }
            if (f == last && f.mandatory()) {
                out.println();
                out.line("public static final class %s {", nextBuilderName);
                out.println();
                out.line("private final Builder b;", new Object[0]);
                out.println();
                out.line("%s(%s b) {", nextBuilderName, "Builder");
                out.line("this.b = b;", new Object[0]);
                out.closeParen();
                BuilderWriter.writeBuildMethod(out, fields, importedBuiltType, ".b", useOf);
                out.closeParen();
            }
            passBuilderIntoConstructor = f.mandatory();
            builderName = nextBuilderName;
            previousWasMandatory = f.mandatory();
            out.flush();
        }
        if (!((String)firstFieldStaticMethod.get()).isEmpty()) {
            out.println();
            out.print((String)firstFieldStaticMethod.get());
        }
    }

    private static void writeSingleValueStaticFactoryMethods(CodePrintWriter out, List<Field> fields, Field field, String importedBuiltType) {
        String methodName = "value".equals(field.fieldName) ? "of" : field.fieldName;
        out.println();
        out.line("public static @%s %s %s(@%s %s %s) {", Nonnull.class, importedBuiltType, methodName, Nonnull.class, BuilderWriter.enhancedImportedType(field, out.imports()), field.fieldName);
        String params = fields.stream().map(BuilderWriter::fieldExpression).collect(Collectors.joining(", "));
        out.line("return new %s(%s);", importedBuiltType, params);
        out.closeParen();
        if (!(field.mandatory() || field.mapType.isPresent() || field.isArray)) {
            out.println();
            out.line("public static @%s %s %s(@%s %s %s) {", Nonnull.class, importedBuiltType, field.fieldName, Nonnull.class, BuilderWriter.baseImportedType(field, out.imports()), field.fieldName);
            Class c = field.nullable && !field.required ? JsonNullable.class : Optional.class;
            String params2 = fields.stream().map(x -> {
                if (((Field)x).fieldName.equals(field.fieldName)) {
                    return String.format("%s.of(%s)", out.add(c), ((Field)x).fieldName);
                }
                return BuilderWriter.fieldExpression(x);
            }).collect(Collectors.joining(", "));
            out.line("return new %s(%s);", importedBuiltType, params2);
            out.closeParen();
        }
    }

    private static void writeSingletonInstanceGetter(CodePrintWriter out, List<Field> fields, String importedBuiltType) {
        out.println();
        out.line("private static final %s INSTANCE = ", importedBuiltType);
        String params = fields.stream().map(BuilderWriter::fieldExpression).collect(Collectors.joining(", "));
        out.right().right();
        out.line("new %s(%s);", importedBuiltType, params);
        out.left().left();
        out.println();
        out.line("public static @%s %s instance() {", Nonnull.class, importedBuiltType);
        out.line("return INSTANCE;", new Object[0]);
        out.closeParen();
    }

    private static void writeBuildMethod(CodePrintWriter out, List<Field> fields, String importedBuiltType, String builderField, boolean useOf) {
        out.println();
        out.line("public @%s %s build() {", Nonnull.class, importedBuiltType);
        String params = fields.stream().map(x -> BuilderWriter.fieldExpression(builderField, x)).collect(Collectors.joining(", "));
        if (useOf) {
            out.line("return %s.of(%s);", importedBuiltType, params);
        } else {
            out.line("return new %s(%s);", importedBuiltType, params);
        }
        out.closeParen();
    }

    private static String fieldExpression(Field x) {
        return x.valueExpressionFactory.map(factory -> (String)factory.apply(x.fieldName)).orElse(x.fieldName);
    }

    private static String fieldExpression(String builderField, Field x) {
        String fieldExpression = String.format("this%s.%s", builderField, x.fieldName);
        return x.valueExpressionFactory.map(factory -> (String)factory.apply(fieldExpression)).orElse(fieldExpression);
    }

    private static String baseImportedType(Field f, Imports imports) {
        if (f.mapType.isPresent()) {
            return BuilderWriter.mapImportedTypeNonOptional(f, imports);
        }
        if (f.isArray) {
            return String.format("%s<%s>", imports.add(List.class), imports.add(f.fullClassName));
        }
        return imports.add(Util.toPrimitive(f.fullClassName));
    }

    private static String mapImportedTypeNonOptional(Field f, Imports imports) {
        if (f.isArray) {
            if (f.nullable) {
                if (f.required) {
                    return BuilderWriter.listMapType(f, imports);
                }
                return BuilderWriter.jsonNullableListMapType(f, imports);
            }
            return BuilderWriter.listMapType(f, imports);
        }
        if (f.nullable && !f.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
            if (f.required) {
                return BuilderWriter.mapType(f, imports);
            }
            return BuilderWriter.jsonNullableMap(f, imports);
        }
        return BuilderWriter.mapType(f, imports);
    }

    private static String mapImportedTypePublic(Field f, Imports imports) {
        if (f.isArray) {
            if (f.nullable) {
                return BuilderWriter.listJsonNullableMap(f, imports);
            }
            return BuilderWriter.listMapType(f, imports);
        }
        if (f.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
            return BuilderWriter.mapType(f, imports);
        }
        if (f.nullable) {
            if (f.required) {
                return BuilderWriter.optionalMapType(f, imports);
            }
            return BuilderWriter.jsonNullableMap(f, imports);
        }
        return BuilderWriter.mapType(f, imports);
    }

    private static String listJsonNullableMap(Field f, Imports imports) {
        return String.format("%s<%s<%s<%s, %s>>>", imports.add(List.class), imports.add(JsonNullable.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String jsonNullableListMapType(Field f, Imports imports) {
        return String.format("%s<%s<%s<%s, %s>>>", imports.add(JsonNullable.class), imports.add(List.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String listMapType(Field f, Imports imports) {
        return String.format("%s<%s<%s, %s>>", imports.add(List.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String jsonNullableMap(Field f, Imports imports) {
        return String.format("%s<%s<%s, %s>>", imports.add(JsonNullable.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String mapType(Field f, Imports imports) {
        if (f.isMapType(Generator.MapType.ADDITIONAL_PROPERTIES)) {
            if (f.nullable) {
                return String.format("%s<%s, %s<%s>>", imports.add(Map.class), imports.add(String.class), imports.add(JsonNullable.class), imports.add(f.fullClassName));
            }
            return String.format("%s<%s, %s>", imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
        }
        if (f.nullable) {
            if (f.required && f.isMapType(Generator.MapType.FIELD)) {
                return BuilderWriter.optionalMapType(f, imports);
            }
            return BuilderWriter.jsonNullableMap(f, imports);
        }
        if (f.required) {
            return String.format("%s<%s, %s>", imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
        }
        return String.format("%s<%s<%s, %s>>", imports.add(Optional.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String optionalMapType(Field f, Imports imports) {
        return String.format("%s<%s<%s, %s>>", imports.add(Optional.class), imports.add(Map.class), imports.add(String.class), imports.add(f.fullClassName));
    }

    private static String enhancedImportedType(Field f, Imports imports) {
        if (f.mapType.isPresent()) {
            return BuilderWriter.mapImportedTypePublic(f, imports);
        }
        if (f.isArray) {
            if (f.nullable) {
                return String.format("%s<%s<%s>>", imports.add(List.class), imports.add(JsonNullable.class), imports.add(f.fullClassName));
            }
            if (f.required) {
                return String.format("%s<%s>", imports.add(List.class), imports.add(f.fullClassName));
            }
            return String.format("%s<%s<%s>>", imports.add(Optional.class), imports.add(List.class), imports.add(f.fullClassName));
        }
        if (f.required && !f.nullable) {
            return imports.add(Util.toPrimitive(f.fullClassName));
        }
        if (f.nullable && !f.required) {
            return String.format("%s<%s>", imports.add(JsonNullable.class), imports.add(f.fullClassName));
        }
        return String.format("%s<%s>", imports.add(Optional.class), imports.add(f.fullClassName));
    }

    public static final class Field {
        private final String fieldName;
        private final String fullClassName;
        private final boolean required;
        private final boolean isArray;
        private final Optional<Generator.MapType> mapType;
        private final boolean nullable;
        private final Optional<Function<String, String>> valueExpressionFactory;

        public Field(String fieldName, String fullClassName, boolean required, boolean isArray, Optional<Generator.MapType> mapType, boolean nullable, Optional<Function<String, String>> valueExpressionFactory) {
            this.fieldName = fieldName;
            this.fullClassName = fullClassName;
            this.required = required;
            this.isArray = isArray;
            this.mapType = mapType;
            this.nullable = nullable;
            this.valueExpressionFactory = valueExpressionFactory;
        }

        public boolean mandatory() {
            return this.required && !this.nullable;
        }

        public boolean isMapType(Generator.MapType mt) {
            return this.mapType.orElse(null) == mt;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Field [fieldName=").append(this.fieldName).append(", fullClassName=").append(this.fullClassName).append(", required=").append(this.required).append(", isArray=").append(this.isArray).append(", mapType=").append(this.mapType).append(", nullable=").append(this.nullable).append(", valueExpressionFactory=").append(this.valueExpressionFactory.map(x -> "present").orElse("")).append("]");
            return builder.toString();
        }
    }
}

