/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.github.davidmoten.guavamini.Maps;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.client.runtime.ClientBuilder;
import org.davidmoten.oa3.codegen.generator.ClientServerGenerator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.ParamType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.generator.writer.ServerCodeWriterSpringBoot;
import org.davidmoten.oa3.codegen.http.Http;
import org.davidmoten.oa3.codegen.http.HttpMethod;
import org.davidmoten.oa3.codegen.http.Interceptor;
import org.davidmoten.oa3.codegen.http.MediaType;
import org.davidmoten.oa3.codegen.http.Serializer;
import org.davidmoten.oa3.codegen.http.service.HttpService;
import org.davidmoten.oa3.codegen.runtime.Preconditions;

public class ClientCodeWriter {
    public static void writeClientClass(Names names, List<ClientServerGenerator.Method> methods) {
        String fullClassName = names.clientFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName, names.simpleNameInPackage(fullClassName));
        ClientCodeWriter.writeClientClass(out, names, methods);
        WriterUtil.writeContent(names, out);
    }

    private static void writeClientClass(CodePrintWriter out, Names names, List<ClientServerGenerator.Method> methods) {
        out.line("package %s;", out.pkg());
        out.println();
        out.format("%s", "IMPORTS_HERE");
        WriterUtil.writeApiJavadoc(out, names);
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public class %s {", out.simpleClassName());
        ClientCodeWriter.writeClientClassFieldsConstructorAndBuilder(out, names);
        ClientCodeWriter.writeClientUtilityMethods(out);
        ClientCodeWriter.writeClientClassMethods(out, methods);
        ClientCodeWriter.writeCustomMethod(out);
        out.closeParen();
    }

    private static void writeClientClassFieldsConstructorAndBuilder(CodePrintWriter out, Names names) {
        out.println();
        out.line("private final %s serializer;", Serializer.class);
        out.line("private final %s<%s> interceptors;", List.class, Interceptor.class);
        out.line("private final %s basePath;", String.class);
        out.line("private final %s httpService;", HttpService.class);
        out.println();
        out.line("private %s(%s serializer, %s<%s> interceptors, %s basePath, %s httpService) {", out.simpleClassName(), Serializer.class, List.class, Interceptor.class, String.class, HttpService.class);
        out.line("this.serializer = serializer;", new Object[0]);
        out.line("this.interceptors = interceptors;", new Object[0]);
        out.line("this.basePath = basePath;", new Object[0]);
        out.line("this.httpService = httpService;", new Object[0]);
        out.closeParen();
        out.println();
        out.line("public static @%s %s<%s> basePath(@%s %s basePath) {", Nonnull.class, ClientBuilder.class, out.simpleClassName(), Nonnull.class, String.class);
        out.line("%s.checkNotNull(basePath, \"basePath\");", Preconditions.class);
        out.line("return new %s<>(b -> new %s(b.serializer(), b.interceptors(), b.basePath(), b.httpService()), %s.config(), basePath);", ClientBuilder.class, out.simpleClassName(), out.add(names.globalsFullClassName()));
        out.closeParen();
        List<Names.Server> servers = names.servers();
        if (!servers.isEmpty()) {
            out.println();
            out.line("public static @%s %s<%s> basePath(@%s Server server) {", Nonnull.class, ClientBuilder.class, out.simpleClassName(), Nonnull.class);
            out.line("%s.checkNotNull(server, \"server\");", Preconditions.class);
            out.line("return new %s<>(b -> new %s(b.serializer(), b.interceptors(), b.basePath(), b.httpService()), %s.config(), server.url());", ClientBuilder.class, out.simpleClassName(), out.add(names.globalsFullClassName()));
            out.closeParen();
            out.println();
            out.line("public enum Server {", new Object[0]);
            out.println();
            HashSet<String> enumNames = new HashSet<String>();
            for (int i = 0; i < servers.size(); ++i) {
                Names.Server server = servers.get(i);
                String fallbackName = "server" + (i + 1);
                String name = Names.enumNameToEnumConstant(server.description.orElse(fallbackName));
                if (enumNames.contains(name)) {
                    name = Names.enumNameToEnumConstant(fallbackName);
                }
                enumNames.add(name);
                String delimiter = i == servers.size() - 1 ? ";" : ",";
                out.line("%s(\"%s\")%s", name, server.url, delimiter);
            }
            out.println();
            out.line("private String url;", new Object[0]);
            out.println();
            out.line("Server(String url) {", new Object[0]);
            out.line("this.url = url;", new Object[0]);
            out.closeParen();
            out.println();
            out.line("public String url() {", new Object[0]);
            out.line("return url;", new Object[0]);
            out.closeParen();
            out.closeParen();
        }
    }

    private static void writeClientUtilityMethods(CodePrintWriter out) {
        out.println();
        out.line("private %s http(%s method, %s path) {", Http.Builder.class, HttpMethod.class, String.class);
        out.line("return %s", Http.class);
        out.right();
        out.right();
        out.line(".method(method)", new Object[0]);
        out.line(".basePath(this.basePath)", new Object[0]);
        out.line(".path(path)", new Object[0]);
        out.line(".serializer(this.serializer)", new Object[0]);
        out.line(".interceptors(this.interceptors)", new Object[0]);
        out.line(".httpService(this.httpService);", new Object[0]);
        out.left();
        out.left();
        out.closeParen();
    }

    private static void writeClientClassMethods(CodePrintWriter out, List<ClientServerGenerator.Method> methods) {
        methods.forEach(m -> {
            out.right().right();
            String params = m.parameters.stream().map(p -> String.format("\n%s@%s %s %s", out.indent(), out.add(Nonnull.class), ServerCodeWriterSpringBoot.toImportedType(p, out.imports()), p.identifier)).collect(Collectors.joining(", "));
            out.left().left();
            String importedReturnType = !m.returnFullClassName.isPresent() ? out.add(Void.class.getCanonicalName()) : out.add(m.returnFullClassName.get());
            boolean hasPrimaryResponse = m.primaryStatusCode.isPresent() && m.primaryMediaType.isPresent();
            ServerCodeWriterSpringBoot.writeMethodJavadoc(out, m, Optional.of("call builder"), Maps.empty());
            out.line("public @%s %s<%s> %s(%s) {", Nonnull.class, Http.RequestBuilder.class, importedReturnType, m.methodName, params);
            out.line("return http(%s.%s, \"%s\")", HttpMethod.class, m.httpMethod.name(), m.path);
            out.right().right();
            HashSet<String> used = new HashSet<String>();
            for (ClientServerGenerator.ResponseDescriptor rd : m.responseDescriptors) {
                if (used.contains(rd.mediaType())) continue;
                if (MediaType.isJson((String)rd.mediaType())) {
                    out.line(".acceptApplicationJson()", new Object[0]);
                } else {
                    out.line(".accept(\"%s\")", rd.mediaType());
                }
                used.add(rd.mediaType());
            }
            m.parameters.forEach(p -> {
                if (p.type == ParamType.QUERY) {
                    out.line(".queryParam(\"%s\", %s)", p.name, p.identifier);
                } else if (p.type == ParamType.PATH) {
                    out.line(".pathParam(\"%s\", %s)", p.name, p.identifier);
                } else if (p.type == ParamType.BODY) {
                    out.line(".body(%s)", p.identifier);
                    out.line(".contentTypeApplicationJson()", new Object[0]);
                } else if (p.type == ParamType.COOKIE) {
                    out.line(".cookie(\"%s\", %s)", p.name, p.identifier);
                } else if (p.type == ParamType.HEADER) {
                    out.line(".header(\"%s\", %s)", p.name, p.identifier);
                } else if (p.type == ParamType.MULTIPART_FORM_DATA) {
                    out.line(".multipartFormData(%s)", p.identifier);
                } else if (p.type == ParamType.FORM_URLENCODED) {
                    out.line(".formUrlEncoded(%s)", p.identifier);
                }
            });
            m.responseDescriptors.forEach(r -> {
                out.line(".responseAs(%s.class)", out.add(r.fullClassName()));
                out.line(".whenStatusCodeMatches(\"%s\")", r.statusCode());
                out.line(".whenContentTypeMatches(\"%s\")", r.mediaType());
            });
            if (hasPrimaryResponse) {
                out.line(".<%s>requestBuilder(\"%s\", \"%s\");", importedReturnType, m.primaryStatusCode.get(), m.primaryMediaType.get());
            } else {
                out.line(".<%s>requestBuilder();", importedReturnType);
            }
            out.left().left();
            out.closeParen();
        });
    }

    private static void writeCustomMethod(CodePrintWriter out) {
        out.println();
        out.line("public @%s %s _custom(%s method, %s path) {", Nonnull.class, Http.Builder.class, HttpMethod.class, String.class);
        out.line("return %s", Http.class);
        out.right().right();
        out.line(".method(method)", new Object[0]);
        out.line(".basePath(this.basePath)", new Object[0]);
        out.line(".path(path)", new Object[0]);
        out.line(".serializer(this.serializer)", new Object[0]);
        out.line(".httpService(this.httpService);", new Object[0]);
        out.left().left();
        out.closeParen();
    }
}

