/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.generator.writer;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.davidmoten.guavamini.Maps;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.davidmoten.oa3.codegen.generator.Generator;
import org.davidmoten.oa3.codegen.generator.Names;
import org.davidmoten.oa3.codegen.generator.SchemaCategory;
import org.davidmoten.oa3.codegen.generator.ServerGeneratorType;
import org.davidmoten.oa3.codegen.generator.internal.CodePrintWriter;
import org.davidmoten.oa3.codegen.generator.internal.Imports;
import org.davidmoten.oa3.codegen.generator.internal.Indent;
import org.davidmoten.oa3.codegen.generator.internal.Javadoc;
import org.davidmoten.oa3.codegen.generator.internal.Mutable;
import org.davidmoten.oa3.codegen.generator.internal.WriterUtil;
import org.davidmoten.oa3.codegen.generator.writer.BuilderWriter;
import org.davidmoten.oa3.codegen.http.HasEncoding;
import org.davidmoten.oa3.codegen.http.HasStringValue;
import org.davidmoten.oa3.codegen.runtime.AnyOfDeserializer;
import org.davidmoten.oa3.codegen.runtime.AnyOfMember;
import org.davidmoten.oa3.codegen.runtime.AnyOfSerializer;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.davidmoten.oa3.codegen.runtime.DiscriminatorHelper;
import org.davidmoten.oa3.codegen.runtime.JsonNullableOctetsDeserializer;
import org.davidmoten.oa3.codegen.runtime.JsonNullableOctetsSerializer;
import org.davidmoten.oa3.codegen.runtime.NullEnumDeserializer;
import org.davidmoten.oa3.codegen.runtime.OctetsDeserializer;
import org.davidmoten.oa3.codegen.runtime.OctetsSerializer;
import org.davidmoten.oa3.codegen.runtime.OptionalEmptyDeserializer;
import org.davidmoten.oa3.codegen.runtime.OptionalMustBePresentConverter;
import org.davidmoten.oa3.codegen.runtime.OptionalMustBePresentOctetsSerializer;
import org.davidmoten.oa3.codegen.runtime.OptionalOctetsDeserializer;
import org.davidmoten.oa3.codegen.runtime.OptionalOctetsSerializer;
import org.davidmoten.oa3.codegen.runtime.OptionalPresentOctetsDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicDeserializer;
import org.davidmoten.oa3.codegen.runtime.PolymorphicType;
import org.davidmoten.oa3.codegen.runtime.Preconditions;
import org.davidmoten.oa3.codegen.runtime.RuntimeUtil;
import org.davidmoten.oa3.codegen.util.Util;
import org.openapitools.jackson.nullable.JsonNullable;
import org.springframework.boot.context.properties.ConstructorBinding;

public final class SchemasCodeWriter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private SchemasCodeWriter() {
    }

    public static void writeSchemaClass(Names names, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Generator.Cls cls, String schemaName) {
        if ((cls.category == SchemaCategory.PATH || cls.category == SchemaCategory.RESPONSE) && cls.schema.isPresent() && cls.schema.get().get$ref() != null) {
            return;
        }
        CodePrintWriter out = CodePrintWriter.create(cls.fullClassName, names.simpleNameInPackage(cls.fullClassName));
        SchemasCodeWriter.writeClass(out, cls, fullClassNameInterfaces, names);
        WriterUtil.writeContent(names, out);
    }

    public static void writeGlobalsClass(Names names) {
        String fullClassName = names.globalsFullClassName();
        CodePrintWriter out = CodePrintWriter.create(fullClassName, names.simpleNameInPackage(fullClassName));
        out.line("package %s;", Names.pkg(fullClassName));
        out.println();
        out.format("%s", "IMPORTS_HERE");
        WriterUtil.addGeneratedAnnotation(out);
        out.line("public final class %s {", Names.simpleClassName(fullClassName));
        out.println();
        out.line("private static volatile %s config = %s.builder().build();", Config.class, Config.class);
        out.println();
        out.line("public static void setConfig(@%s %s configuration) {", Nonnull.class, Config.class);
        out.line("%s.checkNotNull(configuration, \"configuration\");", Preconditions.class);
        out.line("config = configuration;", new Object[0]);
        out.closeParen();
        out.println();
        out.line("public static @%s %s config() {", Nonnull.class, Config.class);
        out.line("return config;", new Object[0]);
        out.closeParen();
        out.closeParen();
        WriterUtil.writeContent(names, out);
    }

    private static void writeClass(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        if (cls.topLevel) {
            out.line("package %s;", cls.pkg());
            out.println();
            out.format("%s", "IMPORTS_HERE");
        }
        SchemasCodeWriter.reserveMemberClassNamesInImports(out.imports(), cls);
        SchemasCodeWriter.writeClassDeclaration(out, cls, fullClassNameInterfaces);
        SchemasCodeWriter.writeEnumMembers(out, cls);
        if (SchemasCodeWriter.isPolymorphic(cls)) {
            SchemasCodeWriter.writePolymorphicClassContent(out, cls, names, fullClassNameInterfaces);
        } else {
            SchemasCodeWriter.writeFields(out, cls);
            SchemasCodeWriter.writeConstructor(out, cls, fullClassNameInterfaces, names);
            SchemasCodeWriter.writeGetters(out, cls, fullClassNameInterfaces);
            SchemasCodeWriter.writePropertiesMapGetter(out, cls);
            SchemasCodeWriter.writeMutators(out, cls, fullClassNameInterfaces);
            SchemasCodeWriter.writeBuilder(out, cls, fullClassNameInterfaces);
        }
        SchemasCodeWriter.writeEnumCreator(out, cls);
        SchemasCodeWriter.writeEnumDeserializer(out, cls);
        SchemasCodeWriter.writeMemberClasses(out, cls, fullClassNameInterfaces, names);
        if (cls.classType != Generator.ClassType.ENUM && cls.classType != Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            SchemasCodeWriter.writeEqualsMethod(out, cls);
            SchemasCodeWriter.writeHashCodeMethod(out, cls);
            SchemasCodeWriter.writeToStringMethod(out, cls);
        }
        out.closeParen();
    }

    private static void reserveMemberClassNamesInImports(Imports imports, Generator.Cls cls) {
        if (cls.classes.isEmpty()) {
            return;
        }
        cls.classes.forEach(c -> SchemasCodeWriter.reserveMemberClassNamesInImports(imports, c));
        cls.classes.forEach(c -> imports.add(c.fullClassName));
    }

    private static boolean isPolymorphic(Generator.Cls cls) {
        return cls.classType == Generator.ClassType.ONE_OF_NON_DISCRIMINATED || cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED || cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED || cls.classType == Generator.ClassType.ALL_OF;
    }

    private static void addOverrideAnnotation(CodePrintWriter out) {
        out.println();
        out.line("@%s", Override.class);
    }

    private static void writeEnumCreator(CodePrintWriter out, Generator.Cls cls) {
        if (cls.classType == Generator.ClassType.ENUM) {
            String simpleClassName = Names.simpleClassName(cls.fullClassName);
            out.println();
            out.line("@%s", JsonCreator.class);
            out.line("public static %s fromValue(%s value) {", simpleClassName, Object.class);
            out.line("for (%s x: %s.values()) {", simpleClassName, simpleClassName);
            if (cls.isNullableEnum()) {
                out.line("if (%s.equals(value, x.value.get())) {", Objects.class);
            } else {
                out.line("if (%s.equals(value, x.value)) {", Objects.class);
            }
            out.line("return x;", new Object[0]);
            out.closeParen();
            out.closeParen();
            out.line("throw new %s(\"unexpected enum value: '\" + value + \"'\");", IllegalArgumentException.class);
            out.closeParen();
        }
    }

    private static void writeEnumDeserializer(CodePrintWriter out, Generator.Cls cls) {
        if (cls.hasEnumNullValue()) {
            String nullValueMemberName = cls.enumMembers.stream().filter(x -> x.parameter == null).map(x -> x.name).findFirst().get();
            out.println();
            out.line("public static class _Deserializer extends %s<%s> {", NullEnumDeserializer.class, cls.simpleName());
            out.line("protected _Deserializer() {", new Object[0]);
            out.line("super(%s.class, %s.class, %s);", cls.simpleName(), out.add(cls.enumValueFullType), nullValueMemberName);
            out.closeParen();
            out.closeParen();
        }
    }

    private static void writeClassDeclaration(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        boolean javadocExists;
        String modifier = SchemasCodeWriter.classModifier(cls);
        Set<Generator.Cls> interfaces = fullClassNameInterfaces.get(cls.fullClassName);
        String implementsClause = SchemasCodeWriter.implementsClause(out.imports(), interfaces, cls);
        if (cls.description.isPresent()) {
            String html = WriterUtil.markdownToHtml(cls.description.get());
            javadocExists = Javadoc.printJavadoc(out, out.indent(), html, true);
        } else {
            javadocExists = false;
        }
        if (!javadocExists) {
            out.println();
        }
        if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            SchemasCodeWriter.writeJsonTypeInfoAnnotation(out, cls);
        } else if (cls.classType == Generator.ClassType.ONE_OF_NON_DISCRIMINATED || cls.classType == Generator.ClassType.ALL_OF) {
            SchemasCodeWriter.writePolymorphicDeserializerAnnotation(out, cls);
        } else if (cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
            SchemasCodeWriter.writeAnyOfSerializerAnnotations(out, cls);
        }
        if (cls.classType != Generator.ClassType.ENUM && cls.classType != Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED && cls.classType != Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
            SchemasCodeWriter.writeJsonIncludeAnnotation(out);
            SchemasCodeWriter.writeAutoDetectAnnotation(out);
        }
        if (cls.classType == Generator.ClassType.ENUM && cls.hasEnumNullValue()) {
            SchemasCodeWriter.writeEnumNullValueDeserializerAnnotation(out, cls);
        }
        if (cls.topLevel) {
            WriterUtil.addGeneratedAnnotation(out);
        }
        out.line("public %s%s %s%s {", modifier, cls.classType.word(), cls.simpleName(), implementsClause);
    }

    private static void writeAnyOfSerializerAnnotations(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(using = %s._Deserializer.class)", JsonDeserialize.class, cls.simpleName());
        out.line("@%s(using = %s._Serializer.class)", JsonSerialize.class, cls.simpleName());
    }

    private static void writeEnumNullValueDeserializerAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(using = %s._Deserializer.class)", JsonDeserialize.class, cls.simpleName());
    }

    private static void writeJsonIncludeAnnotation(CodePrintWriter out) {
        out.line("@%s(%s.NON_ABSENT)", JsonInclude.class, JsonInclude.Include.class);
    }

    private static String classModifier(Generator.Cls cls) {
        String modifier = cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED || cls.classType == Generator.ClassType.ENUM ? "" : (cls.topLevel ? "final " : "static final ");
        return modifier;
    }

    private static String implementsClause(Imports imports, Set<Generator.Cls> interfaces, Generator.Cls cls) {
        String implemented;
        if ((interfaces = (Set)Util.orElse(interfaces, Collections.emptySet())).isEmpty() && !cls.hasEncoding()) {
            implemented = "";
        } else {
            Stream<String> a = interfaces.stream().map(x -> x.fullClassName).sorted();
            Stream<String> b = Stream.of(HasEncoding.class.getCanonicalName()).filter(x -> cls.hasEncoding() && cls.classType != Generator.ClassType.ENUM);
            Stream<String> c = Stream.of(HasStringValue.class.getCanonicalName()).filter(x -> cls.hasEncoding() && cls.classType == Generator.ClassType.ENUM);
            implemented = " implements " + Stream.concat(a, Stream.concat(b, c)).map(imports::add).collect(Collectors.joining(", "));
        }
        return implemented;
    }

    private static void writeJsonTypeInfoAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(use = %s.NAME, property = \"%s\", include = %s.EXISTING_PROPERTY, visible = true)", JsonTypeInfo.class, JsonTypeInfo.Id.class, cls.discriminator.propertyName, JsonTypeInfo.As.class);
        out.right().right();
        String types = cls.fields.stream().map(x -> {
            String fieldImportedType = x.fullClassName.startsWith(cls.fullClassName) ? Names.simpleClassName(cls.fullClassName) + x.fullClassName.substring(cls.fullClassName.length()) : out.add(x.fullClassName);
            return String.format("\n%s@%s.Type(value = %s.class, name = \"%s\")", out.indent(), out.add(JsonSubTypes.class), fieldImportedType, cls.discriminator.discriminatorValueFromFullClassName(x.fullClassName));
        }).collect(Collectors.joining(", "));
        out.left().left();
        out.line("@%s({%s})", JsonSubTypes.class, types);
    }

    private static void writePolymorphicDeserializerAnnotation(CodePrintWriter out, Generator.Cls cls) {
        out.line("@%s(using = %s._Deserializer.class)", JsonDeserialize.class, cls.simpleName());
    }

    private static void writeAutoDetectAnnotation(CodePrintWriter out) {
        out.line("@%s(", JsonAutoDetect.class);
        out.right().right();
        out.line("fieldVisibility = %s.Visibility.ANY,", JsonAutoDetect.class);
        out.line("creatorVisibility = %s.Visibility.ANY,", JsonAutoDetect.class);
        out.line("setterVisibility = %s.Visibility.ANY)", JsonAutoDetect.class);
        out.left().left();
    }

    private static String escapedJson(ObjectNode node) {
        try {
            return MAPPER.writeValueAsString((Object)node).replace("\n", "\\n").replace("\"", "\\\"");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeEnumMembers(CodePrintWriter out, Generator.Cls cls) {
        String parameterFullClassName = !cls.fields.isEmpty() ? cls.fields.get((int)0).fullClassName : "NotUsed";
        int[] index = new int[]{-1};
        String text = cls.enumMembers.stream().map(x -> {
            String delim;
            index[0] = index[0] + 1;
            String memberName = !cls.enumNames.isEmpty() ? cls.enumNames.get(index[0]) : x.name;
            if (x.parameter instanceof ObjectNode) {
                return String.format("%s%s(%s.toMap(\"%s\"))", out.indent(), memberName, out.add(RuntimeUtil.class), SchemasCodeWriter.escapedJson((ObjectNode)x.parameter));
            }
            if (parameterFullClassName.equals(BigInteger.class.getCanonicalName()) || parameterFullClassName.equals(BigDecimal.class.getCanonicalName())) {
                return String.format("%s%s(new %s(\"\"))", out.indent(), memberName, out.add(parameterFullClassName));
            }
            String string = delim = x.parameter instanceof String || cls.enumValueFullType.equals(String.class.getCanonicalName()) && x.parameter instanceof Boolean ? "\"" : "";
            if (x.nullable) {
                if (x.parameter == null) {
                    return String.format("%s%s(%s.empty())", out.indent(), memberName, out.add(Optional.class));
                }
                return String.format("%s%s(%s.of(%s%s%s))", out.indent(), memberName, out.add(Optional.class), delim, x.parameter, delim);
            }
            return String.format("%s%s(%s%s%s)", out.indent(), memberName, delim, x.parameter, delim);
        }).collect(Collectors.joining(",\n"));
        if (!text.isEmpty()) {
            out.println("\n" + text + ";");
        }
    }

    private static void writePolymorphicClassContent(CodePrintWriter out, Generator.Cls cls, Names names, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        if (cls.classType == Generator.ClassType.ONE_OR_ANY_OF_DISCRIMINATED) {
            out.println();
            out.line("@%s %s %s();", Nonnull.class, String.class, cls.discriminator.fieldName);
        } else {
            String parameters;
            if (cls.classType == Generator.ClassType.ONE_OF_NON_DISCRIMINATED) {
                out.println();
                SchemasCodeWriter.writeJsonValueAnnotation(out);
                out.line("private final %s %s;", Object.class, "value");
                SchemasCodeWriter.writeOneOfAnyOfNonDiscriminatedObjectConstructor(out, cls);
                HashSet used = new HashSet();
                cls.fields.forEach(f -> SchemasCodeWriter.writeOneOfAnyOfNonDiscriminatedMemberSpecificConstructor(out, cls, f, used));
                out.println();
                SchemasCodeWriter.writeGetter(out, out.add(Object.class), "value", "value");
                SchemasCodeWriter.writeNonDiscriminatedFactoryMethod(out, cls, names, fullClassNameInterfaces);
            } else if (cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
                SchemasCodeWriter.writeFields(out, cls);
                out.right().right();
                parameters = cls.fields.stream().map(x -> String.format("\n%s@%s %s %s", out.indent(), out.add(Nonnull.class), x.resolvedType(out.imports()), x.fieldName(cls))).collect(Collectors.joining(","));
                out.left().left();
                out.println();
                out.line("private %s(%s) {", Names.simpleClassName(cls.fullClassName), parameters);
                SchemasCodeWriter.ifValidate(cls, out, names, o -> cls.fields.forEach(x -> SchemasCodeWriter.checkNotNull(cls, o, x)));
                cls.fields.forEach(x -> SchemasCodeWriter.assignField(out, cls, x));
                out.closeParen();
                out.println();
                out.line("public static @%s %s of(%s) {", Nonnull.class, cls.simpleName(), parameters);
                String fields = cls.fields.stream().map(x -> x.fieldName).collect(Collectors.joining(", "));
                out.line("%s $o = new %s(%s);", cls.simpleName(), cls.simpleName(), fields);
                out.line("%s.checkCanSerialize(%s.config(), $o);", RuntimeUtil.class, out.add(names.globalsFullClassName()));
                out.line("return $o;", new Object[0]);
                out.closeParen();
                cls.fields.forEach(f -> {
                    out.println();
                    SchemasCodeWriter.writeGetter(out, f.resolvedType(out.imports()), f.fieldName(cls), f.fieldName(cls));
                });
                SchemasCodeWriter.writeAnyOfOrAllOfBuilder(out, cls, true);
            } else if (cls.classType == Generator.ClassType.ALL_OF) {
                SchemasCodeWriter.writeFields(out, cls);
                out.right().right();
                parameters = cls.fields.stream().map(x -> String.format("\n%s@%s %s %s", out.indent(), out.add(Nonnull.class), x.resolvedType(out.imports()), x.fieldName(cls))).collect(Collectors.joining(","));
                out.left().left();
                out.println();
                out.line("public %s(%s) {", Names.simpleClassName(cls.fullClassName), parameters);
                SchemasCodeWriter.ifValidate(cls, out, names, o -> cls.fields.stream().forEach(x -> {
                    if (!x.isPrimitive() && x.required) {
                        SchemasCodeWriter.checkNotNull(cls, o, x);
                    } else {
                        o.line("// TODO %s", x.fieldName);
                    }
                    SchemasCodeWriter.validateMore(o, cls, x);
                }));
                cls.fields.stream().forEach(x -> SchemasCodeWriter.assignField(out, cls, x));
                out.closeParen();
                HashMap getterNames = new HashMap();
                HashSet usedNames = new HashSet();
                cls.fields.forEach(f -> {
                    String name = "as" + Names.simpleClassName(f.resolvedType(out.imports()));
                    int i = 0;
                    String modifiedName = name;
                    while (usedNames.contains(modifiedName)) {
                        modifiedName = name + ++i;
                    }
                    getterNames.put(f, modifiedName);
                    usedNames.add(modifiedName);
                });
                cls.fields.forEach(f -> {
                    out.println();
                    SchemasCodeWriter.writeGetter(out, f.resolvedType(out.imports()), (String)getterNames.get(f), f.fieldName(cls));
                });
                HashSet used = new HashSet();
                cls.fields.forEach(field -> {
                    Optional<Generator.Cls> c = names.cls(field.fullClassName);
                    if (c.isPresent() && c.get().classType != Generator.ClassType.ONE_OF_NON_DISCRIMINATED) {
                        c.get().fields.stream().filter(f -> !f.mapType.isPresent()).forEach(f -> {
                            String fieldName = f.fieldName((Generator.Cls)c.get());
                            if (!used.contains(fieldName)) {
                                used.add(fieldName);
                                String type = f.resolvedTypePublicConstructor(out.imports());
                                out.println();
                                out.line("public @%s %s %s() {", Nonnull.class, type, fieldName);
                                String getter = ((Generator.Cls)c.get()).classType == Generator.ClassType.ALL_OF ? "as" + Names.upperFirst(fieldName) : fieldName;
                                out.line("return %s.%s();", field.fieldName(cls), getter);
                                out.closeParen();
                            }
                        });
                    }
                });
                SchemasCodeWriter.writeAnyOfOrAllOfBuilder(out, cls, false);
            }
            out.println();
            out.line("@%s(\"serial\")", SuppressWarnings.class);
            Class polymorphicDeserializer = cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED ? AnyOfDeserializer.class : PolymorphicDeserializer.class;
            out.line("public static final class _Deserializer extends %s<%s> {", polymorphicDeserializer, cls.simpleName());
            out.println();
            out.line("public _Deserializer() {", new Object[0]);
            String classes = cls.fields.stream().map(x -> out.add(org.davidmoten.oa3.codegen.generator.internal.Util.toPrimitive(x.fullClassName)) + ".class").collect(Collectors.joining(", "));
            if (cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
                String members = cls.fields.stream().map(x -> {
                    String c = out.add(x.fullClassName) + ".class";
                    String method = x.nullable ? "nullable" : "nonNullable";
                    return String.format("%s.%s(%s)", out.add(AnyOfMember.class), method, c);
                }).collect(Collectors.joining(", "));
                out.line("super(%s.config(), %s.class, %s);", out.add(names.globalsFullClassName()), cls.simpleName(), members);
            } else {
                out.line("super(%s.config(), %s.%s, %s.class, %s);", out.add(names.globalsFullClassName()), PolymorphicType.class, cls.polymorphicType.name(), cls.simpleName(), classes);
            }
            out.closeParen();
            out.closeParen();
            if (cls.classType == Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
                out.println();
                out.line("@%s(\"serial\")", SuppressWarnings.class);
                out.line("public static final class _Serializer extends %s<%s> {", AnyOfSerializer.class, cls.simpleName());
                out.println();
                out.line("public _Serializer() {", new Object[0]);
                out.line("super(%s.config(), %s.class);", out.add(names.globalsFullClassName()), cls.simpleName());
                out.closeParen();
                out.closeParen();
            }
        }
    }

    private static void writeAnyOfOrAllOfBuilder(CodePrintWriter out, Generator.Cls cls, boolean useOf) {
        List<BuilderWriter.Field> fields = cls.fields.stream().map(f -> new BuilderWriter.Field(f.fieldName(cls), f.fullClassName, f.required, f.isArray, f.mapType, f.nullable, Optional.empty())).collect(Collectors.toList());
        BuilderWriter.write(out, fields, cls.simpleName(), useOf);
    }

    private static void writeNonDiscriminatedFactoryMethod(CodePrintWriter out, Generator.Cls cls, Names names, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        Set<Generator.Cls> interfaces = SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces);
        HashSet used = new HashSet();
        int[] count = new int[]{2};
        cls.fields.forEach(f -> {
            String methodName;
            out.println();
            if (used.contains(f.fullClassName)) {
                methodName = "of" + count[0];
                count[0] = count[0] + 1;
            } else {
                methodName = "of";
            }
            used.add(f.fullClassName);
            out.line("public static @%s %s %s(@%s %s value) {", Nonnull.class, cls.simpleName(), methodName, Nonnull.class, out.add(f.fullClassName));
            SchemasCodeWriter.writeConstraintValidations(out, cls, names, interfaces, false, Collections.singletonList(f));
            out.line("return new %s(value);", cls.simpleName());
            out.closeParen();
        });
    }

    private static void writeOneOfAnyOfNonDiscriminatedMemberSpecificConstructor(CodePrintWriter out, Generator.Cls cls, Generator.Field f, Set<String> used) {
        if (used.contains(f.fullClassName)) {
            return;
        }
        used.add(f.fullClassName);
        String className = org.davidmoten.oa3.codegen.generator.internal.Util.toPrimitive(f.fullClassName);
        out.println();
        out.line("private %s(%s value) {", cls.simpleName(), out.add(className));
        if (org.davidmoten.oa3.codegen.generator.internal.Util.isPrimitiveFullClassName(className)) {
            out.line("this.value = value;", new Object[0]);
        } else {
            out.line("this.value = %s.checkNotNull(value, \"value\");", Preconditions.class);
        }
        out.closeParen();
    }

    private static void writeOneOfAnyOfNonDiscriminatedObjectConstructor(CodePrintWriter out, Generator.Cls cls) {
        out.println();
        out.line("private %s(%s value) {", cls.simpleName(), Object.class);
        out.line("this.value = %s.checkNotNull(value, \"value\");", Preconditions.class);
        out.closeParen();
    }

    private static void writeFields(CodePrintWriter out, Generator.Cls cls) {
        if (!cls.fields.isEmpty()) {
            out.println();
        }
        Mutable<Boolean> first = Mutable.create(true);
        cls.fields.forEach(f -> {
            if (!((Boolean)first.value).booleanValue()) {
                out.println();
            }
            first.value = false;
            if (cls.classType != Generator.ClassType.ANY_OF_NON_DISCRIMINATED) {
                if (f.isAdditionalProperties() && !f.isArray) {
                    out.line("@%s", JsonAnyGetter.class);
                    out.line("@%s", JsonAnySetter.class);
                } else if (cls.classType == Generator.ClassType.ALL_OF) {
                    out.line("@%s", JsonUnwrapped.class);
                } else if (cls.unwrapSingleField()) {
                    SchemasCodeWriter.writeJsonValueAnnotation(out);
                } else if (f.readOnly) {
                    out.line("@%s", JsonIgnore.class);
                } else {
                    out.line("@%s(\"%s\")", JsonProperty.class, f.name);
                }
            }
            if (f.required && f.nullable && !f.readOnly) {
                out.line("@%s(%s.ALWAYS)", JsonInclude.class, JsonInclude.Include.class);
            }
            if (f.isOctets() && !f.readOnly) {
                if (f.required && f.writeOnly) {
                    out.line("@%s(using = %s.class)", JsonSerialize.class, OptionalMustBePresentOctetsSerializer.class);
                } else if (!f.required && f.nullable) {
                    out.line("@%s(using = %s.class)", JsonSerialize.class, JsonNullableOctetsSerializer.class);
                } else if (!f.required || f.nullable) {
                    out.line("@%s(using = %s.class)", JsonSerialize.class, OptionalOctetsSerializer.class);
                } else {
                    out.line("@%s(using = %s.class)", JsonSerialize.class, OctetsSerializer.class);
                }
            } else if (f.required && f.writeOnly && !f.nullable) {
                out.line("@%s(converter = %s.class)", JsonSerialize.class, OptionalMustBePresentConverter.class);
            }
            String fieldType = cls.classType == Generator.ClassType.ENUM && cls.enumValueFullType.equals(Map.class.getCanonicalName()) ? String.format("%s<%s, %s>", out.add(Map.class), out.add(String.class), out.add(Object.class)) : f.resolvedType(out.imports());
            out.line("private final %s %s;", fieldType, cls.fieldName((Generator.Field)f));
        });
    }

    private static void writeJsonValueAnnotation(CodePrintWriter out) {
        out.line("@%s", JsonValue.class);
    }

    private static void writeConstructor(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        String parameters;
        boolean extraConstructor;
        Set<Generator.Cls> interfaces = SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces);
        boolean hasAdditionalProperties = cls.fields.stream().anyMatch(Generator.Field::isAdditionalProperties);
        boolean hasDiscriminator = cls.fields.stream().anyMatch(x -> SchemasCodeWriter.isDiscriminator(interfaces, x));
        boolean bl = extraConstructor = hasAdditionalProperties && cls.classType == Generator.ClassType.CLASS;
        if (extraConstructor) {
            out.right().right();
            parameters = cls.fields.stream().map(x -> {
                String t = x.mapType.isPresent() ? x.resolvedTypeMapPublic(out.imports()) : x.resolvedTypePublicConstructor(out.imports());
                return String.format("\n%s@%s %s %s", out.indent(), out.add(Nonnull.class), t, x.fieldName(cls));
            }).collect(Collectors.joining(","));
            out.left().left();
            out.println();
            out.line("public %s(%s) {", Names.simpleClassName(cls.fullClassName), parameters);
            SchemasCodeWriter.writeConstructorBody(out, cls, names, interfaces, true);
            out.closeParen();
        }
        out.right().right();
        parameters = cls.fields.stream().filter(x -> !x.isAdditionalProperties()).map(f -> {
            String t = f.mapType.isPresent() ? f.resolvedTypeMapPublic(out.imports()) : f.resolvedTypePublicConstructor(out.imports());
            String annotations = String.format("@%s ", out.add(Nonnull.class));
            annotations = annotations + (cls.unwrapSingleField() ? "" : String.format("@%s(\"%s\") ", out.add(JsonProperty.class), f.name));
            if (f.writeOnly) {
                annotations = annotations + String.format("@%s(using = %s.class) ", out.add(JsonDeserialize.class), out.add(OptionalEmptyDeserializer.class));
            } else if (f.isOctets()) {
                annotations = f.required && f.readOnly ? annotations + String.format("@%s(using = %s.class) ", out.add(JsonDeserialize.class), out.add(OptionalPresentOctetsDeserializer.class)) : (!f.required && f.nullable ? annotations + String.format("@%s(using = %s.class) ", out.add(JsonDeserialize.class), out.add(JsonNullableOctetsDeserializer.class)) : (!f.required || f.nullable ? annotations + String.format("@%s(using = %s.class) ", out.add(JsonDeserialize.class), out.add(OptionalOctetsDeserializer.class)) : annotations + String.format("@%s(using = %s.class) ", out.add(JsonDeserialize.class), out.add(OctetsDeserializer.class))));
            } else if (f.required && f.readOnly && !f.nullable) {
                annotations = annotations + String.format("@%s(converter = %s.class) ", out.add(JsonDeserialize.class), out.add(OptionalMustBePresentConverter.class));
            }
            return String.format("\n%s%s%s %s", out.indent(), annotations, t, f.fieldName(cls));
        }).collect(Collectors.joining(","));
        out.left().left();
        out.println();
        String modifier = cls.classType == Generator.ClassType.ENUM ? "" : (hasDiscriminator || extraConstructor ? "private " : "public ");
        if (modifier.equals("private ")) {
            SchemasCodeWriter.addConstructorBindingAnnotation(out, names);
        }
        if (cls.classType != Generator.ClassType.ENUM) {
            out.line("@%s", JsonCreator.class);
        }
        out.line("%s%s(%s) {", modifier, Names.simpleClassName(cls.fullClassName), parameters);
        SchemasCodeWriter.writeConstructorBody(out, cls, names, interfaces, false);
        out.closeParen();
    }

    private static void addConstructorBindingAnnotation(CodePrintWriter out, Names names) {
        if (names.generateService()) {
            if (names.generatorType() == ServerGeneratorType.SPRING_BOOT_3) {
                out.line("@%s", out.add(ConstructorBinding.class.getName().replace("ConstructorBinding", "bind.ConstructorBinding")));
            } else {
                out.line("@%s", ConstructorBinding.class);
            }
        }
    }

    private static void writeConstructorBody(CodePrintWriter out, Generator.Cls cls, Names names, Set<Generator.Cls> interfaces, boolean additionalPropertiesIsParameter) {
        SchemasCodeWriter.writeConstraintValidations(out, cls, names, interfaces, additionalPropertiesIsParameter, cls.fields);
        cls.fields.stream().forEach(x -> SchemasCodeWriter.writeConstructorBodyFieldAssignment(out, cls, interfaces, x, additionalPropertiesIsParameter));
    }

    private static void writeConstraintValidations(CodePrintWriter out, Generator.Cls cls, Names names, Set<Generator.Cls> interfaces, boolean additionalPropertiesIsParameter, List<Generator.Field> fields) {
        SchemasCodeWriter.ifValidate(cls, out, names, out2 -> fields.stream().filter(x -> !x.isAdditionalProperties() || additionalPropertiesIsParameter).forEach(x -> {
            if (!SchemasCodeWriter.isDiscriminator(interfaces, x)) {
                if (x.isOctets() || !x.isPrimitive()) {
                    SchemasCodeWriter.checkNotNull(cls, out2, x);
                }
                SchemasCodeWriter.validateMore(out2, cls, x);
            }
        }));
    }

    private static void writeConstructorBodyFieldAssignment(CodePrintWriter out, Generator.Cls cls, Set<Generator.Cls> interfaces, Generator.Field x, boolean additionalPropertiesIsParameter) {
        if (x.isAdditionalProperties() && !additionalPropertiesIsParameter) {
            out.line("this.%s = new %s<>();", x.fieldName(cls), HashMap.class);
        } else if (x.mapType.isPresent()) {
            if (x.isArray) {
                out.line("this.%s = new %s<>();", x.fieldName(cls), ArrayList.class);
            } else if (x.required && !x.nullable) {
                out.line("this.%s = %s.createMapIfNull(%s);", x.fieldName(cls), Util.class, x.fieldName(cls));
            } else {
                out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
            }
        } else {
            Optional<Generator.Discriminator> disc = SchemasCodeWriter.discriminator(interfaces, x);
            if (disc.isPresent()) {
                out.line("%s.checkEquals(%s.value(%s.class, \"%s\"), %s, \"%s\");", Preconditions.class, DiscriminatorHelper.class, out.add(x.fullClassName), disc.get().discriminatorValueFromFullClassName(cls.fullClassName), x.fieldName(cls), x.fieldName(cls));
                out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
            } else if (x.nullable) {
                if (x.required) {
                    out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
                } else {
                    SchemasCodeWriter.assignField(out, cls, x);
                }
            } else if (!x.isPrimitive()) {
                if (x.required) {
                    SchemasCodeWriter.assignField(out, cls, x);
                } else {
                    SchemasCodeWriter.assignOptionalField(out, cls, x);
                }
            } else {
                SchemasCodeWriter.assignField(out, cls, x);
            }
        }
    }

    private static Set<Generator.Cls> interfaces(Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        return (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
    }

    private static void writeBuilder(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        if (cls.classType == Generator.ClassType.ENUM) {
            return;
        }
        Set interfaces = (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
        List<BuilderWriter.Field> fields = cls.fields.stream().map(f -> {
            Optional<Function<String, String>> expressionFactory;
            Optional<Generator.Discriminator> disc = SchemasCodeWriter.discriminator(interfaces, f);
            if (disc.isPresent()) {
                String expression = String.format("%s.value(%s.class, \"%s\")", out.add(DiscriminatorHelper.class), out.add(f.fullClassName), disc.get().discriminatorValueFromFullClassName(cls.fullClassName));
                expressionFactory = Optional.of(x -> expression);
            } else {
                expressionFactory = Optional.empty();
            }
            boolean required = !(!f.required || f.isAdditionalProperties() || f.readOnly && !f.nullable || f.writeOnly && !f.nullable);
            return new BuilderWriter.Field(f.fieldName(cls), f.fullClassName, required, f.isArray, f.mapType, f.nullable, expressionFactory);
        }).collect(Collectors.toList());
        BuilderWriter.write(out, fields, cls.simpleName());
    }

    private static void checkNotNull(Generator.Cls cls, CodePrintWriter out, Generator.Field x) {
        out.line("%s.checkNotNull(%s, \"%s\");", Preconditions.class, x.fieldName(cls), x.fieldName(cls));
    }

    private static void assignOptionalField(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
    }

    private static boolean isDiscriminator(Set<Generator.Cls> interfaces, Generator.Field x) {
        return SchemasCodeWriter.discriminator(interfaces, x).isPresent();
    }

    private static Optional<Generator.Discriminator> discriminator(Set<Generator.Cls> interfaces, Generator.Field x) {
        return interfaces.stream().filter(y -> y.discriminator.propertyName.equals(x.name)).map(y -> y.discriminator).findFirst();
    }

    private static void validateMore(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        if (x.isAdditionalProperties()) {
            return;
        }
        String raw = x.fieldName(cls);
        if (x.minLength.isPresent() && !x.isDateOrTime()) {
            out.line("%s.checkMinLength(%s, %s, \"%s\");", Preconditions.class, raw, x.minLength.get(), raw);
        }
        if (x.maxLength.isPresent() && !x.isDateOrTime()) {
            out.line("%s.checkMaxLength(%s, %s, \"%s\");", Preconditions.class, raw, x.maxLength.get(), raw);
        }
        if (x.pattern.isPresent() && !x.isDateOrTime() && !x.isByteArray() && !x.isOctets()) {
            out.line("%s.checkMatchesPattern(%s, \"%s\", \"%s\");", Preconditions.class, raw, WriterUtil.escapePattern(x.pattern.get()), raw);
        }
        if (x.min.isPresent() && x.isNumber()) {
            out.line("%s.checkMinimum(%s, \"%s\", \"%s\", %s);", Preconditions.class, raw, x.min.get().toString(), raw, x.exclusiveMin);
        }
        if (x.max.isPresent() && x.isNumber()) {
            out.line("%s.checkMaximum(%s, \"%s\", \"%s\", %s);", Preconditions.class, raw, x.max.get().toString(), raw, x.exclusiveMax);
        }
        if (x.isArray && x.minItems.isPresent()) {
            out.line("%s.checkMinSize(%s, %s, \"%s\");", Preconditions.class, raw, x.minItems.get(), raw);
        }
        if (x.isArray && x.maxItems.isPresent()) {
            out.line("%s.checkMaxSize(%s, %s, \"%s\");", Preconditions.class, raw, x.maxItems.get(), raw);
        }
    }

    private static void writeEqualsMethod(CodePrintWriter out, Generator.Cls cls) {
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public boolean equals(%s o) {", Object.class);
        out.line("if (this == o) {", new Object[0]);
        out.line("return true;", new Object[0]);
        out.closeParen();
        out.line("if (o == null || getClass() != o.getClass()) {", new Object[0]);
        out.line("return false;", new Object[0]);
        out.closeParen();
        out.right();
        String s = cls.fields.stream().map(x -> String.format("\n%s%s.deepEquals(this.%s, other.%s)", out.indent(), out.add(Objects.class), x.fieldName(cls), x.fieldName(cls))).distinct().collect(Collectors.joining(" && "));
        out.left();
        if (!s.isEmpty()) {
            out.line("%s other = (%s) o;", cls.simpleName(), cls.simpleName());
        }
        out.line("return %s;", s.isEmpty() ? "true" : s);
        out.closeParen();
    }

    private static void writeHashCodeMethod(CodePrintWriter out, Generator.Cls cls) {
        String s;
        if (cls.fields.size() <= 3) {
            s = cls.fields.stream().map(x -> x.fieldName(cls)).collect(Collectors.joining(", "));
        } else {
            out.right().right().right();
            s = cls.fields.stream().map(x -> String.format("\n%s%s", out.indent(), x.fieldName(cls))).collect(Collectors.joining(", "));
            out.left().left().left();
        }
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public int hashCode() {", new Object[0]);
        out.line("return %s.hash(%s);", Objects.class, s);
        out.closeParen();
    }

    private static void writeToStringMethod(CodePrintWriter out, Generator.Cls cls) {
        String s;
        if (cls.fields.size() > 3) {
            out.right().right().right();
            s = cls.fields.stream().map(x -> String.format(",\n%s\"%s\", %s", out.indent(), x.fieldName(cls), x.fieldName(cls))).collect(Collectors.joining());
            out.left().left().left();
        } else {
            s = cls.fields.stream().map(x -> String.format(", \"%s\", %s", x.fieldName(cls), x.fieldName(cls))).collect(Collectors.joining(""));
        }
        SchemasCodeWriter.addOverrideAnnotation(out);
        out.line("public @%s %s toString() {", Nonnull.class, String.class);
        out.line("return %s.toString(%s.class%s);", Util.class, cls.simpleName(), s);
        out.closeParen();
    }

    private static void ifValidate(Generator.Cls cls, CodePrintWriter out, Names names, Consumer<CodePrintWriter> consumer) {
        CodePrintWriter b = CodePrintWriter.create(out);
        out.right();
        consumer.accept(b);
        out.left();
        b.close();
        String text = b.text();
        if (!text.isEmpty()) {
            out.line("if (%s.config().validateInConstructor().test(%s.class)) {", out.add(names.globalsFullClassName()), cls.simpleName());
            out.left();
            out.print(text);
            out.line("}", new Object[0]);
        }
    }

    private static void assignField(CodePrintWriter out, Generator.Cls cls, Generator.Field x) {
        out.line("this.%s = %s;", x.fieldName(cls), x.fieldName(cls));
    }

    private static void writeGetters(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        Set interfaces = (Set)Util.orElse(fullClassNameInterfaces.get(cls.fullClassName), Collections.emptySet());
        cls.fields.forEach(f -> {
            out.println();
            Optional<Generator.Discriminator> disc = SchemasCodeWriter.discriminator(interfaces, f);
            if (disc.isPresent()) {
                String value = SchemasCodeWriter.discriminatorHelperExpression(out, f.fieldName(cls));
                SchemasCodeWriter.addOverrideAnnotation(out);
                SchemasCodeWriter.writeGetter(out, out.add(String.class), f.fieldName(cls), value);
            } else if (f.mapType.isPresent()) {
                if (!f.isArray && f.isAdditionalProperties()) {
                    SchemasCodeWriter.writeJsonAnySetter(out, cls, f);
                    out.println();
                }
                String expression = f.fieldName(cls);
                SchemasCodeWriter.writeGetter(out, f.resolvedTypeMapPublic(out.imports()), f.fieldName(cls), expression);
            } else {
                String value = f.fieldName(cls);
                String returnType = cls.classType == Generator.ClassType.ENUM && f.fullClassName.equals(Map.class.getCanonicalName()) ? String.format("%s<%s, %s>", out.add(Map.class), out.add(String.class), out.add(Object.class)) : f.resolvedTypePublicConstructor(out.imports());
                SchemasCodeWriter.writeGetter(out, returnType, f.fieldName(cls), value);
            }
        });
    }

    private static String discriminatorHelperExpression(CodePrintWriter out, String fieldExpression) {
        return String.format("%s.value(%s)", out.add(DiscriminatorHelper.class), fieldExpression);
    }

    private static void writePropertiesMapGetter(CodePrintWriter out, Generator.Cls cls) {
        if (cls.fields.isEmpty() || cls.classType == Generator.ClassType.ENUM) {
            return;
        }
        Indent indent = out.indent().copy().right().right().right();
        String puts = cls.fields.stream().map(f -> String.format("\n%s.put(\"%s\", (%s) %s)", indent, f.name, out.add(Object.class), cls.fieldName((Generator.Field)f))).collect(Collectors.joining());
        out.println();
        out.line("%s<%s, %s> _internal_properties() {", Map.class, String.class, Object.class);
        out.line("return %s%s\n%s.build();", Maps.class, puts, indent);
        out.closeParen();
    }

    private static void writeMutators(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces) {
        List fields = cls.fields.stream().collect(Collectors.toList());
        if (fields.size() <= 1) {
            return;
        }
        fields.stream().filter(x -> !SchemasCodeWriter.isDiscriminator(SchemasCodeWriter.interfaces(cls, fullClassNameInterfaces), x)).forEach(x -> {
            Optional<String> tNonOptional;
            String t = x.mapType.isPresent() ? x.resolvedTypeMapPublic(out.imports()) : x.resolvedTypePublicConstructor(out.imports());
            out.println();
            out.line("public @%s %s with%s(@%s %s %s) {", Nonnull.class, cls.simpleName(), Names.upperFirst(x.fieldName(cls)), Nonnull.class, t, x.fieldName(cls));
            String params = fields.stream().map(y -> y.fieldName(cls)).collect(Collectors.joining(", "));
            out.line("return new %s(%s);", cls.simpleName(), params);
            out.closeParen();
            if (!x.mapType.isPresent() && (tNonOptional = x.resolvedTypePublicConstructorNonOptional(out.imports())).isPresent() && !tNonOptional.get().equals(t)) {
                out.println();
                out.line("public @%s %s with%s(@%s %s %s) {", Nonnull.class, cls.simpleName(), Names.upperFirst(x.fieldName(cls)), Nonnull.class, tNonOptional.get(), x.fieldName(cls));
                String params2 = fields.stream().map(y -> {
                    if (y.fieldName(cls).equals(x.fieldName(cls))) {
                        if (y.nullable && !y.required) {
                            return String.format("%s.of(%s)", out.add(JsonNullable.class), y.fieldName(cls));
                        }
                        return String.format("%s.of(%s)", out.add(Optional.class), y.fieldName(cls));
                    }
                    return y.fieldName(cls);
                }).collect(Collectors.joining(", "));
                out.line("return new %s(%s);", cls.simpleName(), params2);
                out.closeParen();
            }
        });
    }

    private static void writeJsonAnySetter(CodePrintWriter out, Generator.Cls cls, Generator.Field f) {
        out.line("@%s", JsonAnySetter.class);
        if (f.nullable) {
            out.line("private void put(%s key, %s<%s> value) {", String.class, JsonNullable.class, out.add(f.fullClassName));
        } else {
            out.line("private void put(%s key, %s value) {", String.class, out.add(f.fullClassName));
        }
        out.line("this.%s.put(key, value);", f.fieldName(cls));
        out.closeParen();
    }

    private static void writeGetter(CodePrintWriter out, String returnImportedType, String fieldName, String value) {
        out.line("public @%s %s %s() {", Nonnull.class, returnImportedType, fieldName);
        out.line("return %s;", value);
        out.closeParen();
    }

    private static void writeMemberClasses(CodePrintWriter out, Generator.Cls cls, Map<String, Set<Generator.Cls>> fullClassNameInterfaces, Names names) {
        cls.classes.forEach(c -> SchemasCodeWriter.writeClass(out, c, fullClassNameInterfaces, names));
    }
}

