/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.davidmoten.oa3.codegen.runtime.internal.PolymorphicType;

public class PolymorphicDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -4953059872205916149L;
    private final PolymorphicType type;
    private final List<Class<?>> classes;
    private final Class<T> cls;
    private final ObjectMapper mapper;

    protected PolymorphicDeserializer(Config config, PolymorphicType type, Class<T> cls, Class<?> ... classes) {
        super(cls);
        this.type = type;
        this.classes = Arrays.asList(classes);
        this.cls = cls;
        this.mapper = config.mapper();
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return PolymorphicDeserializer.deserializePoly(this.mapper, p, ctxt, this.classes, this.cls, this.type);
    }

    private static <T> T deserializePoly(ObjectMapper mapper, JsonParser p, DeserializationContext ctxt, List<Class<?>> classes, Class<T> cls, PolymorphicType type) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        String json = mapper.writeValueAsString((Object)tree);
        if (type == PolymorphicType.ANY_OF) {
            return PolymorphicDeserializer.deserializeAnyOf(mapper, json, classes, cls, ctxt);
        }
        if (type == PolymorphicType.ONE_OF) {
            return PolymorphicDeserializer.deserializeOneOf(mapper, json, classes, cls, ctxt);
        }
        return PolymorphicDeserializer.deserializeAllOf(mapper, json, classes, cls);
    }

    private static <T> T deserializeAnyOf(ObjectMapper mapper, String json, List<Class<?>> classes, Class<T> cls, DeserializationContext ctxt) throws JsonProcessingException {
        for (Class<?> c : classes) {
            try {
                Object o = mapper.readValue(json, c);
                return PolymorphicDeserializer.newInstance(cls, o);
            }
            catch (DatabindException databindException) {
            }
        }
        throw JsonMappingException.from((DeserializationContext)ctxt, (String)("json did not match any of the possible classes: " + classes + ", json=\n" + json));
    }

    private static <T> T deserializeOneOf(ObjectMapper mapper, String json, List<Class<?>> classes, Class<T> cls, DeserializationContext ctxt) throws JsonProcessingException {
        T v = null;
        int count = 0;
        for (Class<?> c : classes) {
            try {
                if (c.equals(String.class) && (!json.startsWith("\"") || !json.endsWith("\""))) continue;
                Object o = mapper.readValue(json, c);
                v = PolymorphicDeserializer.newInstance(cls, o);
                ++count;
            }
            catch (DatabindException databindException) {}
        }
        if (count == 1) {
            return v;
        }
        if (count > 1) {
            throw JsonMappingException.from((DeserializationContext)ctxt, (String)("json matched more than one of the possible classes: " + classes + ", json=\n" + json));
        }
        throw JsonMappingException.from((DeserializationContext)ctxt, (String)("json did not match any of the possible classes: " + classes + ", json=\n" + json));
    }

    private static <T> T deserializeAllOf(ObjectMapper mapper, String json, List<Class<?>> classes, Class<T> cls) throws JsonMappingException, JsonProcessingException {
        ObjectMapper m = mapper.copy().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Class<?> c : classes) {
            list.add(m.readValue(json, c));
        }
        try {
            Constructor<T> con = cls.getDeclaredConstructor(classes.toArray(new Class[0]));
            con.setAccessible(true);
            return con.newInstance(list.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T newInstance(Class<T> cls, Object parameter) {
        try {
            Constructor<T> con = cls.getDeclaredConstructor(Object.class);
            con.setAccessible(true);
            return con.newInstance(parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

