/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.github.davidmoten.guavamini.Sets;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.davidmoten.oa3.codegen.runtime.AnyOfMember;
import org.davidmoten.oa3.codegen.runtime.Config;
import org.openapitools.jackson.nullable.JsonNullable;

public class AnyOfDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -4477865921927841241L;
    private final List<AnyOfMember> members;
    private final Class<T> cls;
    private final ObjectMapper mapper;
    private static final Set<Class<?>> NON_OBJECT_CLASSES = Sets.of((Object[])new Class[]{List.class, Map.class, String.class, Short.class, Integer.class, Float.class, Double.class, byte[].class, Byte.class, BigInteger.class});

    protected AnyOfDeserializer(Config config, Class<T> cls, AnyOfMember ... members) {
        super(cls);
        this.members = Arrays.asList(members);
        this.cls = cls;
        this.mapper = config.mapper();
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        TreeNode tree = p.getCodec().readTree(p);
        String json = this.mapper.writeValueAsString((Object)tree);
        return AnyOfDeserializer.deserializeAnyOf(this.mapper, json, this.members, this.cls);
    }

    private static <T> T deserializeAnyOf(ObjectMapper mapper, String json, List<AnyOfMember> members, Class<T> cls) throws JsonMappingException, JsonProcessingException {
        ObjectMapper m = mapper.copy().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ArrayList<Object> list = new ArrayList<Object>();
        for (AnyOfMember member2 : members) {
            try {
                Class<?> c = member2.cls();
                Object o = json.trim().startsWith("{") && AnyOfDeserializer.isObject(c) ? m.readValue(json, c) : mapper.readValue(json, c);
                if (member2.nullable()) {
                    list.add(JsonNullable.of((Object)o));
                    continue;
                }
                list.add(Optional.of(o));
            }
            catch (DatabindException e) {
                if (member2.nullable()) {
                    list.add(JsonNullable.undefined());
                    continue;
                }
                list.add(Optional.empty());
            }
        }
        try {
            Class[] argClasses = members.stream().map(member -> {
                if (member.nullable()) {
                    return JsonNullable.class;
                }
                return Optional.class;
            }).collect(Collectors.toList()).toArray(new Class[0]);
            Constructor<T> con = cls.getDeclaredConstructor(argClasses);
            con.setAccessible(true);
            return con.newInstance(list.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isObject(Class<?> c) {
        if (c.isPrimitive() || NON_OBJECT_CLASSES.contains(c)) {
            return false;
        }
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(JsonValue.class)) continue;
            return false;
        }
        return true;
    }
}

