/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.runtime;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.davidmoten.oa3.codegen.util.Util;

public class OptionalPresentOctetsDeserializer
extends StdDeserializer<Optional<byte[]>> {
    private static final long serialVersionUID = 1L;

    public OptionalPresentOctetsDeserializer() {
        super(Optional.class);
    }

    public Optional<byte[]> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return Optional.ofNullable(p.getText()).map(Util::decodeOctets);
    }

    public Object getAbsentValue(DeserializationContext ctxt) {
        return OptionalPresentOctetsDeserializer.missing(ctxt);
    }

    public Optional<byte[]> getNullValue(DeserializationContext ctxt) {
        return (Optional)OptionalPresentOctetsDeserializer.missing(ctxt);
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return OptionalPresentOctetsDeserializer.missing(ctxt);
    }

    private static <T> T missing(DeserializationContext ctxt) {
        try {
            return (T)ctxt.handleWeirdStringValue(Optional.class, "nullOrEmptyOrAbsent", "Optional value must be present (required)", new Object[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

