/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.oa3.codegen.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class ImmutableList<T>
implements Iterable<T> {
    private final List<T> list;
    private static final ImmutableList<Object> EMPTY = ImmutableList.of(new Object[0]);

    public ImmutableList() {
        this(new ArrayList());
    }

    public ImmutableList(List<T> list) {
        this.list = list;
    }

    public ImmutableList<T> add(T value) {
        ArrayList<T> list2 = new ArrayList<T>(this.list);
        list2.add(value);
        return new ImmutableList<T>(list2);
    }

    @SafeVarargs
    public static <T> ImmutableList<T> of(T ... values) {
        List<T> list = Arrays.asList(values);
        return new ImmutableList<T>(list);
    }

    public static <T> ImmutableList<T> empty() {
        return EMPTY;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public T last() {
        return this.list.get(this.list.size() - 1);
    }

    public T first() {
        return this.list.get(0);
    }

    public T secondLast() {
        return this.list.get(this.list.size() - 2);
    }

    public int size() {
        return this.list.size();
    }
}

