/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.amsacode.predict4java.DeepSpaceSatellite;
import com.github.amsacode.predict4java.GroundStationPosition;
import com.github.amsacode.predict4java.LEOSatellite;
import com.github.amsacode.predict4java.SatPos;
import com.github.amsacode.predict4java.Satellite;
import com.github.amsacode.predict4java.TLE;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSatellite
implements Satellite {
    private static final double MINS_PER_DAY = 1440.0;
    private static final double PI_OVER_TWO = 1.5707963267948966;
    private static final double SECS_PER_DAY = 86400.0;
    private static final double FLATTENING_FACTOR = 0.00335281066474748;
    protected static final double CK4 = 6.209887E-7;
    protected static final double EARTH_GRAVITATIONAL_CONSTANT = 398600.8;
    protected static final double S = 1.012229;
    protected static final double QOMS2T = 1.880279E-9;
    protected static final double EARTH_ROTATIONS_PER_SIDERIAL_DAY = 1.00273790934;
    protected static final double EARTH_ROTATIONS_RADIANS_PER_SIDERIAL_DAY = 6.300388098917064;
    protected static final double RHO = 0.15696615;
    protected static final double MFACTOR = 7.292115E-5;
    protected static final double SOLAR_RADIUS_KM = 696000.0;
    protected static final double ASTRONOMICAL_UNIT = 1.49597870691E8;
    protected static final double SPEED_OF_LIGHT = 2.99792458E8;
    protected static final double PERIGEE_156_KM = 156.0;
    protected static final double EARTH_RADIUS = 6378.137;
    protected static final double SOLAR_RADIUS = 696000.0;
    private double s4;
    private double qoms24;
    private double perigee;
    private final TLE tle;
    private double eclipseDepth;
    private final Vector4 position = new Vector4();
    private final Vector4 velocity = new Vector4();
    private double julUTC;
    private SatPos satPos;
    static final TimeZone TZ = TimeZone.getTimeZone("UTC:UTC");
    private final double julEpoch;

    public AbstractSatellite(TLE tle) {
        this.tle = tle;
        this.julEpoch = AbstractSatellite.juliandDateOfEpoch(tle.getEpoch());
    }

    @Override
    public final synchronized TLE getTLE() {
        return this.tle;
    }

    protected static double julianDateOfYear(double theYear) {
        long i;
        double aYear = theYear - 1.0;
        long a = i = (long)Math.floor(aYear / 100.0);
        i = a / 4L;
        long b = 2L - a + i;
        i = (long)Math.floor(365.25 * aYear);
        i = (long)((double)i + 428.4014);
        return (double)i + 1720994.5 + (double)b;
    }

    static double juliandDateOfEpoch(double epoch) {
        double year = Math.floor(epoch * 0.001);
        double day = (epoch * 0.001 - year) * 1000.0;
        year = year < 57.0 ? (year += 2000.0) : (year += 1900.0);
        return AbstractSatellite.julianDateOfYear(year) + day;
    }

    private static double calcCurrentDaynum(Date date) {
        long now = date.getTime();
        Calendar sgp4Epoch = Calendar.getInstance(TZ);
        sgp4Epoch.clear();
        sgp4Epoch.set(1979, 11, 31, 0, 0, 0);
        long then = sgp4Epoch.getTimeInMillis();
        long millis = now - then;
        return (double)millis / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    protected static double sqr(double arg) {
        return arg * arg;
    }

    protected static void magnitude(Vector4 v) {
        v.setW(Math.sqrt(AbstractSatellite.sqr(v.getX()) + AbstractSatellite.sqr(v.getY()) + AbstractSatellite.sqr(v.getZ())));
    }

    private static void scaleVector(double k, Vector4 v) {
        v.multiply(k);
        AbstractSatellite.magnitude(v);
    }

    static double modulus(double arg1, double arg2) {
        int i;
        double returnValue = arg1;
        if ((returnValue -= (double)(i = (int)Math.floor(returnValue / arg2)) * arg2) < 0.0) {
            returnValue += arg2;
        }
        return returnValue;
    }

    private static double frac(double arg) {
        return arg - Math.floor(arg);
    }

    private static double thetaGJD(double theJD) {
        double ut = AbstractSatellite.frac(theJD + 0.5);
        double aJD = theJD - ut;
        double tu = (aJD - 2451545.0) / 36525.0;
        double gmst = 24110.54841 + tu * (8640184.812866 + tu * (0.093104 - tu * 6.2E-6));
        gmst = AbstractSatellite.modulus(gmst + 86636.555366976 * ut, 86400.0);
        return Math.PI * 2 * gmst / 86400.0;
    }

    private static double dot(Vector4 v1, Vector4 v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY() + v1.getZ() * v2.getZ();
    }

    protected static double mod2PI(double testValue) {
        int i;
        double retVal = testValue;
        if ((retVal -= (double)(i = (int)(retVal / (Math.PI * 2))) * (Math.PI * 2)) < 0.0) {
            retVal += Math.PI * 2;
        }
        return retVal;
    }

    private void calculateLatLonAlt(double time) {
        this.calculateLatLonAlt(time, this.satPos, this.position);
    }

    private void calculateLatLonAlt(double time, SatPos satPos, Vector4 position) {
        double c;
        satPos.setTheta(Math.atan2(position.getY(), position.getX()));
        satPos.setLongitude(AbstractSatellite.mod2PI(satPos.getTheta() - AbstractSatellite.thetaGJD(time)));
        double r = Math.sqrt(AbstractSatellite.sqr(position.getX()) + AbstractSatellite.sqr(position.getY()));
        double e2 = 0.006694379990141316;
        satPos.setLatitude(Math.atan2(position.getZ(), r));
        int i = 0;
        boolean converged = false;
        do {
            double phi = satPos.getLatitude();
            c = AbstractSatellite.invert(Math.sqrt(1.0 - 0.006694379990141316 * AbstractSatellite.sqr(Math.sin(phi))));
            satPos.setLatitude(Math.atan2(position.getZ() + 6378.137 * c * 0.006694379990141316 * Math.sin(phi), r));
            boolean bl = converged = Math.abs(satPos.getLatitude() - phi) < 1.0E-12;
        } while (i++ < 10 && !converged);
        satPos.setAltitude(r / Math.cos(satPos.getLatitude()) - 6378.137 * c);
        double temp = satPos.getLatitude();
        if (temp > 1.5707963267948966) {
            satPos.setLatitude(temp -= Math.PI * 2);
        }
    }

    private static void convertSatState(Vector4 pos, Vector4 vel) {
        AbstractSatellite.scaleVector(6378.137, pos);
        AbstractSatellite.scaleVector(106.30228333333332, vel);
    }

    @Override
    public synchronized SatPos getPosition(GroundStationPosition gsPos, Date date) {
        this.satPos = new SatPos();
        this.julUTC = AbstractSatellite.calcCurrentDaynum(date) + 2444238.5;
        double tsince = (this.julUTC - this.julEpoch) * 1440.0;
        this.calculateSDP4orSGP4(tsince);
        AbstractSatellite.convertSatState(this.position, this.velocity);
        AbstractSatellite.magnitude(this.velocity);
        Vector4 squintVector = new Vector4();
        this.calculateObs(this.julUTC, this.position, this.velocity, gsPos, squintVector);
        this.calculateLatLonAlt(this.julUTC);
        this.satPos.setTime(date);
        this.satPos.setEclipsed(this.isEclipsed());
        this.satPos.setEclipseDepth(this.eclipseDepth);
        return this.satPos;
    }

    private void calculateSDP4orSGP4(double tsince) {
        if (this.tle.isDeepspace()) {
            ((DeepSpaceSatellite)this).calculateSDP4(tsince);
        } else {
            ((LEOSatellite)this).calculateSGP4(tsince);
        }
    }

    private static void calculateUserPosVel(double time, GroundStationPosition gsPos, AtomicReference<Double> gsPosTheta, Vector4 obsPos, Vector4 obsVel) {
        gsPosTheta.set(AbstractSatellite.mod2PI(AbstractSatellite.thetaGJD(time) + 0.0174532925199433 * gsPos.getLongitude()));
        double c = AbstractSatellite.invert(Math.sqrt(1.0 + -0.006694379990141316 * AbstractSatellite.sqr(Math.sin(0.0174532925199433 * gsPos.getLatitude()))));
        double sq = AbstractSatellite.sqr(0.9966471893352525) * c;
        double achcp = (6378.137 * c + gsPos.getHeightAMSL() / 1000.0) * Math.cos(0.0174532925199433 * gsPos.getLatitude());
        obsPos.setXYZ(achcp * Math.cos(gsPosTheta.get()), achcp * Math.sin(gsPosTheta.get()), (6378.137 * sq + gsPos.getHeightAMSL() / 1000.0) * Math.sin(0.0174532925199433 * gsPos.getLatitude()));
        obsVel.setXYZ(-7.292115E-5 * obsPos.getY(), 7.292115E-5 * obsPos.getX(), 0.0);
        AbstractSatellite.magnitude(obsPos);
        AbstractSatellite.magnitude(obsVel);
    }

    private void calculateObs(double julianUTC, Vector4 positionVector, Vector4 velocityVector, GroundStationPosition gsPos, Vector4 squintVector) {
        Vector4 obsPos = new Vector4();
        Vector4 obsVel = new Vector4();
        Vector4 range = new Vector4();
        Vector4 rgvel = new Vector4();
        AtomicReference<Double> gsPosTheta = new AtomicReference<Double>();
        AbstractSatellite.calculateUserPosVel(julianUTC, gsPos, gsPosTheta, obsPos, obsVel);
        range.setXYZ(positionVector.getX() - obsPos.getX(), positionVector.getY() - obsPos.getY(), positionVector.getZ() - obsPos.getZ());
        squintVector.setXYZ(range.getX(), range.getY(), range.getZ());
        rgvel.setXYZ(velocityVector.getX() - obsVel.getX(), velocityVector.getY() - obsVel.getY(), velocityVector.getZ() - obsVel.getZ());
        AbstractSatellite.magnitude(range);
        double sinLat = Math.sin(0.0174532925199433 * gsPos.getLatitude());
        double cosLat = Math.cos(0.0174532925199433 * gsPos.getLatitude());
        double sinTheta = Math.sin(gsPosTheta.get());
        double cosTheta = Math.cos(gsPosTheta.get());
        double topS = sinLat * cosTheta * range.getX() + sinLat * sinTheta * range.getY() - cosLat * range.getZ();
        double topE = -sinTheta * range.getX() + cosTheta * range.getY();
        double topZ = cosLat * cosTheta * range.getX() + cosLat * sinTheta * range.getY() + sinLat * range.getZ();
        double azim = Math.atan(-topE / topS);
        if (topS > 0.0) {
            azim += Math.PI;
        }
        if (azim < 0.0) {
            azim += Math.PI * 2;
        }
        this.satPos.setAzimuth(azim);
        this.satPos.setElevation(Math.asin(topZ / range.getW()));
        this.satPos.setRange(range.getW());
        this.satPos.setRangeRate(AbstractSatellite.dot(range, rgvel) / range.getW());
        int sector = (int)(this.satPos.getAzimuth() / (Math.PI * 2) * 360.0 / 10.0);
        double elevation = this.satPos.getElevation() / (Math.PI * 2) * 360.0;
        if (elevation > 90.0) {
            elevation = 180.0 - elevation;
        }
        this.satPos.setAboveHorizon(elevation - (double)gsPos.getHorizonElevation(sector) > 1.0E-12);
    }

    @Override
    public boolean willBeSeen(GroundStationPosition qth) {
        double sma;
        double apogee;
        if (this.tle.getMeanmo() < 1.0E-8) {
            return false;
        }
        double lin = this.tle.getIncl();
        if (lin >= 90.0) {
            lin = 180.0 - lin;
        }
        return Math.acos(6378.137 / ((apogee = (sma = 331.25 * Math.exp(Math.log(1440.0 / this.tle.getMeanmo()) * 0.6666666666666666)) * (1.0 + this.tle.getEccn()) - 6378.137) + 6378.137)) + lin * 0.0174532925199433 > Math.abs(qth.getLatitude() * 0.0174532925199433);
    }

    protected double getS4() {
        return this.s4;
    }

    protected double getQoms24() {
        return this.qoms24;
    }

    private void checkPerigee() {
        this.s4 = 1.012229;
        this.qoms24 = 1.880279E-9;
        if (this.perigee < 156.0) {
            this.s4 = this.perigee <= 98.0 ? 20.0 : this.perigee - 78.0;
            this.qoms24 = Math.pow((120.0 - this.s4) / 6378.137, 4.0);
            this.s4 = this.s4 / 6378.137 + 1.0;
        }
    }

    protected void setPerigee(double perigee) {
        this.perigee = perigee;
        this.checkPerigee();
    }

    protected static void converge(double[] temp, double axn, double ayn, double capu) {
        boolean converged = false;
        int i = 0;
        do {
            temp[7] = Math.sin(temp[2]);
            temp[8] = Math.cos(temp[2]);
            temp[3] = axn * temp[7];
            temp[4] = ayn * temp[8];
            temp[5] = axn * temp[8];
            temp[6] = ayn * temp[7];
            double epw = (capu - temp[4] + temp[3] - temp[2]) / (1.0 - temp[5] - temp[6]) + temp[2];
            if (Math.abs(epw - temp[2]) <= 1.0E-12) {
                converged = true;
                continue;
            }
            temp[2] = epw;
        } while (i++ < 10 && !converged);
    }

    @Override
    public synchronized void calculateSatelliteVectors(Date date) {
        this.satPos = new SatPos();
        this.julUTC = AbstractSatellite.calcCurrentDaynum(date) + 2444238.5;
        double tsince = (this.julUTC - this.julEpoch) * 1440.0;
        this.calculateSDP4orSGP4(tsince);
        AbstractSatellite.convertSatState(this.position, this.velocity);
        AbstractSatellite.magnitude(this.velocity);
        this.satPos.setEclipsed(this.isEclipsed());
        this.satPos.setEclipseDepth(this.eclipseDepth);
        this.satPos.setTime(date);
    }

    @Override
    public synchronized SatPos calculateSatelliteGroundTrack() {
        this.calculateLatLonAlt(this.julUTC);
        return this.satPos;
    }

    @Override
    public synchronized SatPos calculateSatPosForGroundStation(GroundStationPosition gsPos) {
        Vector4 squintVector = new Vector4();
        this.calculateObs(this.julUTC, this.position, this.velocity, gsPos, squintVector);
        return this.satPos;
    }

    private boolean isEclipsed() {
        Vector4 sunVector = this.calculateSunVector();
        double sdEarth = Math.asin(6378.137 / this.position.w);
        Vector4 rho = Vector4.subtract(sunVector, this.position);
        double sdSun = Math.asin(696000.0 / rho.w);
        Vector4 earth = Vector4.scalarMultiply(this.position, -1.0);
        double delta = Vector4.angle(sunVector, earth);
        this.eclipseDepth = sdEarth - sdSun - delta;
        if (sdEarth < sdSun) {
            return false;
        }
        return this.eclipseDepth >= 0.0;
    }

    private Vector4 calculateSunVector() {
        double mjd = this.julUTC - 2415020.0;
        double year = 1900.0 + mjd / 365.25;
        double solTime = (mjd + this.deltaEt(year) / 86400.0) / 36525.0;
        double m = this.radians(AbstractSatellite.modulus(358.47583 + AbstractSatellite.modulus(35999.04975 * solTime, 360.0) - (1.5E-4 + 3.3E-6 * solTime) * AbstractSatellite.sqr(solTime), 360.0));
        double l = this.radians(AbstractSatellite.modulus(279.69668 + AbstractSatellite.modulus(36000.76892 * solTime, 360.0) + 3.025E-4 * AbstractSatellite.sqr(solTime), 360.0));
        double e = 0.01675104 - (4.18E-5 + 1.26E-7 * solTime) * solTime;
        double c = this.radians((1.91946 - (0.004789 + 1.4E-5 * solTime) * solTime) * Math.sin(m) + (0.020094 - 1.0E-4 * solTime) * Math.sin(2.0 * m) + 2.93E-4 * Math.sin(3.0 * m));
        double o = this.radians(AbstractSatellite.modulus(259.18 - 1934.142 * solTime, 360.0));
        double lsa = AbstractSatellite.modulus(l + c - this.radians(0.00569 - 0.00479 * Math.sin(o)), Math.PI * 2);
        double nu = AbstractSatellite.modulus(m + c, Math.PI * 2);
        double r = 1.0000002 * (1.0 - AbstractSatellite.sqr(e)) / (1.0 + e * Math.cos(nu));
        double eps = this.radians(23.452294 - (0.0130125 + (1.64E-6 - 5.03E-7 * solTime) * solTime) * solTime + 0.00256 * Math.cos(o));
        r = 1.49597870691E8 * r;
        return new Vector4(r, r * Math.cos(lsa), r * Math.sin(lsa) * Math.cos(eps), r * Math.sin(lsa) * Math.sin(eps));
    }

    private double deltaEt(double year) {
        return 26.465 + 0.747622 * (year - 1950.0) + 1.886913 * Math.sin(Math.PI * 2 * (year - 1975.0) / 33.0);
    }

    private double radians(double degrees) {
        return degrees * 0.0174532925199433;
    }

    protected void calculatePhase(double xlt, double xnode, double omgadf) {
        double phaseValue = xlt - xnode - omgadf + Math.PI * 2;
        if (phaseValue < 0.0) {
            phaseValue += Math.PI * 2;
        }
        this.satPos.setPhase(AbstractSatellite.mod2PI(phaseValue));
    }

    protected void calculatePositionAndVelocity(double rk, double uk, double xnodek, double xinck, double rdotk, double rfdotk) {
        double sinuk = Math.sin(uk);
        double cosuk = Math.cos(uk);
        double sinik = Math.sin(xinck);
        double cosik = Math.cos(xinck);
        double sinnok = Math.sin(xnodek);
        double cosnok = Math.cos(xnodek);
        double xmx = -sinnok * cosik;
        double xmy = cosnok * cosik;
        double ux = xmx * sinuk + cosnok * cosuk;
        double uy = xmy * sinuk + sinnok * cosuk;
        double uz = sinik * sinuk;
        double vx = xmx * cosuk - cosnok * sinuk;
        double vy = xmy * cosuk - sinnok * sinuk;
        double vz = sinik * cosuk;
        this.position.setXYZ(ux, uy, uz);
        this.position.multiply(rk);
        this.velocity.setX(rdotk * ux + rfdotk * vx);
        this.velocity.setY(rdotk * uy + rfdotk * vy);
        this.velocity.setZ(rdotk * uz + rfdotk * vz);
    }

    protected static double invert(double value) {
        return 1.0 / value;
    }

    public final double getEclipseDepth() {
        return this.eclipseDepth;
    }

    static class Vector4 {
        private double w;
        private double x;
        private double y;
        private double z;

        Vector4() {
            this.w = 0.0;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
        }

        Vector4(double w, double x, double y, double z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final String toString() {
            return "w: " + this.w + ", x: " + this.x + ", y: " + this.y + ", z: " + this.z;
        }

        public final double getW() {
            return this.w;
        }

        public final void setW(double w) {
            this.w = w;
        }

        public final double getX() {
            return this.x;
        }

        public final void setX(double x) {
            this.x = x;
        }

        public final double getY() {
            return this.y;
        }

        public final void setY(double y) {
            this.y = y;
        }

        public final double getZ() {
            return this.z;
        }

        public final void setZ(double z) {
            this.z = z;
        }

        public final void multiply(double multiplier) {
            this.x *= multiplier;
            this.y *= multiplier;
            this.z *= multiplier;
        }

        public final void setXYZ(double xValue, double yValue, double zValue) {
            this.x = xValue;
            this.y = yValue;
            this.z = zValue;
        }

        public Vector4 subtract(Vector4 vector) {
            return new Vector4(this.w - vector.w, this.x - vector.x, this.y - vector.y, this.z - vector.z);
        }

        public static final Vector4 scalarMultiply(Vector4 vector, double multiplier) {
            return new Vector4(vector.w * Math.abs(multiplier), vector.x * multiplier, vector.y * multiplier, vector.z * multiplier);
        }

        public static final double angle(Vector4 v1, Vector4 v2) {
            AbstractSatellite.magnitude(v1);
            AbstractSatellite.magnitude(v2);
            return Math.acos(AbstractSatellite.dot(v1, v2) / (v1.w * v2.w));
        }

        public static final Vector4 subtract(Vector4 v1, Vector4 v2) {
            Vector4 v3 = new Vector4();
            v3.x = v1.x - v2.x;
            v3.y = v1.y - v2.y;
            v3.z = v1.z - v2.z;
            AbstractSatellite.magnitude(v3);
            return v3;
        }
    }
}

