/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Arrays;

public class GroundStationPosition {
    private static final int NUM_SECTORS = 36;
    private final double latitude;
    private final double longitude;
    private final double heightAMSL;
    private final int[] horizonElevations;
    private final String name;

    public GroundStationPosition(double latitude, double longitude, double heightAMSL, String name, int[] horizonElevations) {
        Preconditions.checkArgument((horizonElevations == null || horizonElevations.length == 36 ? 1 : 0) != 0, (String)"horizonElevations array must have length 36 corresponding to 10 degree sectors");
        this.latitude = latitude;
        this.longitude = longitude;
        this.heightAMSL = heightAMSL;
        this.name = name == null ? "" : name;
        this.horizonElevations = horizonElevations == null ? new int[36] : Arrays.copyOf(horizonElevations, horizonElevations.length);
    }

    public GroundStationPosition(double latitude, double longitude, double heightAMSL) {
        this(latitude, longitude, heightAMSL, null, null);
    }

    public GroundStationPosition(double latitude, double longitude, double heightAMSL, String name) {
        this(latitude, longitude, heightAMSL, name, null);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getHeightAMSL() {
        return this.heightAMSL;
    }

    public final int getHorizonElevation(int sector) {
        return this.horizonElevations[sector];
    }

    public String getName() {
        return this.name;
    }
}

