/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.amsacode.predict4java.AbstractSatellite;
import com.github.amsacode.predict4java.TLE;

public class LEOSatellite
extends AbstractSatellite {
    private final double aodp;
    private final double aycof;
    private final double c1;
    private final double c4;
    private final double c5;
    private final double cosio;
    private final double d2;
    private final double d3;
    private final double d4;
    private final double delmo;
    private final double omgcof;
    private final double eta;
    private final double omgdot;
    private final double sinio;
    private final double xnodp;
    private final double sinmo;
    private final double t2cof;
    private final double t3cof;
    private final double t4cof;
    private final double t5cof;
    private final double x1mth2;
    private final double x3thm1;
    private final double x7thm1;
    private final double xmcof;
    private final double xmdot;
    private final double xnodcf;
    private final double xnodot;
    private final double xlcof;
    private final boolean sgp4Simple;

    public LEOSatellite(TLE tle) {
        super(tle);
        double a1 = Math.pow(0.0743669161 / this.getTLE().getXno(), 0.6666666666666666);
        this.cosio = Math.cos(this.getTLE().getXincl());
        double theta2 = AbstractSatellite.sqr(this.cosio);
        this.x3thm1 = 3.0 * theta2 - 1.0;
        double eo = this.getTLE().getEo();
        double eosq = AbstractSatellite.sqr(eo);
        double betao2 = 1.0 - eosq;
        double betao = Math.sqrt(betao2);
        double del1 = 8.1196185E-4 * this.x3thm1 / (AbstractSatellite.sqr(a1) * betao * betao2);
        double ao = a1 * (1.0 - del1 * (0.3333333333333333 + del1 * (1.0 + 1.654320987654321 * del1)));
        double delo = 8.1196185E-4 * this.x3thm1 / (AbstractSatellite.sqr(ao) * betao * betao2);
        this.xnodp = this.getTLE().getXno() / (1.0 + delo);
        this.aodp = ao / (1.0 - delo);
        this.sgp4Simple = this.aodp * (1.0 - eo) < 1.0344928307435228;
        this.setPerigee((this.aodp * (1.0 - eo) - 1.0) * 6378.137);
        double pinvsq = AbstractSatellite.invert(AbstractSatellite.sqr(this.aodp) * AbstractSatellite.sqr(betao2));
        double tsi = AbstractSatellite.invert(this.aodp - this.getS4());
        this.eta = this.aodp * eo * tsi;
        double etasq = this.eta * this.eta;
        double eeta = eo * this.eta;
        double psisq = Math.abs(1.0 - etasq);
        double coef = this.getQoms24() * Math.pow(tsi, 4.0);
        double coef1 = coef / Math.pow(psisq, 3.5);
        double bstar = this.getTLE().getBstar();
        double c2 = coef1 * this.xnodp * (this.aodp * (1.0 + 1.5 * etasq + eeta * (4.0 + etasq)) + 4.05980925E-4 * tsi / psisq * this.x3thm1 * (8.0 + 3.0 * etasq * (8.0 + etasq)));
        this.c1 = bstar * c2;
        this.sinio = Math.sin(this.getTLE().getXincl());
        double a3ovk2 = 0.004690140306468833;
        double c3 = coef * tsi * 0.004690140306468833 * this.xnodp * this.sinio / eo;
        this.x1mth2 = 1.0 - theta2;
        double omegao = this.getTLE().getOmegao();
        this.c4 = 2.0 * this.xnodp * coef1 * this.aodp * betao2 * (this.eta * (2.0 + 0.5 * etasq) + eo * (0.5 + 2.0 * etasq) - 0.0010826158 * tsi / (this.aodp * psisq) * (-3.0 * this.x3thm1 * (1.0 - 2.0 * eeta + etasq * (1.5 - 0.5 * eeta)) + 0.75 * this.x1mth2 * (2.0 * etasq - eeta * (1.0 + etasq)) * Math.cos(2.0 * omegao)));
        this.c5 = 2.0 * coef1 * this.aodp * betao2 * (1.0 + 2.75 * (etasq + eeta) + eeta * etasq);
        double theta4 = AbstractSatellite.sqr(theta2);
        double temp1 = 0.0016239237 * pinvsq * this.xnodp;
        double temp2 = temp1 * 5.413079E-4 * pinvsq;
        double temp3 = 7.762358750000001E-7 * pinvsq * pinvsq * this.xnodp;
        this.xmdot = this.xnodp + 0.5 * temp1 * betao * this.x3thm1 + 0.0625 * temp2 * betao * (13.0 - 78.0 * theta2 + 137.0 * theta4);
        double x1m5th = 1.0 - 5.0 * theta2;
        this.omgdot = -0.5 * temp1 * x1m5th + 0.0625 * temp2 * (7.0 - 114.0 * theta2 + 395.0 * theta4) + temp3 * (3.0 - 36.0 * theta2 + 49.0 * theta4);
        double xhdot1 = -temp1 * this.cosio;
        this.xnodot = xhdot1 + (0.5 * temp2 * (4.0 - 19.0 * theta2) + 2.0 * temp3 * (3.0 - 7.0 * theta2)) * this.cosio;
        this.omgcof = bstar * c3 * Math.cos(omegao);
        this.xmcof = -0.6666666666666666 * coef * bstar / eeta;
        this.xnodcf = 3.5 * betao2 * xhdot1 * this.c1;
        this.t2cof = 1.5 * this.c1;
        this.xlcof = 5.862675383086041E-4 * this.sinio * (3.0 + 5.0 * this.cosio) / (1.0 + this.cosio);
        this.aycof = 0.0011725350766172082 * this.sinio;
        double xmo = this.getTLE().getXmo();
        this.delmo = Math.pow(1.0 + this.eta * Math.cos(xmo), 3.0);
        this.sinmo = Math.sin(xmo);
        this.x7thm1 = 7.0 * theta2 - 1.0;
        if (!this.sgp4Simple) {
            double c1sq = AbstractSatellite.sqr(this.c1);
            this.d2 = 4.0 * this.aodp * tsi * c1sq;
            double temp = this.d2 * tsi * this.c1 / 3.0;
            this.d3 = (17.0 * this.aodp + this.getS4()) * temp;
            this.d4 = 0.5 * temp * this.aodp * tsi * (221.0 * this.aodp + 31.0 * this.getS4()) * this.c1;
            this.t3cof = this.d2 + 2.0 * c1sq;
            this.t4cof = 0.25 * (3.0 * this.d3 + this.c1 * (12.0 * this.d2 + 10.0 * c1sq));
            this.t5cof = 0.2 * (3.0 * this.d4 + 12.0 * this.c1 * this.d3 + 6.0 * this.d2 * this.d2 + 15.0 * c1sq * (2.0 * this.d2 + c1sq));
        } else {
            this.d2 = 0.0;
            this.d3 = 0.0;
            this.d4 = 0.0;
            this.t3cof = 0.0;
            this.t4cof = 0.0;
            this.t5cof = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSGP4(double tsince) {
        LEOSatellite lEOSatellite = this;
        synchronized (lEOSatellite) {
            double capu;
            double[] temp = new double[9];
            double xmdf = this.getTLE().getXmo() + this.xmdot * tsince;
            double omgadf = this.getTLE().getOmegao() + this.omgdot * tsince;
            double xnoddf = this.getTLE().getXnodeo() + this.xnodot * tsince;
            double omega = omgadf;
            double xmp = xmdf;
            double tsq = AbstractSatellite.sqr(tsince);
            double xnode = xnoddf + this.xnodcf * tsq;
            double bstar = this.getTLE().getBstar();
            double tempa = 1.0 - this.c1 * tsince;
            double tempe = bstar * this.c4 * tsince;
            double templ = this.t2cof * tsq;
            if (!this.sgp4Simple) {
                double delomg = this.omgcof * tsince;
                double delm = this.xmcof * (Math.pow(1.0 + this.eta * Math.cos(xmdf), 3.0) - this.delmo);
                temp[0] = delomg + delm;
                xmp = xmdf + temp[0];
                omega = omgadf - temp[0];
                double tcube = tsq * tsince;
                double tfour = tsince * tcube;
                tempa = tempa - this.d2 * tsq - this.d3 * tcube - this.d4 * tfour;
                tempe += bstar * this.c5 * (Math.sin(xmp) - this.sinmo);
                templ = templ + this.t3cof * tcube + tfour * (this.t4cof + tsince * this.t5cof);
            }
            double a = this.aodp * Math.pow(tempa, 2.0);
            double eo = this.getTLE().getEo();
            double e = eo - tempe;
            double xl = xmp + omega + xnode + this.xnodp * templ;
            double beta = Math.sqrt(1.0 - e * e);
            double xn = 0.0743669161 / Math.pow(a, 1.5);
            double axn = e * Math.cos(omega);
            temp[0] = AbstractSatellite.invert(a * AbstractSatellite.sqr(beta));
            double xll = temp[0] * this.xlcof * axn;
            double aynl = temp[0] * this.aycof;
            double xlt = xl + xll;
            double ayn = e * Math.sin(omega) + aynl;
            temp[2] = capu = AbstractSatellite.mod2PI(xlt - xnode);
            AbstractSatellite.converge(temp, axn, ayn, capu);
            this.calculatePositionAndVelocity(temp, xnode, a, xn, axn, ayn);
            this.calculatePhase(xlt, xnode, omgadf);
        }
    }

    private void calculatePositionAndVelocity(double[] temp, double xnode, double a, double xn, double axn, double ayn) {
        double ecose = temp[5] + temp[6];
        double esine = temp[3] - temp[4];
        double elsq = AbstractSatellite.sqr(axn) + AbstractSatellite.sqr(ayn);
        temp[0] = 1.0 - elsq;
        double pl = a * temp[0];
        double r = a * (1.0 - ecose);
        temp[1] = AbstractSatellite.invert(r);
        double rdot = 0.0743669161 * Math.sqrt(a) * esine * temp[1];
        double rfdot = 0.0743669161 * Math.sqrt(pl) * temp[1];
        temp[2] = a * temp[1];
        double betal = Math.sqrt(temp[0]);
        temp[3] = AbstractSatellite.invert(1.0 + betal);
        double cosu = temp[2] * (temp[8] - axn + ayn * esine * temp[3]);
        double sinu = temp[2] * (temp[7] - ayn - axn * esine * temp[3]);
        double u = Math.atan2(sinu, cosu);
        double sin2u = 2.0 * sinu * cosu;
        double cos2u = 2.0 * cosu * cosu - 1.0;
        temp[0] = AbstractSatellite.invert(pl);
        temp[1] = 5.413079E-4 * temp[0];
        temp[2] = temp[1] * temp[0];
        double rk = r * (1.0 - 1.5 * temp[2] * betal * this.x3thm1) + 0.5 * temp[1] * this.x1mth2 * cos2u;
        double uk = u - 0.25 * temp[2] * this.x7thm1 * sin2u;
        double xnodek = xnode + 1.5 * temp[2] * this.cosio * sin2u;
        double xinck = this.getTLE().getXincl() + 1.5 * temp[2] * this.cosio * this.sinio * cos2u;
        double rdotk = rdot - xn * temp[1] * this.x1mth2 * sin2u;
        double rfdotk = rfdot + xn * temp[1] * (this.x1mth2 * cos2u + 1.5 * this.x3thm1);
        super.calculatePositionAndVelocity(rk, uk, xnodek, xinck, rdotk, rfdotk);
    }
}

