/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.amsacode.predict4java.AbstractSatellite;
import com.github.amsacode.predict4java.DeepSpaceSatellite;
import com.github.amsacode.predict4java.LEOSatellite;
import com.github.amsacode.predict4java.Satellite;
import com.github.amsacode.predict4java.TLE;

public final class SatelliteFactory {
    private SatelliteFactory() {
    }

    public static synchronized Satellite createSatellite(TLE tle) throws IllegalArgumentException {
        if (null == tle) {
            throw new IllegalArgumentException("TLE was null");
        }
        AbstractSatellite satellite = null;
        satellite = tle.isDeepspace() ? new DeepSpaceSatellite(tle) : new LEOSatellite(tle);
        return satellite;
    }
}

