/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.amsacode.predict4java.GroundStationPosition;
import com.github.amsacode.predict4java.SatNotFoundException;
import com.github.amsacode.predict4java.SatPassTime;
import com.github.amsacode.predict4java.SatPos;
import com.github.amsacode.predict4java.Satellite;
import com.github.amsacode.predict4java.SatelliteFactory;
import com.github.amsacode.predict4java.TLE;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassPredictor {
    private static final String UTC = "UTC";
    private static final String SOUTH = "south";
    private static final String NORTH = "north";
    private static final double SPEED_OF_LIGHT = 2.99792458E8;
    private static final double TWOPI = Math.PI * 2;
    private static final String DEADSPOT_NONE = "none";
    static final TimeZone TZ = TimeZone.getTimeZone("UTC");
    private static Log log = LogFactory.getLog(PassPredictor.class);
    private final TLE tle;
    private final GroundStationPosition qth;
    private final Satellite sat;
    private int iterationCount;

    public PassPredictor(TLE theTLE, GroundStationPosition theQTH) throws IllegalArgumentException, SatNotFoundException {
        if (null == theTLE) {
            throw new IllegalArgumentException("TLE has not been set");
        }
        if (null == theQTH) {
            throw new IllegalArgumentException("QTH has not been set");
        }
        this.tle = theTLE;
        this.qth = theQTH;
        this.sat = SatelliteFactory.createSatellite(this.tle);
        if (null == this.sat) {
            throw new SatNotFoundException("Satellite has not been created");
        }
        if (!this.sat.willBeSeen(this.qth)) {
            throw new SatNotFoundException("Satellite will never appear above the horizon");
        }
    }

    public Long getDownlinkFreq(Long freq, Date date) throws SatNotFoundException {
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        SatPos satPos = this.getSatPos(cal.getTime());
        double rangeRate = satPos.getRangeRate();
        return (long)((double)freq.longValue() * (2.99792458E8 - rangeRate * 1000.0) / 2.99792458E8);
    }

    public SatPos getSatPos(Date time) throws SatNotFoundException {
        ++this.iterationCount;
        return this.sat.getPosition(this.qth, time);
    }

    public Long getUplinkFreq(Long freq, Date date) throws SatNotFoundException {
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        SatPos satPos = this.getSatPos(cal.getTime());
        double rangeRate = satPos.getRangeRate();
        return (long)((double)freq.longValue() * (2.99792458E8 + rangeRate * 1000.0) / 2.99792458E8);
    }

    public SatPassTime nextSatPass(Date date) throws SatNotFoundException {
        return this.nextSatPass(date, false);
    }

    public SatPassTime nextSatPass(Date date, boolean windBack) throws SatNotFoundException {
        Date now;
        Date now2;
        SatPos satPos;
        int aosAzimuth = 0;
        int losAzimuth = 0;
        double maxElevation = 0.0;
        double elevation = 0.0;
        String polePassed = DEADSPOT_NONE;
        Calendar cal = Calendar.getInstance(TZ);
        cal.clear();
        cal.setTimeInMillis(date.getTime());
        if (windBack) {
            double meanMotion = this.tle.getMeanmo();
            cal.add(12, (int)(-1440.0 / meanMotion / 4.0));
        }
        SatPos prevPos = satPos = this.getSatPos(cal.getTime());
        if (satPos.getElevation() > 0.0) {
            while ((satPos = this.getPosition(cal, 60)).getElevation() > 0.0) {
            }
            cal.add(12, this.threeQuarterOrbitMinutes());
        }
        Date tca = null;
        do {
            satPos = this.getPosition(cal, 60);
            now2 = cal.getTime();
            elevation = satPos.getElevation();
            if (!(elevation > maxElevation)) continue;
            maxElevation = elevation;
            tca = now2;
        } while (satPos.getElevation() < 0.0);
        cal.add(13, -60);
        do {
            satPos = this.getPosition(cal, 5);
            now2 = cal.getTime();
            elevation = satPos.getElevation();
            if (elevation > maxElevation) {
                maxElevation = elevation;
                tca = now2;
            }
            prevPos = satPos;
        } while (satPos.getElevation() < 0.0);
        Date startDate = satPos.getTime();
        aosAzimuth = (int)(satPos.getAzimuth() / (Math.PI * 2) * 360.0);
        do {
            satPos = this.getPosition(cal, 30);
            now = cal.getTime();
            String currPolePassed = this.getPolePassed(prevPos, satPos);
            if (!currPolePassed.equals(DEADSPOT_NONE)) {
                polePassed = currPolePassed;
            }
            log.debug((Object)("Current pole passed: " + polePassed));
            elevation = satPos.getElevation();
            if (elevation > maxElevation) {
                maxElevation = elevation;
                tca = now;
            }
            prevPos = satPos;
        } while (satPos.getElevation() > 0.0);
        cal.add(13, -30);
        do {
            satPos = this.getPosition(cal, 5);
            now = cal.getTime();
            elevation = satPos.getElevation();
            if (!(elevation > maxElevation)) continue;
            maxElevation = elevation;
            tca = now;
        } while (satPos.getElevation() > 0.0);
        Date endDate = satPos.getTime();
        losAzimuth = (int)(satPos.getAzimuth() / (Math.PI * 2) * 360.0);
        return new SatPassTime(startDate, endDate, tca, polePassed, aosAzimuth, losAzimuth, maxElevation / (Math.PI * 2) * 360.0);
    }

    private SatPos getPosition(Calendar cal, int offSet) throws SatNotFoundException {
        cal.add(13, offSet);
        SatPos satPos = this.getSatPos(cal.getTime());
        return satPos;
    }

    public List<SatPassTime> getPasses(Date start, int hoursAhead, boolean windBack) throws SatNotFoundException {
        Date lastAOS;
        this.iterationCount = 0;
        boolean windBackTime = windBack;
        ArrayList<SatPassTime> passes = new ArrayList<SatPassTime>();
        Date trackStartDate = start;
        Date trackEndDate = new Date(start.getTime() + (long)hoursAhead * 60L * 60L * 1000L);
        int count = 0;
        do {
            if (count > 0) {
                windBackTime = false;
            }
            SatPassTime pass = this.nextSatPass(trackStartDate, windBackTime);
            lastAOS = pass.getStartTime();
            passes.add(pass);
            trackStartDate = new Date(pass.getEndTime().getTime() + (long)this.threeQuarterOrbitMinutes() * 60L * 1000L);
            ++count;
        } while (lastAOS.compareTo(trackEndDate) < 0);
        return passes;
    }

    final int getIterationCount() {
        return this.iterationCount;
    }

    private int threeQuarterOrbitMinutes() {
        return (int)(1440.0 / this.tle.getMeanmo() * 0.75);
    }

    private String getPolePassed(SatPos prevPos, SatPos satPos) {
        double az2;
        String polePassed = DEADSPOT_NONE;
        double az1 = prevPos.getAzimuth() / (Math.PI * 2) * 360.0;
        if (az1 > (az2 = satPos.getAzimuth() / (Math.PI * 2) * 360.0)) {
            if (az1 > 350.0 && az2 < 10.0) {
                polePassed = NORTH;
            } else if (az1 > 180.0 && az2 < 180.0) {
                polePassed = SOUTH;
            }
        } else if (az1 < 10.0 && az2 > 350.0) {
            polePassed = NORTH;
        } else if (az1 < 180.0 && az2 > 180.0) {
            polePassed = SOUTH;
        }
        return polePassed;
    }

    public List<SatPos> getPositions(Date referenceDate, int incrementSeconds, int minutesBefore, int minutesAfter) throws SatNotFoundException {
        Date trackDate = new Date(referenceDate.getTime() - (long)minutesBefore * 60L * 1000L);
        Date endDateDate = new Date(referenceDate.getTime() + (long)minutesAfter * 60L * 1000L);
        ArrayList<SatPos> positions = new ArrayList<SatPos>();
        while (trackDate.before(endDateDate)) {
            positions.add(this.getSatPos(trackDate));
            trackDate = new Date(trackDate.getTime() + (long)(incrementSeconds * 1000));
        }
        return positions;
    }
}

