/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import com.github.amsacode.predict4java.Position;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SatPos {
    private static final String NL = "\n";
    private static final String DEG_CR = " deg.\n";
    private static final double EARTH_RADIUS_KM = 6378.137;
    private static final double R0 = 6378.16;
    private double azimuth;
    private double elevation;
    private double latitude;
    private double longitude;
    private Date time;
    private double range;
    private double rangeRate;
    private double phase;
    private double altitude;
    private double theta;
    private double eclipseDepth;
    private boolean eclipsed;
    private boolean aboveHorizon;

    public SatPos() {
    }

    public SatPos(double azimuth, double elevation, Date theTime) {
        this.azimuth = azimuth;
        this.elevation = elevation;
        this.time = new Date(theTime.getTime());
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Date getTime() {
        return new Date(this.time.getTime());
    }

    public final double getRange() {
        return this.range;
    }

    public final void setRange(double range) {
        this.range = range;
    }

    public final double getRangeRate() {
        return this.rangeRate;
    }

    public final void setRangeRate(double rangeRate) {
        this.rangeRate = rangeRate;
    }

    public final double getPhase() {
        return this.phase;
    }

    public final void setPhase(double phase) {
        this.phase = phase;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public final double getAltitude() {
        return this.altitude;
    }

    public final void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public final double getTheta() {
        return this.theta;
    }

    public final void setTheta(double theta) {
        this.theta = theta;
    }

    public final void setAzimuth(double azimuth) {
        this.azimuth = azimuth;
    }

    public final void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public final void setTime(Date time) {
        this.time = new Date(time.getTime());
    }

    public final boolean isAboveHorizon() {
        return this.aboveHorizon;
    }

    public final void setAboveHorizon(boolean aboveHorizon) {
        this.aboveHorizon = aboveHorizon;
    }

    protected final double getEclipseDepth() {
        return this.eclipseDepth;
    }

    protected final void setEclipseDepth(double eclipseDepth) {
        this.eclipseDepth = eclipseDepth;
    }

    protected final boolean isEclipsed() {
        return this.eclipsed;
    }

    protected final void setEclipsed(boolean eclipsed) {
        this.eclipsed = eclipsed;
    }

    public String toString() {
        return "Azimuth:    " + this.azimuth / (Math.PI * 2) * 360.0 + DEG_CR + "Elevation:  " + this.elevation / (Math.PI * 2) * 360.0 + DEG_CR + "Latitude:   " + this.latitude / (Math.PI * 2) * 360.0 + DEG_CR + "Longitude:  " + this.longitude / (Math.PI * 2) * 360.0 + DEG_CR + "Date:       " + this.time + NL + "Range:        " + this.range + " km.\nRange rate:   " + this.rangeRate + " m/S.\nPhase:        " + this.phase + " /(256)\nAltitude:     " + this.altitude + " km\nTheta:        " + this.theta + " rad/sec\nEclipsed:     " + this.eclipsed + NL + "Eclipse depth:" + this.eclipseDepth + " radians\n";
    }

    public String toShortString() {
        String returnString = "";
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(0);
        returnString = returnString + "Elevation: " + numberFormat.format(this.elevation / (Math.PI * 2) * 360.0) + DEG_CR + "Azimuth: " + numberFormat.format(this.azimuth / (Math.PI * 2) * 360.0) + DEG_CR;
        numberFormat.setMaximumFractionDigits(2);
        returnString = returnString + "Latitude: " + numberFormat.format(this.latitude / (Math.PI * 2) * 360.0) + DEG_CR + "Longitude: " + numberFormat.format(this.longitude / (Math.PI * 2) * 360.0) + DEG_CR;
        numberFormat.setMaximumFractionDigits(0);
        returnString = returnString + "Range: " + numberFormat.format(this.range) + " Km";
        return returnString;
    }

    public final List<Position> getRangeCircle(double incrementDegrees) {
        return SatPos.calculateRangeCirclePoints(this, incrementDegrees);
    }

    public final List<Position> getRangeCircle() {
        return this.getRangeCircle(1.0);
    }

    private static List<Position> calculateRangeCirclePoints(SatPos pos, double incrementDegrees) {
        double radiusKm = pos.getRangeCircleRadiusKm();
        double latitude = pos.latitude;
        double longitude = pos.longitude;
        double beta = radiusKm / 6378.16;
        ArrayList<Position> result = new ArrayList<Position>();
        int azi = 0;
        while (azi < 360) {
            double rangelong;
            double azimuth = (double)azi / 360.0 * 2.0 * Math.PI;
            double rangelat = Math.asin(Math.sin(latitude) * Math.cos(beta) + Math.cos(azimuth) * Math.sin(beta) * Math.cos(latitude));
            double num = Math.cos(beta) - Math.sin(latitude) * Math.sin(rangelat);
            double den = Math.cos(latitude) * Math.cos(rangelat);
            for (rangelong = azi == 0 && beta > 1.5707963267948966 - latitude ? longitude + Math.PI : (azi == 180 && beta > 1.5707963267948966 - latitude ? longitude + Math.PI : (Math.abs(num / den) > 1.0 ? longitude : (180 - azi >= 0 ? longitude - Math.acos(num / den) : longitude + Math.acos(num / den)))); rangelong < 0.0; rangelong += Math.PI * 2) {
            }
            while (rangelong > Math.PI * 2) {
                rangelong -= Math.PI * 2;
            }
            rangelat = rangelat / (Math.PI * 2) * 360.0;
            rangelong = rangelong / (Math.PI * 2) * 360.0;
            result.add(new Position(rangelat, rangelong));
            azi = (int)((double)azi + incrementDegrees);
        }
        return result;
    }

    public double getRangeCircleRadiusKm() {
        return 0.5 * (12756.33 * Math.acos(6378.137 / (6378.137 + this.altitude)));
    }
}

