/*
 * Decompiled with CFR 0.152.
 */
package com.github.amsacode.predict4java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TLE
implements Serializable {
    private static final long serialVersionUID = 716922882884628016L;
    private static final int THREELINES = 3;
    private static final double DEG2RAD = 0.0174532925199433;
    private static final double TWO_PI = Math.PI * 2;
    private static final double MINS_PERDAY = 1440.0;
    private static final double XKE = 0.0743669161;
    private static final double TWO_THIRDS = 0.6666666666666666;
    private static final double CK2 = 5.413079E-4;
    private final int catnum;
    private final String name;
    private final int setnum;
    private final int year;
    private final double refepoch;
    private final double incl;
    private final double raan;
    private final double eccn;
    private final double argper;
    private final double meanan;
    private final double meanmo;
    private final double drag;
    private final double nddot6;
    private final double bstar;
    private final int orbitnum;
    private final double epoch;
    private final double xndt2o;
    private final double xincl;
    private final double xnodeo;
    private final double eo;
    private final double omegao;
    private final double xmo;
    private final double xno;
    private final boolean deepspace;

    public TLE(TLE tle) {
        this.catnum = tle.catnum;
        this.name = tle.name;
        this.setnum = tle.setnum;
        this.year = tle.year;
        this.refepoch = tle.refepoch;
        this.incl = tle.incl;
        this.raan = tle.raan;
        this.eccn = tle.eccn;
        this.argper = tle.argper;
        this.meanan = tle.meanan;
        this.meanmo = tle.meanmo;
        this.drag = tle.drag;
        this.nddot6 = tle.nddot6;
        this.bstar = tle.bstar;
        this.orbitnum = tle.orbitnum;
        this.epoch = tle.epoch;
        this.xndt2o = tle.xndt2o;
        this.xincl = tle.xincl;
        this.xnodeo = tle.xnodeo;
        this.eo = tle.eo;
        this.omegao = tle.omegao;
        this.xmo = tle.xmo;
        this.xno = tle.xno;
        this.deepspace = tle.deepspace;
    }

    public TLE(String[] tle) throws IllegalArgumentException {
        double del1;
        double ao;
        if (null == tle) {
            throw new IllegalArgumentException("TLE was null");
        }
        if (tle.length != 3) {
            throw new IllegalArgumentException("TLE had " + tle.length + " elements");
        }
        int lineCount = 0;
        for (String line : tle) {
            this.testArguments(lineCount, line);
            ++lineCount;
        }
        this.catnum = Integer.parseInt(StringUtils.strip((String)tle[1].substring(2, 7)));
        this.name = tle[0].trim();
        this.setnum = Integer.parseInt(StringUtils.strip((String)tle[1].substring(64, 68)));
        this.year = Integer.parseInt(StringUtils.strip((String)tle[1].substring(18, 20)));
        this.refepoch = Double.parseDouble(tle[1].substring(20, 32));
        this.incl = Double.parseDouble(tle[2].substring(8, 16));
        this.raan = Double.parseDouble(tle[2].substring(17, 25));
        this.eccn = 1.0E-7 * Double.parseDouble(tle[2].substring(26, 33));
        this.argper = Double.parseDouble(tle[2].substring(34, 42));
        this.meanan = Double.parseDouble(tle[2].substring(43, 51));
        this.meanmo = Double.parseDouble(tle[2].substring(52, 63));
        this.drag = Double.parseDouble(tle[1].substring(33, 43));
        double tempnum = 1.0E-5 * Double.parseDouble(tle[1].substring(44, 50));
        this.nddot6 = tempnum / Math.pow(10.0, Double.parseDouble(tle[1].substring(51, 52)));
        tempnum = 1.0E-5 * Double.parseDouble(tle[1].substring(53, 59));
        this.bstar = tempnum / Math.pow(10.0, Double.parseDouble(tle[1].substring(60, 61)));
        this.orbitnum = Integer.parseInt(StringUtils.strip((String)tle[2].substring(63, 68)));
        this.epoch = 1000.0 * (double)this.getYear() + this.getRefepoch();
        double temp = this.incl;
        this.xincl = temp *= 0.0174532925199433;
        temp = this.raan;
        this.xnodeo = temp *= 0.0174532925199433;
        this.eo = this.eccn;
        temp = this.argper;
        this.omegao = temp *= 0.0174532925199433;
        temp = this.meanan;
        this.xmo = temp *= 0.0174532925199433;
        double temp2 = 3.0300855069346E-6;
        this.xno = this.meanmo * temp2 * 1440.0;
        this.xndt2o = this.drag * temp2;
        double dd1 = 0.0743669161 / this.xno;
        double a1 = Math.pow(dd1, 0.6666666666666666);
        double r1 = Math.cos(this.xincl);
        temp2 = 8.1196185E-4 * (r1 * r1 * 3.0 - 1.0) / Math.pow(dd1 = 1.0 - this.eo * this.eo, 1.5);
        double delo = temp2 / ((ao = a1 * (1.0 - (del1 = temp2 / (a1 * a1)) * (0.3333333333333333 + del1 * (del1 * 1.654320987654321 + 1.0)))) * ao);
        double xnodp = this.xno / (delo + 1.0);
        this.deepspace = Math.PI * 2 / xnodp / 1440.0 >= 0.15625;
    }

    private void testArguments(int lineCount, String line) throws IllegalArgumentException {
        if (null == line) {
            throw new IllegalArgumentException(this.createIllegalArgumentMessage(lineCount, "was null"));
        }
        if (0 == line.length()) {
            throw new IllegalArgumentException(this.createIllegalArgumentMessage(lineCount, "was zero length"));
        }
    }

    public int getCatnum() {
        return this.catnum;
    }

    public String getName() {
        return this.name;
    }

    public int getSetnum() {
        return this.setnum;
    }

    public int getYear() {
        return this.year;
    }

    public double getRefepoch() {
        return this.refepoch;
    }

    public double getIncl() {
        return this.incl;
    }

    public double getRaan() {
        return this.raan;
    }

    public double getEccn() {
        return this.eccn;
    }

    public double getArgper() {
        return this.argper;
    }

    public double getMeanan() {
        return this.meanan;
    }

    public double getMeanmo() {
        return this.meanmo;
    }

    public double getDrag() {
        return this.drag;
    }

    public double getNddot6() {
        return this.nddot6;
    }

    public double getBstar() {
        return this.bstar;
    }

    public int getOrbitnum() {
        return this.orbitnum;
    }

    public boolean isDeepspace() {
        return this.deepspace;
    }

    public double getEo() {
        return this.eo;
    }

    public double getEpoch() {
        return this.epoch;
    }

    public double getOmegao() {
        return this.omegao;
    }

    public double getXincl() {
        return this.xincl;
    }

    public double getXmo() {
        return this.xmo;
    }

    public synchronized double getXndt2o() {
        return this.xndt2o;
    }

    public synchronized double getXno() {
        return this.xno;
    }

    public double getXnodeo() {
        return this.xnodeo;
    }

    private String createIllegalArgumentMessage(int lineCount, String problem) {
        return "TLE line[" + lineCount + "] " + problem;
    }

    public static List<TLE> importSat(InputStream fileIS) throws IOException {
        String readString;
        ArrayList<TLE> importedSats = new ArrayList<TLE>();
        BufferedReader buf = new BufferedReader(new InputStreamReader(fileIS, Charset.forName("UTF-8")));
        int j = 0;
        String[] lines = new String[3];
        block4: while ((readString = buf.readLine()) != null) {
            switch (j) {
                case 0: 
                case 1: {
                    lines[j] = readString;
                    ++j;
                    continue block4;
                }
                case 2: {
                    lines[j] = readString;
                    j = 0;
                    importedSats.add(new TLE(lines));
                    continue block4;
                }
            }
        }
        return importedSats;
    }

    public String toString() {
        return this.name;
    }
}

