/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.github.davidmoten.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import rx.functions.Func0;

public final class SqsMessage {
    private final String messageReceiptHandle;
    private final byte[] bytes;
    private final long timestamp;
    private final Optional<String> s3Id;
    private final Service service;

    SqsMessage(String messageReceiptHandle, byte[] bytes, long timestamp, Optional<String> s3Id, Service service) {
        this.messageReceiptHandle = messageReceiptHandle;
        this.bytes = bytes;
        this.timestamp = timestamp;
        this.s3Id = s3Id;
        this.service = service;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String message() {
        return new String(this.bytes(), StandardCharsets.UTF_8);
    }

    public long lastModifiedTime() {
        return this.timestamp;
    }

    public void deleteMessage() {
        try {
            this.deleteMessage(Client.FROM_SOURCE);
        }
        catch (RuntimeException e) {
            this.deleteMessage(Client.FROM_FACTORY);
        }
    }

    public void deleteMessage(Client client) {
        if (client == Client.FROM_SOURCE) {
            this.deleteMessage(this.service.s3, this.service.sqs);
        } else {
            this.deleteMessageUsingFactory(this.service.s3Factory, this.service.sqsFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMessageUsingFactory(Optional<Func0<AmazonS3Client>> s3Factory, Func0<AmazonSQSClient> sqsFactory) {
        Optional<AmazonS3Client> s3 = s3Factory.map(Func0::call);
        AmazonSQSClient sqs = (AmazonSQSClient)sqsFactory.call();
        try {
            this.deleteMessage(s3, sqs);
        }
        finally {
            s3.ifPresent(SqsMessage::shutdown);
            SqsMessage.shutdown((AmazonWebServiceClient)sqs);
        }
    }

    static void shutdown(AmazonWebServiceClient client) {
        try {
            client.shutdown();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void deleteMessage(Optional<AmazonS3Client> s3, AmazonSQSClient sqs) {
        Preconditions.checkArgument((!s3.isPresent() || this.s3Id.isPresent() ? 1 : 0) != 0, (String)"s3Id must be present");
        if (this.s3Id.isPresent()) {
            s3.get().deleteObject(this.service.bucketName.get(), this.s3Id.get());
        }
        sqs.deleteMessage(this.service.queueName, this.messageReceiptHandle);
    }

    public String toString() {
        return "MessageAndBytes [messageReceiptHandle=" + this.messageReceiptHandle + ", bytes=" + Arrays.toString(this.bytes) + ", timestamp=" + this.timestamp + ", s3Id=" + this.s3Id + ", bucketName=" + this.service.bucketName + ", queueName=" + this.service.queueName + "]";
    }

    static class Service {
        final Func0<AmazonSQSClient> sqsFactory;
        final Optional<Func0<AmazonS3Client>> s3Factory;
        final Optional<AmazonS3Client> s3;
        final AmazonSQSClient sqs;
        final String queueName;
        final Optional<String> bucketName;

        Service(Optional<Func0<AmazonS3Client>> s3Factory, Func0<AmazonSQSClient> sqsFactory, Optional<AmazonS3Client> s3, AmazonSQSClient sqs, String queueName, Optional<String> bucketName) {
            Preconditions.checkNotNull(s3Factory);
            Preconditions.checkNotNull(sqsFactory);
            Preconditions.checkNotNull(s3);
            Preconditions.checkNotNull((Object)sqs);
            Preconditions.checkNotNull((Object)queueName);
            Preconditions.checkNotNull(bucketName);
            this.s3Factory = s3Factory;
            this.sqsFactory = sqsFactory;
            this.s3 = s3;
            this.sqs = sqs;
            this.queueName = queueName;
            this.bucketName = bucketName;
        }
    }

    public static enum Client {
        FROM_SOURCE,
        FROM_FACTORY;

    }
}

