/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

public final class Functions {
    private Functions() {
    }

    public static <T> Func1<T, T> identity() {
        return new Func1<T, T>(){

            public T call(T t) {
                return t;
            }
        };
    }

    public static <T> Func1<T, Boolean> alwaysTrue() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return true;
            }
        };
    }

    public static <T> Func1<T, Boolean> alwaysFalse() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return false;
            }
        };
    }

    public static <T, R> Func1<T, R> constant(final R r) {
        return new Func1<T, R>(){

            public R call(T t) {
                return r;
            }
        };
    }

    public static <T> Func1<T, Boolean> not(final Func1<T, Boolean> f) {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return (Boolean)f.call(t) == false;
            }
        };
    }

    public static <T> Func1<T, Observable<T>> parallel(final Scheduler scheduler) {
        return new Func1<T, Observable<T>>(){

            public Observable<T> call(T t) {
                return Observable.just(t).subscribeOn(scheduler);
            }
        };
    }

    public static <T> Func1<T, Observable<T>> just() {
        return new Func1<T, Observable<T>>(){

            public Observable<T> call(T t) {
                return Observable.just(t);
            }
        };
    }

    public static <T> Func1<Iterable<T>, Observable<T>> iterableToObservable() {
        return new Func1<Iterable<T>, Observable<T>>(){

            public Observable<T> call(Iterable<T> iterable) {
                return Observable.from(iterable);
            }
        };
    }
}

