/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Strings;
import com.github.davidmoten.rx.operators.OperatorFileTailer;
import com.github.davidmoten.rx.operators.OperatorWatchServiceEvents;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.observables.GroupedObservable;

public final class FileObservable {
    public static final int DEFAULT_MAX_BYTES_PER_EMISSION = 8192;
    private static final Func1<WatchService, Observable<WatchEvent<?>>> TO_WATCH_EVENTS = new Func1<WatchService, Observable<WatchEvent<?>>>(){

        public Observable<WatchEvent<?>> call(WatchService watchService) {
            return FileObservable.from(watchService);
        }
    };
    private static Func1<Object, Boolean> IS_MODIFY_OR_OVERFLOW = new Func1<Object, Boolean>(){

        public Boolean call(Object event) {
            if (event instanceof WatchEvent) {
                WatchEvent w = (WatchEvent)event;
                String kind = w.kind().name();
                if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) || kind.equals(StandardWatchEventKinds.OVERFLOW.name())) {
                    return true;
                }
                return false;
            }
            return false;
        }
    };

    public static final Observable<byte[]> tailFile(File file, long startPosition, long sampleTimeMs, int chunkSize) {
        Observable events = FileObservable.from(file, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW).cast(Object.class).startWith(new Object());
        return FileObservable.tailFile(file, startPosition, sampleTimeMs, chunkSize, events);
    }

    public static final Observable<byte[]> tailFile(File file, long startPosition, long sampleTimeMs, int chunkSize, Observable<?> events) {
        return FileObservable.sampleModifyOrOverflowEventsOnly(events, sampleTimeMs).lift((Observable.Operator)new OperatorFileTailer(file, startPosition, chunkSize));
    }

    public static final Observable<String> tailTextFile(File file, long startPosition, long sampleTimeMs, Charset charset) {
        return FileObservable.toLines(FileObservable.tailFile(file, startPosition, sampleTimeMs, 8192), charset);
    }

    public static final Observable<String> tailTextFile(File file, long startPosition, int chunkSize, Charset charset, Observable<?> events) {
        return FileObservable.toLines((Observable<byte[]>)events.lift((Observable.Operator)new OperatorFileTailer(file, startPosition, chunkSize)).onBackpressureBuffer(), charset);
    }

    public static final Observable<WatchEvent<?>> from(WatchService watchService) {
        return Observable.just((Object)watchService).lift((Observable.Operator)new OperatorWatchServiceEvents()).onBackpressureBuffer();
    }

    @SafeVarargs
    public static final Observable<WatchEvent<?>> from(File file, WatchEvent.Kind<?> ... kinds) {
        return FileObservable.from(file, null, kinds);
    }

    public static final Observable<WatchEvent<?>> from(File file, final Action0 onWatchStarted, WatchEvent.Kind<?> ... kinds) {
        return FileObservable.watchService(file, kinds).doOnNext((Action1)new Action1<WatchService>(){

            public void call(WatchService w) {
                if (onWatchStarted != null) {
                    onWatchStarted.call();
                }
            }
        }).flatMap(TO_WATCH_EVENTS).filter(FileObservable.onlyRelatedTo(file));
    }

    @SafeVarargs
    public static final Observable<WatchService> watchService(final File file, final WatchEvent.Kind<?> ... kinds) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<WatchService>(){

            public void call(Subscriber<? super WatchService> subscriber) {
                try {
                    Path path = FileObservable.getBasePath(file);
                    WatchService watchService = path.getFileSystem().newWatchService();
                    path.register(watchService, kinds);
                    subscriber.onNext((Object)watchService);
                    subscriber.onCompleted();
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                }
            }
        });
    }

    private static final Path getBasePath(File file) {
        Path path = file.exists() && file.isDirectory() ? Paths.get(file.toURI()) : Paths.get(file.getParentFile().toURI());
        return path;
    }

    private static final Func1<WatchEvent<?>, Boolean> onlyRelatedTo(final File file) {
        return new Func1<WatchEvent<?>, Boolean>(){

            public Boolean call(WatchEvent<?> event) {
                boolean ok;
                if (file.isDirectory()) {
                    ok = true;
                } else if (StandardWatchEventKinds.OVERFLOW.equals(event.kind())) {
                    ok = true;
                } else {
                    Object context = event.context();
                    if (context != null && context instanceof Path) {
                        Path p = (Path)context;
                        Path basePath = FileObservable.getBasePath(file);
                        File pFile = new File(basePath.toFile(), p.toString());
                        ok = pFile.getAbsolutePath().equals(file.getAbsolutePath());
                    } else {
                        ok = false;
                    }
                }
                return ok;
            }
        };
    }

    private static Observable<String> toLines(Observable<byte[]> bytes, Charset charset) {
        return Strings.split((Observable)Strings.decode(bytes, (Charset)charset), (String)"\n");
    }

    private static Observable<Object> sampleModifyOrOverflowEventsOnly(Observable<?> events, long sampleTimeMs) {
        return events.groupBy(IS_MODIFY_OR_OVERFLOW).flatMap(FileObservable.sampleIfTrue(sampleTimeMs));
    }

    private static Func1<GroupedObservable<Boolean, ?>, Observable<?>> sampleIfTrue(final long sampleTimeMs) {
        return new Func1<GroupedObservable<Boolean, ?>, Observable<?>>(){

            public Observable<?> call(GroupedObservable<Boolean, ?> group) {
                if (((Boolean)group.getKey()).booleanValue()) {
                    return group.sample(sampleTimeMs, TimeUnit.MILLISECONDS);
                }
                return group;
            }
        };
    }

    public static Builder tailer() {
        return new Builder();
    }

    public static class Builder {
        private File file = null;
        private long startPosition = 0L;
        private long sampleTimeMs = 500L;
        private int chunkSize = 8192;
        private Charset charset = Charset.defaultCharset();
        private Observable<?> source = null;
        private Action0 onWatchStarted = new Action0(){

            public void call() {
            }
        };

        private Builder() {
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder file(String filename) {
            return this.file(new File(filename));
        }

        public Builder onWatchStarted(Action0 onWatchStarted) {
            this.onWatchStarted = onWatchStarted;
            return this;
        }

        public Builder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public Builder sampleTimeMs(long sampleTimeMs) {
            this.sampleTimeMs = sampleTimeMs;
            return this;
        }

        public Builder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder charset(String charset) {
            return this.charset(Charset.forName(charset));
        }

        public Builder utf8() {
            return this.charset("UTF-8");
        }

        public Builder source(Observable<?> source) {
            this.source = source;
            return this;
        }

        public Observable<byte[]> tail() {
            return FileObservable.tailFile(this.file, this.startPosition, this.sampleTimeMs, this.chunkSize, this.getSource());
        }

        public Observable<String> tailText() {
            return FileObservable.tailTextFile(this.file, this.startPosition, this.chunkSize, this.charset, this.getSource());
        }

        private Observable<?> getSource() {
            if (this.source == null) {
                return FileObservable.from(this.file, this.onWatchStarted, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
            }
            return this.source;
        }
    }
}

