/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.xml.JsonviewConfigurationSaxReader;
import com.github.developframework.jsonview.spring.SpringResourceConfigurationSource;
import java.io.IOException;
import java.util.HashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class JsonviewScanLoader {
    private String locations;

    public JsonviewScanLoader(String locations) {
        this.locations = locations;
    }

    public JsonviewConfiguration createJsonviewConfiguration() {
        String[] locationsArray = StringUtils.tokenizeToStringArray((String)this.locations, (String)",; \t\n");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            HashSet<SpringResourceConfigurationSource> sources = new HashSet<SpringResourceConfigurationSource>();
            for (String locationOne : locationsArray) {
                Resource[] resources = resolver.getResources(locationOne);
                for (int i = 0; i < resources.length; ++i) {
                    sources.add(new SpringResourceConfigurationSource(resources[i]));
                }
            }
            JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
            return reader.readConfiguration();
        }
        catch (IOException e) {
            throw new JsonviewException("Happen IOException when Spring ResourcePatternResolver get resource: %s", new Object[]{e.getMessage()});
        }
    }

    public JsonviewFactory createJsonviewFactory() {
        return new JsonviewFactory(new ObjectMapper(), this.createJsonviewConfiguration());
    }

    public JsonviewFactory createJsonviewFactory(ObjectMapper objectMapper) {
        return new JsonviewFactory(objectMapper, this.createJsonviewConfiguration());
    }

    public String getLocations() {
        return this.locations;
    }
}

