/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockTask;
import com.github.developframework.mock.RandomGeneratorRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public class MockClient {
    protected RandomGeneratorRegistry randomGeneratorRegistry = new RandomGeneratorRegistry();
    protected MockCache mockCache = new MockCache();

    public void clearCache() {
        this.mockCache.clear();
    }

    public String mock(@NonNull String template) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        MockTask mockTask = new MockTask(this.randomGeneratorRegistry, this.mockCache, template);
        return mockTask.run();
    }

    public List<String> mock(@NonNull String template, int quantity) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < quantity; ++i) {
            list.add(this.mock(template));
        }
        return list;
    }

    public String mock(InputStream inputStream, Charset charset) throws IOException {
        StringBuffer templateBuffer = new StringBuffer();
        IOUtils.readLines((InputStream)inputStream, (Charset)charset).forEach(line -> templateBuffer.append((String)line).append('\n'));
        return this.mock(templateBuffer.toString());
    }

    public List<String> mock(InputStream inputStream, Charset charset, int quantity) throws IOException {
        StringBuffer templateBuffer = new StringBuffer();
        IOUtils.readLines((InputStream)inputStream, (Charset)charset).forEach(line -> templateBuffer.append((String)line).append('\n'));
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < quantity; ++i) {
            list.add(this.mock(templateBuffer.toString()));
        }
        return list;
    }

    public RandomGeneratorRegistry getRandomGeneratorRegistry() {
        return this.randomGeneratorRegistry;
    }
}

