/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;

public class NumberRandomGenerator
implements RandomGenerator<Number> {
    private static final String PARAMETER_MAX = "max";
    private static final String PARAMETER_MIN = "min";
    private static final String PARAMETER_DIGIT = "digit";
    private static final String PARAMETER_DECIMALS = "decimals";
    private static final String PARAMETER_FILL_ZERO = "fillZero";

    @Override
    public Number randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache cache) {
        Number min = mockPlaceholder.getParameterOrDefault(PARAMETER_MIN, Number.class, 0);
        Number max = mockPlaceholder.getParameterOrDefault(PARAMETER_MAX, Number.class, 100);
        Optional<Integer> digitOptional = mockPlaceholder.getParameter(PARAMETER_DIGIT, Integer.class);
        if (min.doubleValue() > max.doubleValue()) {
            throw new MockException("min value greater than max value.");
        }
        boolean isDecimals = mockPlaceholder.getParameterOrDefault(PARAMETER_DECIMALS, Boolean.TYPE, false);
        Double result = new Double(RandomUtils.nextDouble((double)min.doubleValue(), (double)max.doubleValue()));
        if (isDecimals) {
            if (digitOptional.isPresent()) {
                return new BigDecimal(result).setScale((int)digitOptional.get(), RoundingMode.CEILING);
            }
            return result;
        }
        return ((Number)result).intValue();
    }

    public String key() {
        return "number";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, Number value) {
        Optional<Integer> fillZeroOptional = mockPlaceholder.getParameter(PARAMETER_FILL_ZERO, Integer.class);
        if (fillZeroOptional.isPresent()) {
            return String.format("%0" + fillZeroOptional.get() + "d", value.intValue());
        }
        return String.valueOf(value);
    }
}

