/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.random;

import com.github.developframework.mock.MockCache;
import com.github.developframework.mock.MockException;
import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.RandomGeneratorRegistry;
import com.github.developframework.mock.random.RandomGenerator;
import java.util.Optional;

public class QuoteRandomGenerator
implements RandomGenerator<Object> {
    private static final String PARAMETER_REF = "ref";

    @Override
    public Object randomValue(RandomGeneratorRegistry randomGeneratorRegistry, MockPlaceholder mockPlaceholder, MockCache mockCache) {
        Optional<String> idOptional = mockPlaceholder.getParameter(PARAMETER_REF, String.class);
        if (idOptional.isPresent()) {
            MockCache.Cache cache = (MockCache.Cache)mockCache.get(idOptional.get());
            if (cache == null) {
                throw new MockException("quote \"%s\" value is undefined.", idOptional.get());
            }
            return cache.getValue();
        }
        throw new MockException("\"id\" is not exist.");
    }

    public String key() {
        return "quote";
    }

    @Override
    public String forString(MockPlaceholder mockPlaceholder, Object value) {
        return String.valueOf(value);
    }
}

