/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring.cache;

import com.github.developframework.resource.Entity;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class ResourceCacheOperate<ENTITY extends Entity<ID>, ID extends Serializable> {
    protected RedisTemplate<String, ENTITY> redisTemplate;
    protected String key;
    protected Duration timeout;

    public ResourceCacheOperate(RedisTemplate<String, ENTITY> redisTemplate, String key, Duration timeout) {
        this.redisTemplate = redisTemplate;
        this.key = key;
        this.timeout = timeout;
    }

    public abstract void addCache(ENTITY var1);

    public abstract void refreshCache(ENTITY var1);

    public abstract void deleteCache(ENTITY var1);

    public abstract Optional<ENTITY> readCache(ID var1);

    public final String keyWithCondition(Object ... condtions) {
        return this.key + "::" + StringUtils.join((Object[])condtions, (String)"-");
    }
}

