/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jwebbox;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class WebBox {
    public static final String JWEBBOX_ID = "jwebbox";
    private String name;
    private String prepareStaticMethod;
    private Object prepareBean;
    private String prepareBeanMethod;
    private String prepareURL;
    private String text;
    private String page;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private WebBox fatherWebBox;

    public WebBox() {
    }

    public WebBox(String page) {
        this.setPage(page);
    }

    public static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    public void show(PageContext pageContext) {
        this.prepareOnly(pageContext);
        if (this.text != null && this.text.length() > 0) {
            try {
                pageContext.getOut().write(this.text);
            }
            catch (IOException e) {
                throw new WebBoxException(e);
            }
        }
        WebBox.showPageOrUrl(pageContext, this.page, this);
    }

    public void prepareOnly(PageContext pageContext) {
        if (!WebBox.isEmptyStr(this.prepareStaticMethod)) {
            int index = this.prepareStaticMethod.lastIndexOf(46);
            String className = this.prepareStaticMethod.substring(0, index);
            String methodName = this.prepareStaticMethod.substring(index + 1, this.prepareStaticMethod.length());
            if (WebBox.isEmptyStr(className) || WebBox.isEmptyStr(methodName)) {
                throw new WebBoxException("Error#001: Can not call method: " + this.prepareStaticMethod);
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, PageContext.class, WebBox.class);
                m.invoke(c, pageContext, this);
            }
            catch (Exception e) {
                throw new WebBoxException(e);
            }
        }
        if (this.prepareBean != null) {
            this.executeBeanMethod(pageContext);
        }
        WebBox.showPageOrUrl(pageContext, this.prepareURL, this);
    }

    private void executeBeanMethod(PageContext pageContext) {
        try {
            Class<?> c = this.prepareBean.getClass();
            String methodName = WebBox.isEmptyStr(this.prepareBeanMethod) ? "prepare" : this.prepareBeanMethod;
            Method m = c.getMethod(methodName, PageContext.class, WebBox.class);
            m.invoke(this.prepareBean, pageContext, this);
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
    }

    public void showPageOnly(PageContext pageContext) {
        WebBox.showPageOrUrl(pageContext, this.page, this);
    }

    private static void showPageOrUrl(PageContext pageContext, String pageOrUrl, WebBox currentBox) {
        if (WebBox.isEmptyStr(pageOrUrl)) {
            return;
        }
        WebBox fatherWebBox = (WebBox)pageContext.getRequest().getAttribute(JWEBBOX_ID);
        if (fatherWebBox != null) {
            currentBox.setFatherWebBox(fatherWebBox);
        }
        pageContext.getRequest().setAttribute(JWEBBOX_ID, (Object)currentBox);
        try {
            pageContext.getOut().flush();
            pageContext.getRequest().getRequestDispatcher(pageOrUrl).include(pageContext.getRequest(), pageContext.getResponse());
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
        finally {
            pageContext.getRequest().setAttribute(JWEBBOX_ID, (Object)fatherWebBox);
            currentBox.setFatherWebBox(null);
        }
    }

    public static WebBox getBox(PageContext pageContext) {
        WebBox currentBox = (WebBox)pageContext.getRequest().getAttribute(JWEBBOX_ID);
        if (currentBox == null) {
            throw new WebBoxException("Error#003: Can not find WebBox instance in pageContext");
        }
        return currentBox;
    }

    public static <T> T getAttribute(PageContext pageContext, String attributeName) {
        return WebBox.getBox(pageContext).getAttribute(attributeName);
    }

    public static void showAttribute(PageContext pageContext, String attributeName) {
        Object obj = WebBox.getAttribute(pageContext, attributeName);
        WebBox.showTarget(pageContext, obj);
    }

    public static void showTarget(PageContext pageContext, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof WebBox) {
            ((WebBox)target).show(pageContext);
        } else if (target instanceof ArrayList) {
            for (Object item : (ArrayList)target) {
                WebBox.showTarget(pageContext, item);
            }
        } else if (target instanceof String) {
            String str = (String)target;
            if (str.startsWith("/")) {
                WebBox.showPageOrUrl(pageContext, str, WebBox.getBox(pageContext));
            } else {
                try {
                    pageContext.getOut().write(str);
                }
                catch (IOException e) {
                    throw new WebBoxException(e);
                }
            }
        } else {
            throw new WebBoxException("Can not show unknow type object " + target + " on page");
        }
    }

    public WebBox setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributeMap.get(key);
    }

    public String getPrepareURL() {
        return this.prepareURL;
    }

    public WebBox setPrepareURL(String prepareURL) {
        this.prepareURL = prepareURL;
        return this;
    }

    public String getPage() {
        return this.page;
    }

    public WebBox setPage(String page) {
        this.page = page;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public WebBox setText(String text) {
        this.text = text;
        return this;
    }

    public WebBox setPrepareStaticMethod(String prepareStaticMethod) {
        this.prepareStaticMethod = prepareStaticMethod;
        return this;
    }

    public String getPrepareStaticMethod() {
        return this.prepareStaticMethod;
    }

    public Object getPrepareBean() {
        return this.prepareBean;
    }

    public WebBox setPrepareBean(Object prepareBean) {
        this.prepareBean = prepareBean;
        return this;
    }

    public String getPrepareBeanMethod() {
        return this.prepareBeanMethod;
    }

    public WebBox setPrepareBeanMethod(String prepareBeanMethod) {
        this.prepareBeanMethod = prepareBeanMethod;
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public WebBox setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebBox setName(String name) {
        this.name = name;
        return this;
    }

    public WebBox getFatherWebBox() {
        return this.fatherWebBox;
    }

    public void setFatherWebBox(WebBox fatherWebBox) {
        this.fatherWebBox = fatherWebBox;
    }

    public static class Show
    extends SimpleTagSupport {
        private String attribute;
        private Object target;

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public void doTag() throws JspException, IOException {
            if (this.attribute != null && this.attribute.length() != 0) {
                WebBox.showAttribute((PageContext)this.getJspContext(), this.getAttribute());
            }
            if (this.target != null) {
                WebBox.showTarget((PageContext)this.getJspContext(), this.target);
            }
        }
    }

    public static class WebBoxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WebBoxException(String msg) {
            super(msg);
        }

        public WebBoxException(Throwable e) {
            super(e);
        }
    }
}

