/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.codegen;
import com.github.esrrhs.fakescript.command;
import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.func_binary;
import com.github.esrrhs.fakescript.mybison;
import com.github.esrrhs.fakescript.syntree.assign_stmt;
import com.github.esrrhs.fakescript.syntree.block_node;
import com.github.esrrhs.fakescript.syntree.break_stmt;
import com.github.esrrhs.fakescript.syntree.cmp_stmt;
import com.github.esrrhs.fakescript.syntree.const_array_list_value_node;
import com.github.esrrhs.fakescript.syntree.const_map_list_value_node;
import com.github.esrrhs.fakescript.syntree.const_map_value_node;
import com.github.esrrhs.fakescript.syntree.container_get_node;
import com.github.esrrhs.fakescript.syntree.continue_stmt;
import com.github.esrrhs.fakescript.syntree.elseif_stmt;
import com.github.esrrhs.fakescript.syntree.esyntreetype;
import com.github.esrrhs.fakescript.syntree.explicit_value_node;
import com.github.esrrhs.fakescript.syntree.for_loop_stmt;
import com.github.esrrhs.fakescript.syntree.for_stmt;
import com.github.esrrhs.fakescript.syntree.func_desc_node;
import com.github.esrrhs.fakescript.syntree.function_call_node;
import com.github.esrrhs.fakescript.syntree.if_stmt;
import com.github.esrrhs.fakescript.syntree.math_assign_stmt;
import com.github.esrrhs.fakescript.syntree.math_expr_node;
import com.github.esrrhs.fakescript.syntree.multi_assign_stmt;
import com.github.esrrhs.fakescript.syntree.return_stmt;
import com.github.esrrhs.fakescript.syntree.return_value_list_node;
import com.github.esrrhs.fakescript.syntree.sleep_stmt;
import com.github.esrrhs.fakescript.syntree.struct_pointer_node;
import com.github.esrrhs.fakescript.syntree.switch_case_node;
import com.github.esrrhs.fakescript.syntree.switch_caselist_node;
import com.github.esrrhs.fakescript.syntree.switch_stmt;
import com.github.esrrhs.fakescript.syntree.syntree_node;
import com.github.esrrhs.fakescript.syntree.var_node;
import com.github.esrrhs.fakescript.syntree.variable_node;
import com.github.esrrhs.fakescript.syntree.while_stmt;
import com.github.esrrhs.fakescript.syntree.yield_stmt;
import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant;
import com.github.esrrhs.fakescript.variant_array;
import com.github.esrrhs.fakescript.variant_map;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class compiler {
    private fake m_f;
    private mybison m_mbs;
    private String m_cur_compile_func;
    private ArrayList<ArrayList<Integer>> m_loop_break_pos_stack = new ArrayList();
    private ArrayList<Integer> m_loop_continue_pos_stack = new ArrayList();
    private ArrayList<ArrayList<Integer>> m_continue_end_pos_stack = new ArrayList();
    private boolean m_cmp_jne;
    private long m_cur_addr;
    private ArrayList<Long> m_cur_addrs = new ArrayList();
    private int m_cmp_deps;
    private boolean m_new_var;
    private int m_func_ret_num = 1;

    public compiler(fake f, mybison mbs) {
        this.m_f = f;
        this.m_mbs = mbs;
    }

    public boolean compile() throws Exception {
        if (!this.compile_const_head()) {
            return false;
        }
        return this.compile_body();
    }

    public boolean compile_const_head() throws Exception {
        types.log(this.m_f, "[compiler] compile_const_head", new Object[0]);
        HashMap<String, syntree_node> evm = this.m_mbs.get_const_map();
        for (Map.Entry<String, syntree_node> entry : evm.entrySet()) {
            String name = entry.getKey();
            explicit_value_node ev = (explicit_value_node)entry.getValue();
            variant v = this.compile_explicit_value_node_to_variant(ev);
            if (v == null) {
                types.log(this.m_f, "[compiler] compile_explicit_value_node_to_variant %s fail", name);
                return false;
            }
            String constname = types.gen_package_name(this.m_mbs.get_package(), name);
            this.m_f.pa.reg_const_define(constname, v, ev.lineno());
            types.log(this.m_f, "[compiler] reg_const_define %s %s", constname, v);
        }
        return true;
    }

    public boolean compile_body() throws Exception {
        for (func_desc_node funcnode : this.m_mbs.get_func_list()) {
            if (this.compile_func(funcnode)) continue;
            types.log(this.m_f, "[compiler] compile_body %s fail", funcnode.m_funcname);
            return false;
        }
        types.log(this.m_f, "[compiler] compile_body funclist %d ok dump \n%s", this.m_mbs.get_func_list().size(), this.m_f.bin.dump());
        types.log(this.m_f, "[compiler] compile_body funcmap %d ok dump \n%s", this.m_f.fm.size(), this.m_f.fm.dump());
        return true;
    }

    public void compile_seterror(syntree_node node, String formatstr, Object ... args) {
        String str = String.format(formatstr, args);
        types.seterror(this.m_f, this.m_mbs.get_filename(), node.lineno(), this.m_cur_compile_func, str, new Object[0]);
    }

    public boolean compile_func(func_desc_node funcnode) throws Exception {
        this.m_cur_compile_func = funcnode.m_funcname;
        codegen cg = new codegen(this.m_f);
        func_binary bin = new func_binary();
        bin.m_end_lineno = funcnode.m_endline;
        cg.push_stack_identifiers();
        if (funcnode.m_arglist != null) {
            ArrayList<String> arglist = funcnode.m_arglist.m_arglist;
            for (int i = 0; i < arglist.size(); ++i) {
                String arg = arglist.get(i);
                if (cg.add_stack_identifier(arg, funcnode.m_arglist.lineno()) != -1) continue;
                this.compile_seterror(funcnode.m_arglist, "double %s identifier error", arg);
                return false;
            }
            bin.m_paramnum = arglist.size();
        }
        if (funcnode.m_block != null && !this.compile_block(cg, funcnode.m_block)) {
            return false;
        }
        if (!this.m_loop_break_pos_stack.isEmpty()) {
            this.compile_seterror(funcnode, "compile extra break error", new Object[0]);
            return false;
        }
        String funcname = types.gen_package_name(this.m_mbs.get_package(), funcnode.m_funcname);
        cg.output(this.m_mbs.get_filename(), this.m_mbs.get_package(), funcname, bin);
        this.m_f.opt.optimize(bin);
        variant fv = new variant();
        fv.set_string(funcname);
        this.m_f.bin.add_func(fv, bin);
        types.log(this.m_f, "[compiler] compile_func func %s OK", funcname);
        return true;
    }

    public boolean compile_block(codegen cg, block_node blocknode) throws Exception {
        for (int i = 0; i < blocknode.m_stmtlist.size(); ++i) {
            syntree_node stmt = blocknode.m_stmtlist.get(i);
            if (this.compile_node(cg, stmt)) continue;
            return false;
        }
        return true;
    }

    public boolean compile_node(codegen cg, syntree_node node) throws Exception {
        esyntreetype type = node.gettype();
        switch (type) {
            case est_block: {
                block_node bn = (block_node)node;
                if (this.compile_block(cg, bn)) break;
                return false;
            }
            case est_while_stmt: {
                while_stmt ws = (while_stmt)node;
                if (this.compile_while_stmt(cg, ws)) break;
                return false;
            }
            case est_for_stmt: {
                for_stmt fs = (for_stmt)node;
                if (this.compile_for_stmt(cg, fs)) break;
                return false;
            }
            case est_multi_assign_stmt: {
                multi_assign_stmt as = (multi_assign_stmt)node;
                if (this.compile_multi_assign_stmt(cg, as)) break;
                return false;
            }
            case est_cmp_stmt: {
                cmp_stmt cs = (cmp_stmt)node;
                if (this.compile_cmp_stmt(cg, cs)) break;
                return false;
            }
            case est_if_stmt: {
                if_stmt is = (if_stmt)node;
                if (this.compile_if_stmt(cg, is)) break;
                return false;
            }
            case est_explicit_value: {
                explicit_value_node ev = (explicit_value_node)node;
                if (this.compile_explicit_value(cg, ev)) break;
                return false;
            }
            case est_return_stmt: {
                return_stmt rs = (return_stmt)node;
                if (this.compile_return_stmt(cg, rs)) break;
                return false;
            }
            case est_return_value_list: {
                return_value_list_node rn = (return_value_list_node)node;
                if (this.compile_return_value_list(cg, rn)) break;
                return false;
            }
            case est_assign_stmt: {
                assign_stmt as = (assign_stmt)node;
                if (this.compile_assign_stmt(cg, as)) break;
                return false;
            }
            case est_math_assign_stmt: {
                math_assign_stmt ms = (math_assign_stmt)node;
                if (this.compile_math_assign_stmt(cg, ms)) break;
                return false;
            }
            case est_variable: {
                variable_node vn = (variable_node)node;
                if (this.compile_variable_node(cg, vn)) break;
                return false;
            }
            case est_var: {
                var_node vn = (var_node)node;
                if (this.compile_var_node(cg, vn)) break;
                return false;
            }
            case est_function_call: {
                function_call_node fn = (function_call_node)node;
                if (this.compile_function_call_node(cg, fn)) break;
                return false;
            }
            case est_break: {
                break_stmt bs = (break_stmt)node;
                if (this.compile_break_stmt(cg, bs)) break;
                return false;
            }
            case est_continue: {
                continue_stmt cs = (continue_stmt)node;
                if (this.compile_continue_stmt(cg, cs)) break;
                return false;
            }
            case est_math_expr: {
                math_expr_node mn = (math_expr_node)node;
                if (this.compile_math_expr_node(cg, mn)) break;
                return false;
            }
            case est_container_get: {
                container_get_node cn = (container_get_node)node;
                if (this.compile_container_get(cg, cn)) break;
                return false;
            }
            case est_struct_pointer: {
                struct_pointer_node cn = (struct_pointer_node)node;
                if (this.compile_struct_pointer(cg, cn)) break;
                return false;
            }
            case est_sleep: {
                sleep_stmt ss = (sleep_stmt)node;
                if (this.compile_sleep_stmt(cg, ss)) break;
                return false;
            }
            case est_yield: {
                yield_stmt ys = (yield_stmt)node;
                if (this.compile_yield_stmt(cg, ys)) break;
                return false;
            }
            case est_switch_stmt: {
                switch_stmt ss = (switch_stmt)node;
                if (this.compile_switch_stmt(cg, ss)) break;
                return false;
            }
            case est_for_loop_stmt: {
                for_loop_stmt fs = (for_loop_stmt)node;
                if (this.compile_for_loop_stmt(cg, fs)) break;
                return false;
            }
            default: {
                this.compile_seterror(node, "compile node type error %s", type.toString());
                return false;
            }
        }
        return true;
    }

    public variant compile_explicit_value_node_to_variant(explicit_value_node ev) throws Exception {
        variant v = new variant();
        switch (ev.m_type) {
            case EVT_NULL: {
                v.set_pointer(null);
                break;
            }
            case EVT_TRUE: {
                v.set_real(1.0);
                break;
            }
            case EVT_FALSE: {
                v.set_real(0.0);
                break;
            }
            case EVT_NUM: {
                v.set_real(Integer.valueOf(ev.m_str).intValue());
                break;
            }
            case EVT_STR: {
                v.set_string(ev.m_str);
                break;
            }
            case EVT_FLOAT: {
                v.set_real(Double.valueOf(ev.m_str));
                break;
            }
            case EVT_UUID: {
                v.set_uuid(Long.valueOf(ev.m_str.substring(0, ev.m_str.length() - 1)));
                break;
            }
            case EVT_MAP: {
                const_map_list_value_node cml = (const_map_list_value_node)ev.m_v;
                variant_map vm = new variant_map();
                vm.m_isconst = true;
                for (int i = 0; i < cml.m_lists.size(); ++i) {
                    const_map_value_node cmv = (const_map_value_node)cml.m_lists.get(i);
                    explicit_value_node kn = (explicit_value_node)cmv.m_k;
                    explicit_value_node vn = (explicit_value_node)cmv.m_v;
                    variant kv = this.compile_explicit_value_node_to_variant(kn);
                    variant vv = this.compile_explicit_value_node_to_variant(vn);
                    variant des = vm.con_map_get(kv);
                    des.copy_from(vv);
                }
                v.set_map(vm);
                break;
            }
            case EVT_ARRAY: {
                const_array_list_value_node cal = (const_array_list_value_node)ev.m_v;
                variant_array va = new variant_array();
                va.m_isconst = true;
                for (int i = 0; i < cal.m_lists.size(); ++i) {
                    explicit_value_node vn = (explicit_value_node)cal.m_lists.get(i);
                    variant kv = new variant();
                    kv.set_real(i);
                    variant vv = this.compile_explicit_value_node_to_variant(vn);
                    variant des = va.con_array_get(kv);
                    des.copy_from(vv);
                }
                v.set_array(va);
                break;
            }
            default: {
                throw new Exception("compile explicit value type error " + ev.m_type.toString());
            }
        }
        return v;
    }

    public boolean compile_while_stmt(codegen cg, while_stmt ws) throws Exception {
        int startpos = 0;
        int jnepos = 0;
        this.m_loop_break_pos_stack.add(new ArrayList());
        startpos = cg.byte_code_size();
        this.m_loop_continue_pos_stack.add(startpos);
        cg.push_stack_identifiers();
        if (!this.compile_node(cg, ws.m_cmp)) {
            return false;
        }
        cg.pop_stack_identifiers();
        if (this.m_cmp_jne) {
            cg.push(-1L, ws.m_cmp.lineno());
            jnepos = cg.byte_code_size() - 1;
        } else {
            cg.push(command.MAKE_OPCODE(13), ws.lineno());
            cg.push(this.m_cur_addr, ws.lineno());
            cg.push(-1L, ws.lineno());
            jnepos = cg.byte_code_size() - 1;
        }
        this.m_cmp_deps = 0;
        this.m_cmp_jne = false;
        if (ws.m_block != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, ws.m_block)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        cg.push(command.MAKE_OPCODE(14), ws.lineno());
        cg.push(command.MAKE_POS(startpos), ws.lineno());
        cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
        ArrayList<Integer> bplist = this.m_loop_break_pos_stack.get(this.m_loop_break_pos_stack.size() - 1);
        for (int i = 0; i < bplist.size(); ++i) {
            cg.set(bplist.get(i), command.MAKE_POS(cg.byte_code_size()));
        }
        this.m_loop_break_pos_stack.remove(this.m_loop_break_pos_stack.size() - 1);
        this.m_loop_continue_pos_stack.remove(this.m_loop_continue_pos_stack.size() - 1);
        return true;
    }

    public boolean compile_for_stmt(codegen cg, for_stmt fs) throws Exception {
        int startpos = 0;
        int jnepos = 0;
        int continuepos = 0;
        this.m_loop_break_pos_stack.add(new ArrayList());
        this.m_continue_end_pos_stack.add(new ArrayList());
        cg.push_stack_identifiers();
        if (fs.m_beginblock != null && !this.compile_node(cg, fs.m_beginblock)) {
            return false;
        }
        startpos = cg.byte_code_size();
        this.m_loop_continue_pos_stack.add(-1);
        cg.push_stack_identifiers();
        if (!this.compile_node(cg, fs.m_cmp)) {
            return false;
        }
        cg.pop_stack_identifiers();
        if (this.m_cmp_jne) {
            cg.push(-1L, fs.m_cmp.lineno());
            jnepos = cg.byte_code_size() - 1;
        } else {
            cg.push(command.MAKE_OPCODE(13), fs.lineno());
            cg.push(this.m_cur_addr, fs.lineno());
            cg.push(-1L, fs.lineno());
            jnepos = cg.byte_code_size() - 1;
        }
        this.m_cmp_deps = 0;
        this.m_cmp_jne = false;
        if (fs.m_block != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, fs.m_block)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        continuepos = cg.byte_code_size();
        if (fs.m_endblock != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, fs.m_endblock)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        cg.push(command.MAKE_OPCODE(14), fs.lineno());
        cg.push(command.MAKE_POS(startpos), fs.lineno());
        cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
        ArrayList<Integer> bplist = this.m_loop_break_pos_stack.get(this.m_loop_break_pos_stack.size() - 1);
        for (int i = 0; i < bplist.size(); ++i) {
            cg.set(bplist.get(i), command.MAKE_POS(cg.byte_code_size()));
        }
        this.m_loop_break_pos_stack.remove(this.m_loop_break_pos_stack.size() - 1);
        ArrayList<Integer> cplist = this.m_continue_end_pos_stack.get(this.m_continue_end_pos_stack.size() - 1);
        for (int i = 0; i < cplist.size(); ++i) {
            cg.set(cplist.get(i), command.MAKE_POS(continuepos));
        }
        this.m_continue_end_pos_stack.remove(this.m_continue_end_pos_stack.size() - 1);
        this.m_loop_continue_pos_stack.remove(this.m_loop_continue_pos_stack.size() - 1);
        cg.pop_stack_identifiers();
        return true;
    }

    public boolean compile_if_stmt(codegen cg, if_stmt is) throws Exception {
        int jnepos = 0;
        ArrayList<Integer> jmpifpos = new ArrayList<Integer>();
        cg.push_stack_identifiers();
        if (!this.compile_node(cg, is.m_cmp)) {
            return false;
        }
        cg.pop_stack_identifiers();
        if (this.m_cmp_jne) {
            cg.push(-1L, is.m_cmp.lineno());
            jnepos = cg.byte_code_size() - 1;
        } else {
            cg.push(command.MAKE_OPCODE(13), is.lineno());
            cg.push(this.m_cur_addr, is.lineno());
            cg.push(-1L, is.lineno());
            jnepos = cg.byte_code_size() - 1;
        }
        this.m_cmp_deps = 0;
        this.m_cmp_jne = false;
        if (is.m_block != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, is.m_block)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        if (is.m_elseifs != null || is.m_elses != null && is.m_elses.m_block != null) {
            cg.push(command.MAKE_OPCODE(14), is.lineno());
            cg.push(-1L, is.lineno());
            jmpifpos.add(cg.byte_code_size() - 1);
        }
        if (is.m_elseifs != null) {
            ArrayList<syntree_node> list = is.m_elseifs.m_stmtlist;
            for (int i = 0; i < list.size(); ++i) {
                elseif_stmt eis = (elseif_stmt)list.get(i);
                cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
                cg.push_stack_identifiers();
                if (!this.compile_node(cg, eis.m_cmp)) {
                    return false;
                }
                cg.pop_stack_identifiers();
                if (this.m_cmp_jne) {
                    cg.push(-1L, eis.m_cmp.lineno());
                    jnepos = cg.byte_code_size() - 1;
                } else {
                    cg.push(command.MAKE_OPCODE(13), eis.lineno());
                    cg.push(this.m_cur_addr, eis.lineno());
                    cg.push(-1L, eis.lineno());
                    jnepos = cg.byte_code_size() - 1;
                }
                this.m_cmp_deps = 0;
                this.m_cmp_jne = false;
                if (eis.m_block != null) {
                    cg.push_stack_identifiers();
                    if (!this.compile_node(cg, eis.m_block)) {
                        return false;
                    }
                    cg.pop_stack_identifiers();
                }
                cg.push(command.MAKE_OPCODE(14), eis.lineno());
                cg.push(-1L, eis.lineno());
                jmpifpos.add(cg.byte_code_size() - 1);
            }
        }
        cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
        if (is.m_elses != null && is.m_elses.m_block != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, is.m_elses.m_block)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        for (int i = 0; i < jmpifpos.size(); ++i) {
            cg.set((Integer)jmpifpos.get(i), command.MAKE_POS(cg.byte_code_size()));
        }
        return true;
    }

    public boolean compile_return_stmt(codegen cg, return_stmt rs) throws Exception {
        if (rs.m_returnlist != null) {
            if (!this.compile_node(cg, rs.m_returnlist)) {
                return false;
            }
            cg.push(command.MAKE_OPCODE(12), rs.lineno());
            cg.push(command.MAKE_POS(rs.m_returnlist.m_returnlist.size()), rs.lineno());
            for (int i = 0; i < rs.m_returnlist.m_returnlist.size(); ++i) {
                cg.push(this.m_cur_addrs.get(i), rs.lineno());
            }
        } else {
            cg.push(command.MAKE_OPCODE(12), rs.lineno());
            cg.push(command.MAKE_POS(0), rs.lineno());
        }
        return true;
    }

    public boolean compile_assign_stmt(codegen cg, assign_stmt as) throws Exception {
        long var = 0L;
        long value = 0L;
        if (!this.compile_node(cg, as.m_value)) {
            return false;
        }
        value = this.m_cur_addr;
        this.m_new_var = as.m_isnew;
        if (!this.compile_node(cg, as.m_var)) {
            return false;
        }
        this.m_new_var = false;
        var = this.m_cur_addr;
        cg.push(command.MAKE_OPCODE(0), as.lineno());
        cg.push(var, as.lineno());
        cg.push(value, as.lineno());
        return true;
    }

    public boolean compile_multi_assign_stmt(codegen cg, multi_assign_stmt as) throws Exception {
        int i;
        this.m_func_ret_num = as.m_varlist.m_varlist.size();
        if (!this.compile_node(cg, as.m_value)) {
            return false;
        }
        ArrayList<Long> varlist = new ArrayList<Long>();
        for (i = 0; i < as.m_varlist.m_varlist.size(); ++i) {
            this.m_new_var = as.m_isnew;
            if (!this.compile_node(cg, as.m_varlist.m_varlist.get(i))) {
                return false;
            }
            this.m_new_var = false;
            varlist.add(this.m_cur_addr);
        }
        for (i = 0; i < as.m_varlist.m_varlist.size(); ++i) {
            long var = 0L;
            long value = 0L;
            var = (Long)varlist.get(i);
            value = this.m_cur_addrs.get(i);
            cg.push(command.MAKE_OPCODE(0), as.lineno());
            cg.push(var, as.lineno());
            cg.push(value, as.lineno());
        }
        return true;
    }

    public boolean compile_math_assign_stmt(codegen cg, math_assign_stmt ms) throws Exception {
        long oper = 0L;
        long var = 0L;
        long value = 0L;
        if (ms.m_oper.equals("+=")) {
            oper = command.MAKE_OPCODE(7);
        } else if (ms.m_oper.equals("-=")) {
            oper = command.MAKE_OPCODE(8);
        } else if (ms.m_oper.equals("*=")) {
            oper = command.MAKE_OPCODE(9);
        } else if (ms.m_oper.equals("/=")) {
            oper = command.MAKE_OPCODE(10);
        } else if (ms.m_oper.equals("%=")) {
            oper = command.MAKE_OPCODE(11);
        } else {
            this.compile_seterror(ms, "compile math assign oper type %s error", ms.m_oper);
            return false;
        }
        if (!this.compile_node(cg, ms.m_value)) {
            return false;
        }
        value = this.m_cur_addr;
        if (!this.compile_node(cg, ms.m_var)) {
            return false;
        }
        var = this.m_cur_addr;
        cg.push(oper, ms.lineno());
        cg.push(var, ms.lineno());
        cg.push(value, ms.lineno());
        return true;
    }

    public boolean compile_break_stmt(codegen cg, break_stmt bs) throws Exception {
        cg.push(command.MAKE_OPCODE(14), bs.lineno());
        cg.push(-1L, bs.lineno());
        int jmppos = cg.byte_code_size() - 1;
        ArrayList<Integer> bplist = this.m_loop_break_pos_stack.get(this.m_loop_break_pos_stack.size() - 1);
        bplist.add(jmppos);
        return true;
    }

    public boolean compile_continue_stmt(codegen cg, continue_stmt cs) throws Exception {
        if (this.m_loop_continue_pos_stack.isEmpty()) {
            this.compile_seterror(cs, "no loop to continue", new Object[0]);
            return false;
        }
        int continuepos = this.m_loop_continue_pos_stack.get(this.m_loop_continue_pos_stack.size() - 1);
        cg.push(command.MAKE_OPCODE(14), cs.lineno());
        cg.push(command.MAKE_POS(continuepos), cs.lineno());
        if (continuepos == -1) {
            int pos = cg.byte_code_size() - 1;
            ArrayList<Integer> cplist = this.m_continue_end_pos_stack.get(this.m_continue_end_pos_stack.size() - 1);
            cplist.add(pos);
        }
        return true;
    }

    public boolean compile_cmp_stmt(codegen cg, cmp_stmt cs) throws Exception {
        int deps = this.m_cmp_deps++;
        long oper = 0L;
        long left = 0L;
        long right = 0L;
        long dest = 0L;
        if (!cs.m_cmp.equals("not")) {
            if (cs.m_cmp.equals("&&")) {
                oper = deps == 0 ? command.MAKE_OPCODE(26) : command.MAKE_OPCODE(17);
            } else if (cs.m_cmp.equals("||")) {
                oper = deps == 0 ? command.MAKE_OPCODE(27) : command.MAKE_OPCODE(18);
            } else if (cs.m_cmp.equals("<")) {
                oper = deps == 0 ? command.MAKE_OPCODE(28) : command.MAKE_OPCODE(19);
            } else if (cs.m_cmp.equals(">")) {
                oper = deps == 0 ? command.MAKE_OPCODE(29) : command.MAKE_OPCODE(20);
            } else if (cs.m_cmp.equals("==")) {
                oper = deps == 0 ? command.MAKE_OPCODE(30) : command.MAKE_OPCODE(21);
            } else if (cs.m_cmp.equals(">=")) {
                oper = deps == 0 ? command.MAKE_OPCODE(31) : command.MAKE_OPCODE(22);
            } else if (cs.m_cmp.equals("<=")) {
                oper = deps == 0 ? command.MAKE_OPCODE(32) : command.MAKE_OPCODE(23);
            } else if (cs.m_cmp.equals("!=")) {
                oper = deps == 0 ? command.MAKE_OPCODE(33) : command.MAKE_OPCODE(24);
            } else {
                if (cs.m_cmp.equals("true")) {
                    variant v = new variant();
                    v.set_real(1.0);
                    int pos = cg.getconst(v);
                    this.m_cur_addr = command.MAKE_ADDR(1, pos);
                    --this.m_cmp_deps;
                    this.m_cmp_jne = false;
                    return true;
                }
                if (cs.m_cmp.equals("false")) {
                    variant v = new variant();
                    v.set_real(0.0);
                    int pos = cg.getconst(v);
                    this.m_cur_addr = command.MAKE_ADDR(1, pos);
                    --this.m_cmp_deps;
                    this.m_cmp_jne = false;
                    return true;
                }
                if (cs.m_cmp.equals("is")) {
                    if (!this.compile_node(cg, cs.m_left)) {
                        return false;
                    }
                    --this.m_cmp_deps;
                    this.m_cmp_jne = false;
                    return true;
                }
                this.compile_seterror(cs, "cmp error %s", cs.m_cmp);
                return false;
            }
            if (!this.compile_node(cg, cs.m_left)) {
                return false;
            }
            left = this.m_cur_addr;
            if (!this.compile_node(cg, cs.m_right)) {
                return false;
            }
            right = this.m_cur_addr;
            int despos = cg.alloc_stack_identifier();
            this.m_cur_addr = dest = command.MAKE_ADDR(0, despos);
            cg.push(oper, cs.lineno());
            cg.push(left, cs.lineno());
            cg.push(right, cs.lineno());
            cg.push(dest, cs.lineno());
        } else {
            long l = oper = deps == 0 ? command.MAKE_OPCODE(34) : command.MAKE_OPCODE(25);
            if (!this.compile_node(cg, cs.m_left)) {
                return false;
            }
            left = this.m_cur_addr;
            int despos = cg.alloc_stack_identifier();
            this.m_cur_addr = dest = command.MAKE_ADDR(0, despos);
            cg.push(oper, cs.lineno());
            cg.push(left, cs.lineno());
            cg.push(dest, cs.lineno());
        }
        --this.m_cmp_deps;
        if (deps == 0) {
            this.m_cmp_jne = true;
        }
        return true;
    }

    public boolean compile_explicit_value(codegen cg, explicit_value_node ev) throws Exception {
        variant v = this.compile_explicit_value_node_to_variant(ev);
        int pos = cg.getconst(v);
        this.m_cur_addr = command.MAKE_ADDR(1, pos);
        return true;
    }

    public boolean compile_variable_node(codegen cg, variable_node vn) throws Exception {
        String constname = types.gen_package_name(this.m_mbs.get_package(), vn.m_str);
        variant gcv = this.m_f.pa.get_const_define(constname);
        if (gcv != null) {
            int pos = cg.getconst(gcv);
            this.m_cur_addr = command.MAKE_ADDR(1, pos);
            return true;
        }
        gcv = this.m_f.pa.get_const_define(vn.m_str);
        if (gcv != null) {
            int pos = cg.getconst(gcv);
            this.m_cur_addr = command.MAKE_ADDR(1, pos);
            return true;
        }
        int pos = cg.getvariable(vn.m_str);
        if (pos == -1) {
            if (this.m_new_var) {
                var_node tmp = new var_node();
                tmp.m_str = vn.m_str;
                return this.compile_var_node(cg, tmp);
            }
            this.compile_seterror(vn, "variable %s not found", vn.m_str);
            return false;
        }
        this.m_cur_addr = command.MAKE_ADDR(0, pos);
        return true;
    }

    public boolean compile_var_node(codegen cg, var_node vn) throws Exception {
        if (cg.get_cur_variable_pos(vn.m_str) != -1) {
            this.compile_seterror(vn, "variable %s has define", vn.m_str);
            return false;
        }
        HashMap<String, syntree_node> evm = this.m_mbs.get_const_map();
        if (evm.get(vn.m_str) != null) {
            this.compile_seterror(vn, "variable %s has defined const", vn.m_str);
            return false;
        }
        variant gcv = this.m_f.pa.get_const_define(vn.m_str);
        if (gcv != null) {
            this.compile_seterror(vn, "variable %s has defined global const", vn.m_str);
            return false;
        }
        int pos = cg.add_stack_identifier(vn.m_str, vn.lineno());
        if (pos == -1) {
            this.compile_seterror(vn, "double %s identifier error", vn.m_str);
            return false;
        }
        this.m_cur_addr = command.MAKE_ADDR(0, pos);
        return true;
    }

    public boolean compile_function_call_node(codegen cg, function_call_node fn) throws Exception {
        int i;
        long callpos;
        int ret_num = this.m_func_ret_num;
        this.m_func_ret_num = 1;
        ArrayList<Long> arglist = new ArrayList<Long>();
        if (fn.m_arglist != null) {
            for (int i2 = 0; i2 < fn.m_arglist.m_arglist.size(); ++i2) {
                syntree_node sn = fn.m_arglist.m_arglist.get(i2);
                if (!this.compile_node(cg, sn)) {
                    return false;
                }
                arglist.add(this.m_cur_addr);
            }
        }
        if (fn.m_prefuc == null) {
            variant v;
            String func = fn.m_fuc;
            int pos = cg.getvariable(func);
            if (pos != -1) {
                callpos = command.MAKE_ADDR(0, pos);
            } else if (this.m_mbs.is_have_struct(func)) {
                v = new variant();
                v.set_string("map");
                pos = cg.getconst(v);
                callpos = command.MAKE_ADDR(1, pos);
            } else if (this.m_mbs.is_have_func(func)) {
                v = new variant();
                String pname = types.gen_package_name(this.m_mbs.get_package(), func);
                v.set_string(pname);
                pos = cg.getconst(v);
                callpos = command.MAKE_ADDR(1, pos);
            } else {
                v = new variant();
                v.set_string(func);
                pos = cg.getconst(v);
                callpos = command.MAKE_ADDR(1, pos);
            }
        } else {
            if (!this.compile_node(cg, fn.m_prefuc)) {
                return false;
            }
            callpos = this.m_cur_addr;
        }
        long oper = command.MAKE_OPCODE(35);
        long calltype = fn.m_fakecall ? command.MAKE_POS(1) : (fn.m_classmem_call ? command.MAKE_POS(2) : command.MAKE_POS(0));
        long argnum = command.MAKE_POS(arglist.size());
        long retnum = command.MAKE_POS(ret_num);
        int oldretsize = this.m_cur_addrs.size();
        for (int i3 = 0; i3 < ret_num - oldretsize; ++i3) {
            this.m_cur_addrs.add(new Long(0L));
        }
        ArrayList<Long> ret = new ArrayList<Long>();
        for (i = 0; i < ret_num; ++i) {
            int retpos = cg.alloc_stack_identifier();
            ret.add(command.MAKE_ADDR(0, retpos));
            this.m_cur_addrs.set(i, (Long)ret.get(i));
        }
        this.m_cur_addr = ret.size() > 0 ? (Long)ret.get(0) : 0L;
        cg.push(oper, fn.lineno());
        cg.push(calltype, fn.lineno());
        cg.push(callpos, fn.lineno());
        cg.push(retnum, fn.lineno());
        for (i = 0; i < ret_num; ++i) {
            cg.push((Long)ret.get(i), fn.lineno());
        }
        cg.push(argnum, fn.lineno());
        for (i = 0; i < arglist.size(); ++i) {
            cg.push((Long)arglist.get(i), fn.lineno());
        }
        return true;
    }

    public boolean compile_math_expr_node(codegen cg, math_expr_node mn) throws Exception {
        long oper = 0L;
        long left = 0L;
        long right = 0L;
        long dest = 0L;
        if (mn.m_oper.equals("+")) {
            oper = command.MAKE_OPCODE(1);
        } else if (mn.m_oper.equals("-")) {
            oper = command.MAKE_OPCODE(2);
        } else if (mn.m_oper.equals("*")) {
            oper = command.MAKE_OPCODE(3);
        } else if (mn.m_oper.equals("/")) {
            oper = command.MAKE_OPCODE(4);
        } else if (mn.m_oper.equals("%")) {
            oper = command.MAKE_OPCODE(5);
        } else if (mn.m_oper.equals("..")) {
            oper = command.MAKE_OPCODE(6);
        } else {
            this.compile_seterror(mn, "compile math oper type %s error", mn.m_oper);
            return false;
        }
        if (!this.compile_node(cg, mn.m_left)) {
            return false;
        }
        left = this.m_cur_addr;
        if (!this.compile_node(cg, mn.m_right)) {
            return false;
        }
        right = this.m_cur_addr;
        int despos = cg.alloc_stack_identifier();
        this.m_cur_addr = dest = command.MAKE_ADDR(0, despos);
        cg.push(oper, mn.lineno());
        cg.push(left, mn.lineno());
        cg.push(right, mn.lineno());
        cg.push(dest, mn.lineno());
        return true;
    }

    public boolean compile_return_value_list(codegen cg, return_value_list_node rn) throws Exception {
        ArrayList<Long> tmp = new ArrayList<Long>();
        for (int i = 0; i < rn.m_returnlist.size(); ++i) {
            if (!this.compile_node(cg, rn.m_returnlist.get(i))) {
                return false;
            }
            tmp.add(i, this.m_cur_addr);
        }
        this.m_cur_addrs = tmp;
        this.m_cur_addr = this.m_cur_addrs.get(0);
        return true;
    }

    public boolean compile_container_get(codegen cg, container_get_node cn) throws Exception {
        int pos;
        long con = 0L;
        variant gcv = this.m_f.pa.get_const_define(cn.m_container);
        if (gcv != null) {
            pos = cg.getconst(gcv);
            con = command.MAKE_ADDR(1, pos);
        } else {
            pos = cg.getvariable(cn.m_container);
            if (pos == -1) {
                this.compile_seterror(cn, "variable %s not found", cn.m_container);
                return false;
            }
            con = command.MAKE_ADDR(0, pos);
        }
        long key = 0L;
        if (!this.compile_node(cg, cn.m_key)) {
            return false;
        }
        key = this.m_cur_addr;
        int addrpos = cg.getcontaineraddr(con, key);
        this.m_cur_addr = command.MAKE_ADDR(2, addrpos);
        return true;
    }

    public boolean compile_struct_pointer(codegen cg, struct_pointer_node sn) throws Exception {
        int pos;
        String name = sn.m_str;
        ArrayList<String> tmp = new ArrayList<String>();
        while (true) {
            int pos2;
            if ((pos2 = name.indexOf("->")) == -1) break;
            tmp.add(name.substring(0, pos2));
            name = name.substring(pos2 + 2);
        }
        tmp.add(name);
        if (tmp.size() < 2) {
            return false;
        }
        String connname = (String)tmp.get(0);
        long con = 0L;
        variant gcv = this.m_f.pa.get_const_define(connname);
        if (gcv != null) {
            pos = cg.getconst(gcv);
            con = command.MAKE_ADDR(1, pos);
        } else {
            pos = cg.getvariable(connname);
            if (pos == -1) {
                this.compile_seterror(sn, "variable %s not found", connname);
                return false;
            }
            con = command.MAKE_ADDR(0, pos);
        }
        for (int i = 1; i < tmp.size(); ++i) {
            String keystr = (String)tmp.get(i);
            variant v = new variant();
            v.set_string(keystr);
            int pos3 = cg.getconst(v);
            long key = command.MAKE_ADDR(1, pos3);
            int addrpos = cg.getcontaineraddr(con, key);
            con = this.m_cur_addr = command.MAKE_ADDR(2, addrpos);
        }
        return true;
    }

    public boolean compile_sleep_stmt(codegen cg, sleep_stmt ss) throws Exception {
        long time = 0L;
        if (!this.compile_node(cg, ss.m_time)) {
            return false;
        }
        time = this.m_cur_addr;
        cg.push(command.MAKE_OPCODE(36), ss.lineno());
        cg.push(time, ss.lineno());
        return true;
    }

    public boolean compile_yield_stmt(codegen cg, yield_stmt ys) throws Exception {
        long time = 0L;
        if (!this.compile_node(cg, ys.m_time)) {
            return false;
        }
        time = this.m_cur_addr;
        cg.push(command.MAKE_OPCODE(37), ys.lineno());
        cg.push(time, ys.lineno());
        return true;
    }

    public boolean compile_switch_stmt(codegen cg, switch_stmt ss) throws Exception {
        int i;
        cg.push_stack_identifiers();
        if (!this.compile_node(cg, ss.m_cmp)) {
            return false;
        }
        long caseleft = this.m_cur_addr;
        int despos = cg.alloc_stack_identifier();
        long caseresult = command.MAKE_ADDR(0, despos);
        switch_caselist_node scln = (switch_caselist_node)ss.m_caselist;
        ArrayList<Integer> jmpswitchposlist = new ArrayList<Integer>();
        for (i = 0; i < scln.m_list.size(); ++i) {
            long oper = command.MAKE_OPCODE(21);
            long left = caseleft;
            long right = 0L;
            long dest = caseresult;
            switch_case_node scn = (switch_case_node)scln.m_list.get(i);
            if (!this.compile_node(cg, scn.m_cmp)) {
                return false;
            }
            right = this.m_cur_addr;
            cg.push(oper, scn.lineno());
            cg.push(left, scn.lineno());
            cg.push(right, scn.lineno());
            cg.push(dest, scn.lineno());
            cg.push(command.MAKE_OPCODE(13), scn.lineno());
            cg.push(dest, scn.lineno());
            cg.push(-1L, scn.lineno());
            int jnepos = cg.byte_code_size() - 1;
            if (scn.m_block != null) {
                cg.push_stack_identifiers();
                if (!this.compile_node(cg, scn.m_block)) {
                    return false;
                }
                cg.pop_stack_identifiers();
            }
            cg.push(command.MAKE_OPCODE(14), scn.lineno());
            cg.push(-1L, scn.lineno());
            int jmpswitchpos = cg.byte_code_size() - 1;
            jmpswitchposlist.add(jmpswitchpos);
            cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
        }
        if (ss.m_def != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, ss.m_def)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        cg.pop_stack_identifiers();
        for (i = 0; i < jmpswitchposlist.size(); ++i) {
            cg.set((Integer)jmpswitchposlist.get(i), command.MAKE_POS(cg.byte_code_size()));
        }
        return true;
    }

    public boolean compile_for_loop_stmt(codegen cg, for_loop_stmt fs) throws Exception {
        int startpos = 0;
        int jnepos = 0;
        int continuepos = 0;
        this.m_loop_break_pos_stack.add(new ArrayList());
        this.m_continue_end_pos_stack.add(new ArrayList());
        if (!this.compile_node(cg, fs.m_begin)) {
            return false;
        }
        long begin = this.m_cur_addr;
        cg.push_stack_identifiers();
        if (!this.compile_node(cg, fs.m_var)) {
            return false;
        }
        long var = this.m_cur_addr;
        if (!this.compile_node(cg, fs.m_end)) {
            return false;
        }
        long end = this.m_cur_addr;
        if (!this.compile_node(cg, fs.m_add)) {
            return false;
        }
        long add = this.m_cur_addr;
        cg.push(command.MAKE_OPCODE(15), fs.lineno());
        cg.push(var, fs.lineno());
        cg.push(begin, fs.lineno());
        cg.push(end, fs.lineno());
        cg.push(add, fs.lineno());
        cg.push(-1L, fs.lineno());
        jnepos = cg.byte_code_size() - 1;
        this.m_loop_continue_pos_stack.add(-1);
        startpos = cg.byte_code_size();
        if (fs.m_block != null) {
            cg.push_stack_identifiers();
            if (!this.compile_node(cg, fs.m_block)) {
                return false;
            }
            cg.pop_stack_identifiers();
        }
        continuepos = cg.byte_code_size();
        if (!this.compile_node(cg, fs.m_end)) {
            return false;
        }
        end = this.m_cur_addr;
        if (!this.compile_node(cg, fs.m_add)) {
            return false;
        }
        add = this.m_cur_addr;
        cg.push(command.MAKE_OPCODE(16), fs.lineno());
        cg.push(var, fs.lineno());
        cg.push(end, fs.lineno());
        cg.push(add, fs.lineno());
        cg.push(command.MAKE_POS(startpos), fs.lineno());
        cg.set(jnepos, command.MAKE_POS(cg.byte_code_size()));
        ArrayList<Integer> bplist = this.m_loop_break_pos_stack.get(this.m_loop_break_pos_stack.size() - 1);
        for (int i = 0; i < bplist.size(); ++i) {
            cg.set(bplist.get(i), command.MAKE_POS(cg.byte_code_size()));
        }
        this.m_loop_break_pos_stack.remove(this.m_loop_break_pos_stack.size() - 1);
        ArrayList<Integer> cplist = this.m_continue_end_pos_stack.get(this.m_continue_end_pos_stack.size() - 1);
        for (int i = 0; i < cplist.size(); ++i) {
            cg.set(cplist.get(i), command.MAKE_POS(continuepos));
        }
        this.m_continue_end_pos_stack.remove(this.m_continue_end_pos_stack.size() - 1);
        this.m_loop_continue_pos_stack.remove(this.m_loop_continue_pos_stack.size() - 1);
        cg.pop_stack_identifiers();
        return true;
    }
}

