/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant_array;
import com.github.esrrhs.fakescript.variant_map;
import com.github.esrrhs.fakescript.variant_type;

class variant {
    public variant_type m_type;
    public Object m_data;

    public variant() {
        this.set_nil();
    }

    public String toString() {
        double real;
        String ss = "";
        ss = this.m_type == variant_type.REAL ? (types.isint(real = ((Double)this.m_data).doubleValue()) ? "" + (long)real : "" + real) : (this.m_type == variant_type.STRING ? (String)this.m_data : (this.m_type == variant_type.UUID ? "" + (Long)this.m_data : (this.m_type == variant_type.POINTER ? "" + this.m_data : (this.m_type == variant_type.ARRAY ? types.arraytoa(this.m_data) : (this.m_type == variant_type.MAP ? types.maptoa(this.m_data) : (this.m_type == variant_type.NIL ? "nil" : "ERROR"))))));
        return ss;
    }

    public void set_nil() {
        this.m_type = variant_type.NIL;
        this.m_data = null;
    }

    public void set_pointer(Object o) {
        this.m_type = variant_type.POINTER;
        this.m_data = o;
    }

    public void set_real(double d) {
        this.m_type = variant_type.REAL;
        this.m_data = d;
    }

    public void set_string(String s) {
        this.m_type = variant_type.STRING;
        this.m_data = s;
    }

    public void set_uuid(long l) {
        this.m_type = variant_type.UUID;
        this.m_data = l;
    }

    public void set_array(variant_array va) {
        this.m_type = variant_type.ARRAY;
        this.m_data = va;
    }

    public void set_map(variant_map vm) {
        this.m_type = variant_type.MAP;
        this.m_data = vm;
    }

    public Object get_pointer() throws Exception {
        if (this.m_type != variant_type.POINTER && this.m_type != variant_type.NIL) {
            throw new Exception("variant get pointer fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return this.m_data;
    }

    public double get_real() throws Exception {
        if (this.m_type != variant_type.REAL && this.m_type != variant_type.NIL) {
            throw new Exception("variant get real fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return this.m_data == null ? 0.0 : (Double)this.m_data;
    }

    public String get_string() throws Exception {
        if (this.m_type != variant_type.STRING && this.m_type != variant_type.NIL) {
            throw new Exception("variant get string fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return this.m_data == null ? "" : (String)this.m_data;
    }

    public long get_uuid() throws Exception {
        if (this.m_type != variant_type.STRING && this.m_type != variant_type.NIL) {
            throw new Exception("variant get uuid fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return this.m_data == null ? 0L : (Long)this.m_data;
    }

    public variant_map get_map() throws Exception {
        if (this.m_type != variant_type.MAP) {
            throw new Exception("variant get map fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return (variant_map)this.m_data;
    }

    public variant_array get_array() throws Exception {
        if (this.m_type != variant_type.ARRAY) {
            throw new Exception("variant get array fail, the variant is " + this.m_type.toString() + this.m_data.toString());
        }
        return (variant_array)this.m_data;
    }

    public void assert_can_cal() throws Exception {
        if (this.m_type != variant_type.REAL && this.m_type != variant_type.NIL) {
            throw new Exception("variant can not calculate, the variant is " + this.m_type.toString() + " " + (this.m_data != null ? this.m_data.toString() : "null"));
        }
    }

    public void assert_can_divide() throws Exception {
        if ((Double)this.m_data == 0.0) {
            throw new Exception("variant can not be divide, the variant is " + this.m_type.toString() + " " + this.m_data.toString());
        }
    }

    public void plus(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data + (Double)r.m_data;
        this.m_type = variant_type.REAL;
    }

    public void minus(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data - (Double)r.m_data;
        this.m_type = variant_type.REAL;
    }

    public void multiply(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data * (Double)r.m_data;
        this.m_type = variant_type.REAL;
    }

    public void divide(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        r.assert_can_divide();
        this.m_data = (Double)l.m_data / (Double)r.m_data;
        this.m_type = variant_type.REAL;
    }

    public void divide_mod(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        r.assert_can_divide();
        this.m_data = (double)((long)((Double)l.m_data).doubleValue() % (long)((Double)r.m_data).doubleValue());
        this.m_type = variant_type.REAL;
    }

    public void string_cat(variant l, variant r) throws Exception {
        this.set_string(l.toString() + r.toString());
    }

    public void and(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data != 0.0 & (Double)r.m_data != 0.0 ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void or(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data != 0.0 | (Double)r.m_data != 0.0 ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void less(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data < (Double)r.m_data ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void more(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data > (Double)r.m_data ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void equal(variant l, variant r) throws Exception {
        this.m_data = l.equals(r) ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void less_equal(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data <= (Double)r.m_data ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void more_equal(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        this.m_data = (Double)l.m_data >= (Double)r.m_data ? 1.0 : 0.0;
        this.m_type = variant_type.REAL;
    }

    public void not_equal(variant l, variant r) throws Exception {
        this.m_data = l.equals(r) ? 0.0 : 1.0;
        this.m_type = variant_type.REAL;
    }

    public void not(variant r) throws Exception {
        this.m_data = (Double)r.m_data != 0.0 ? 0.0 : 1.0;
        this.m_type = variant_type.REAL;
    }

    public static boolean and_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data != 0.0 & (Double)r.m_data != 0.0;
    }

    public static boolean or_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data != 0.0 | (Double)r.m_data != 0.0;
    }

    public static boolean less_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data < (Double)r.m_data;
    }

    public static boolean more_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data > (Double)r.m_data;
    }

    public static boolean equal_jne(variant l, variant r) throws Exception {
        return l.equals(r);
    }

    public static boolean more_equal_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data >= (Double)r.m_data;
    }

    public static boolean less_equal_jne(variant l, variant r) throws Exception {
        l.assert_can_cal();
        r.assert_can_cal();
        return (Double)l.m_data <= (Double)r.m_data;
    }

    public static boolean not_equal_jne(variant l, variant r) throws Exception {
        return !l.equals(r);
    }

    public static boolean not_jne(variant r) throws Exception {
        r.assert_can_cal();
        return (Double)r.m_data == 0.0;
    }

    public boolean bool() {
        return (Double)this.m_data != 0.0;
    }

    public int hashCode() {
        return this.m_data != null ? this.m_data.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        variant r = (variant)o;
        if (this.m_type == variant_type.NIL && r.m_type == variant_type.POINTER && r.m_data == null || this.m_type == variant_type.POINTER && this.m_data == null && r.m_type == variant_type.NIL) {
            return true;
        }
        if (this.m_type != r.m_type) {
            return false;
        }
        if (this.m_type == variant_type.REAL) {
            return ((Double)this.m_data).doubleValue() == ((Double)r.m_data).doubleValue();
        }
        if (this.m_type == variant_type.STRING) {
            return ((String)this.m_data).equals(r.m_data);
        }
        if (this.m_type == variant_type.UUID) {
            return ((Long)this.m_data).longValue() == ((Long)r.m_data).longValue();
        }
        if (this.m_type == variant_type.POINTER) {
            return this.m_data == r.m_data;
        }
        if (this.m_type == variant_type.ARRAY) {
            return this.m_data == r.m_data;
        }
        if (this.m_type == variant_type.MAP) {
            return this.m_data == r.m_data;
        }
        return this.m_type == variant_type.NIL;
    }

    public void copy_from(variant r) {
        this.m_type = r.m_type;
        this.m_data = r.m_data;
    }
}

