/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.YYParser;
import com.github.esrrhs.fakescript.Yylex;
import com.github.esrrhs.fakescript.compiler;
import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.fk;
import com.github.esrrhs.fakescript.mybison;
import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class parser {
    private fake m_f;
    private int m_parse_dep = 0;
    private ArrayList<String> m_parsing_file_list = new ArrayList();
    private HashMap<String, variant> m_constv_map = new HashMap();
    private HashMap<String, Integer> m_constline_map = new HashMap();

    public parser(fake f) {
        this.m_f = f;
    }

    public parser clonef(fake f) {
        parser ret = new parser(f);
        ret.m_constv_map = (HashMap)this.m_constv_map.clone();
        ret.m_constline_map = (HashMap)this.m_constline_map.clone();
        return ret;
    }

    public void clear() {
        this.m_parse_dep = 0;
        this.m_parsing_file_list.clear();
    }

    public void reg_const_define(String constname, variant v, int lineno) {
        this.m_constv_map.put(constname, v);
        this.m_constline_map.put(constname, lineno);
    }

    public variant get_const_define(String constname) {
        return this.m_constv_map.get(constname);
    }

    public int get_const_define_lineno(String constname) {
        return this.m_constline_map.get(constname);
    }

    public boolean parsestr(String str) {
        StringReader reader = new StringReader(str);
        Yylex yylexer = new Yylex(reader);
        yylexer.set_fake(this.m_f);
        mybison mbs = new mybison(this.m_f, yylexer);
        mbs.set_filename("");
        yylexer.set_mybison(mbs);
        YYParser yyparser = new YYParser(yylexer);
        try {
            if (!yyparser.parse()) {
                types.seterror(this.m_f, "", mbs.get_error_line(), "", "parse %s file fail for reason : %s", "", mbs.get_error());
                return false;
            }
        }
        catch (Exception e) {
            types.seterror(this.m_f, "", fk.getcurline(this.m_f), fk.getcurfunc(this.m_f), "parse  fail " + types.show_exception(e), new Object[0]);
            return false;
        }
        try {
            compiler mc = new compiler(this.m_f, mbs);
            if (!mc.compile()) {
                return false;
            }
        }
        catch (Exception e) {
            types.seterror(this.m_f, "", fk.getcurline(this.m_f), fk.getcurfunc(this.m_f), "compiler  fail " + types.show_exception(e), new Object[0]);
            return false;
        }
        types.log(this.m_f, "parse str OK", new Object[0]);
        return true;
    }

    public boolean parse(String filename) {
        ++this.m_parse_dep;
        if (this.m_parse_dep >= this.m_f.cfg.include_deps) {
            types.seterror(this.m_f, filename, 0, "", "parse " + filename + " file too deep " + this.m_parse_dep, new Object[0]);
            return false;
        }
        if (this.is_parsing(filename)) {
            types.seterror(this.m_f, filename, 0, "", "already parsing " + filename + " file...include list \n" + this.get_parsing_file_list(), new Object[0]);
            return false;
        }
        this.m_parsing_file_list.add(filename);
        String content = this.read_file(filename);
        if (content.isEmpty()) {
            return false;
        }
        StringReader reader = new StringReader(content);
        Yylex yylexer = new Yylex(reader);
        yylexer.set_fake(this.m_f);
        mybison mbs = new mybison(this.m_f, yylexer);
        mbs.set_filename(filename);
        yylexer.set_mybison(mbs);
        YYParser yyparser = new YYParser(yylexer);
        try {
            if (!yyparser.parse()) {
                types.seterror(this.m_f, filename, yylexer.get_line() + 1, fk.getcurfunc(this.m_f), "parse %s file fail for reason : %s", filename, mbs.get_error());
                return false;
            }
        }
        catch (Exception e) {
            types.seterror(this.m_f, filename, yylexer.get_line() + 1, fk.getcurfunc(this.m_f), "parse " + filename + " fail " + types.show_exception(e), new Object[0]);
            return false;
        }
        for (int i = 0; i < mbs.get_include_list().size(); ++i) {
            String name = mbs.get_include_list().get(i);
            if (this.parse_include(filename, name)) continue;
            return false;
        }
        try {
            compiler mc = new compiler(this.m_f, mbs);
            if (!mc.compile()) {
                return false;
            }
        }
        catch (Exception e) {
            types.seterror(this.m_f, filename, fk.getcurline(this.m_f), fk.getcurfunc(this.m_f), "compiler " + filename + " fail " + types.show_exception(e), new Object[0]);
            return false;
        }
        this.m_parsing_file_list.remove(this.m_parsing_file_list.size() - 1);
        types.log(this.m_f, "parse " + filename + " OK", new Object[0]);
        return true;
    }

    private String read_file(String filename) {
        File file = new File(filename);
        if (!file.isFile() || !file.exists()) {
            types.seterror(this.m_f, filename, 0, "", "open " + filename + " fail", new Object[0]);
            return "";
        }
        try {
            String ret = "";
            String encoding = "utf-8";
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader bufferedReader = new BufferedReader(reader);
            char[] readbuff = new char[10];
            while (bufferedReader.read(readbuff) != -1) {
                ret = ret + String.valueOf(readbuff);
                Arrays.fill(readbuff, '\u0000');
            }
            ((Reader)reader).close();
            types.log(this.m_f, ret, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            types.seterror(this.m_f, filename, 0, "", "read " + filename + " fail " + types.show_exception(e), new Object[0]);
            return "";
        }
    }

    private boolean is_parsing(String filename) {
        boolean ret = false;
        for (int i = 0; i < this.m_parsing_file_list.size(); ++i) {
            if (this.m_parsing_file_list.get(i) != filename) continue;
            return true;
        }
        return ret;
    }

    private String get_parsing_file_list() {
        String ret = "";
        for (int i = 0; i < this.m_parsing_file_list.size(); ++i) {
            ret = ret + this.m_parsing_file_list.get(i);
            ret = ret + "\n";
        }
        return ret;
    }

    private boolean parse_include(String srcname, String includename) {
        String dir = srcname;
        int pos = (dir = dir.replace('\\', '/')).lastIndexOf(47);
        dir = pos == -1 ? "" : dir.substring(0, pos + 1);
        return this.parse(dir = dir + includename);
    }
}

