/*
 * Decompiled with CFR 0.152.
 */
package com.github.esrrhs.fakescript;

import com.github.esrrhs.fakescript.command;
import com.github.esrrhs.fakescript.container_addr;
import com.github.esrrhs.fakescript.fake;
import com.github.esrrhs.fakescript.func_binary;
import com.github.esrrhs.fakescript.funcunion;
import com.github.esrrhs.fakescript.paramstack;
import com.github.esrrhs.fakescript.processor;
import com.github.esrrhs.fakescript.stack_variant_info;
import com.github.esrrhs.fakescript.types;
import com.github.esrrhs.fakescript.variant;
import com.github.esrrhs.fakescript.variant_type;
import com.github.esrrhs.fakescript.warper;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class interpreter {
    public static final String MAP_FUNC_NAME = "map";
    public static final String GMAP_FUNC_NAME = "_G";
    private fake m_f;
    private boolean m_isend;
    private ArrayList<variant> m_ret = new ArrayList();
    private processor m_processor;
    private static final int BP_SIZE = 5;
    private int m_sp;
    private int m_bp;
    private int m_ip;
    private func_binary m_fb;
    private ArrayList<variant> m_stack = new ArrayList();
    private long m_wakeuptime;
    private int m_yieldtime;
    private boolean m_sleeping;

    public interpreter(fake f) {
        this.m_f = f;
    }

    public boolean is_end() {
        return this.m_isend;
    }

    public variant get_ret() {
        return this.m_ret.isEmpty() ? new variant() : this.m_ret.get(0);
    }

    public void set_processor(processor pro) {
        this.m_processor = pro;
    }

    public int get_running_bytecode_pos() {
        return this.m_fb != null ? this.m_ip : -1;
    }

    public void call(variant func, ArrayList<Integer> retpos) throws Exception {
        funcunion f = this.m_f.fm.get_func(func);
        if (f == null) {
            throw new Exception("run no func " + func + " fail");
        }
        if (f.m_havefb) {
            variant v;
            int i;
            func_binary fb = f.m_fb;
            int needsize = this.m_sp + 5 + retpos.size() + fb.m_maxstack;
            if (needsize > this.m_stack.size()) {
                int oldsize = this.m_stack.size();
                for (i = 0; i < needsize - oldsize; ++i) {
                    this.m_stack.add(new variant());
                }
            }
            int oldbp = this.m_bp;
            this.m_bp = this.m_sp;
            for (i = 0; i < retpos.size(); ++i) {
                v = this.m_stack.get(this.m_bp);
                v.m_type = variant_type.NIL;
                v.m_data = retpos.get(i);
                ++this.m_bp;
            }
            v = this.m_stack.get(this.m_bp);
            v.m_type = variant_type.NIL;
            v.m_data = retpos.size();
            ++this.m_bp;
            v = this.m_stack.get(this.m_bp);
            v.m_type = variant_type.NIL;
            v.m_data = this.m_ip;
            ++this.m_bp;
            if (this.m_f.pf.isopen()) {
                v = this.m_stack.get(this.m_bp);
                v.m_data = System.currentTimeMillis();
            }
            v.m_type = variant_type.NIL;
            ++this.m_bp;
            v = this.m_stack.get(this.m_bp);
            v.m_type = variant_type.NIL;
            v.m_data = this.m_fb;
            ++this.m_bp;
            v = this.m_stack.get(this.m_bp);
            v.m_type = variant_type.NIL;
            v.m_data = oldbp;
            ++this.m_bp;
            this.m_sp = this.m_bp + fb.m_maxstack;
            if (this.m_f.ps.size() != fb.m_paramnum) {
                this.m_isend = true;
                throw new Exception("call func " + func + " param not match, need " + fb.m_paramnum + " give " + this.m_f.ps.size());
            }
            for (i = 0; i < fb.m_paramnum; ++i) {
                v = this.m_stack.get(this.m_bp + i);
                v.copy_from(this.m_f.ps.get(i));
            }
            this.m_f.ps.clear();
            if (this.m_ret.isEmpty()) {
                this.m_ret.add(new variant());
            } else {
                this.m_ret.get(0).set_nil();
            }
            ++fb.m_use;
            this.m_fb = fb;
            this.m_ip = 0;
            return;
        }
        long s = 0L;
        if (this.m_f.pf.isopen()) {
            s = System.currentTimeMillis();
        }
        if (f.m_haveff) {
            f.m_ff.call(this.m_f);
        } else if (f.m_havebif) {
            f.m_bif.call(this.m_f, this);
        } else {
            this.m_isend = true;
            throw new Exception("run no inter func " + func + " fail");
        }
        if (this.m_bp == 0) {
            variant cret = this.m_f.ps.pop_and_get();
            this.m_isend = true;
            if (this.m_ret.isEmpty()) {
                this.m_ret.add(new variant());
            }
            this.m_ret.get(0).copy_from(cret);
        } else {
            if (this.m_f.ps.size() != retpos.size()) {
                this.m_isend = true;
                throw new Exception("native func " + func + " return num not match, give " + this.m_f.ps.size() + " need " + retpos.size());
            }
            for (int i = 0; i < retpos.size(); ++i) {
                variant ret = this.GET_VARIANT(this.m_fb, this.m_bp, retpos.get(i));
                variant cret = this.m_f.ps.get(i);
                ret.copy_from(cret);
            }
        }
        if (this.m_f.pf.isopen()) {
            String name = func.get_string();
            this.m_f.pf.add_func_sample(name, System.currentTimeMillis() - s);
        }
    }

    public variant GET_VARIANT(func_binary fb, int bp, int pos) throws Exception {
        return this.GET_VARIANT_BY_CMD(fb, bp, fb.m_buff[pos]);
    }

    public variant GET_VARIANT_BY_CMD(func_binary fb, int bp, long cmd) throws Exception {
        long v_cmd = cmd;
        short v_addrtype = command.ADDR_TYPE(command.COMMAND_CODE(v_cmd));
        short v_addrpos = command.ADDR_POS(command.COMMAND_CODE(v_cmd));
        if (v_addrtype == 0) {
            return this.m_stack.get(bp + v_addrpos);
        }
        if (v_addrtype == 1) {
            return fb.m_const_list[v_addrpos];
        }
        if (v_addrtype == 2) {
            return this.get_container_variant(fb, v_addrpos);
        }
        throw new Exception("addrtype cannot be " + v_addrtype + " " + v_addrpos);
    }

    public variant get_container_variant(func_binary fb, int conpos) throws Exception {
        container_addr ca = fb.m_container_addr_list[conpos];
        variant conv = this.GET_VARIANT_BY_CMD(fb, this.m_bp, ca.m_con);
        variant keyv = this.GET_VARIANT_BY_CMD(fb, this.m_bp, ca.m_key);
        if (this.m_isend) {
            return null;
        }
        if (conv.m_type != variant_type.ARRAY && conv.m_type != variant_type.MAP) {
            this.m_isend = true;
            throw new Exception("interpreter get container variant fail, container type error, type " + (Object)((Object)conv.m_type));
        }
        if (conv.m_type == variant_type.MAP) {
            return conv.get_map().con_map_get(keyv);
        }
        if (conv.m_type == variant_type.ARRAY) {
            return conv.get_array().con_array_get(keyv);
        }
        return null;
    }

    public long BP_GET_CALLTIME(int bp) {
        variant v = this.m_stack.get(bp - 3);
        return (Long)v.m_data;
    }

    public int BP_GET_RETNUM(int bp) {
        variant v = this.m_stack.get(bp - 5);
        return (Integer)v.m_data;
    }

    public int BP_GET_BP(int bp) {
        variant v = this.m_stack.get(bp - 1);
        return (Integer)v.m_data;
    }

    public func_binary BP_GET_FB(int bp) {
        variant v = this.m_stack.get(bp - 2);
        return (func_binary)v.m_data;
    }

    public int BP_GET_IP(int bp) {
        variant v = this.m_stack.get(bp - 4);
        return (Integer)v.m_data;
    }

    public int BP_GET_RETPOS(int bp, int retnum, int i) {
        variant v = this.m_stack.get(bp - 5 - retnum + i);
        return (Integer)v.m_data;
    }

    public boolean CHECK_DST_POS(func_binary fb, int ip) {
        return this.CHECK_STACK_POS(fb, ip) | this.CHECK_CONTAINER_POS(fb, ip);
    }

    public boolean CHECK_STACK_POS(func_binary fb, int ip) {
        return command.ADDR_TYPE(command.COMMAND_CODE(fb.m_buff[ip])) == 0;
    }

    public boolean CHECK_CONTAINER_POS(func_binary fb, int ip) {
        return command.ADDR_TYPE(command.COMMAND_CODE(fb.m_buff[ip])) == 2;
    }

    public boolean CHECK_CONST_MAP_POS(variant v) throws Exception {
        return v.m_type == variant_type.MAP && v.get_map().m_isconst;
    }

    public boolean CHECK_CONST_ARRAY_POS(variant v) throws Exception {
        return v.m_type == variant_type.ARRAY && v.get_array().m_isconst;
    }

    public String POS_TYPE_NAME(func_binary fb, int ip) {
        short index = command.ADDR_TYPE(command.COMMAND_CODE(fb.m_buff[ip]));
        return variant_type.values()[index].name();
    }

    public int run(int cmdnum) throws Exception {
        int runcmdnum;
        block95: {
            runcmdnum = 0;
            if (this.m_stack.size() > this.m_f.cfg.stack_max) {
                this.m_isend = true;
                throw new Exception("stack too big " + this.m_stack.size());
            }
            if (this.m_sleeping) {
                if (this.m_yieldtime != 0) {
                    --this.m_yieldtime;
                    return 0;
                }
                if (System.currentTimeMillis() < this.m_wakeuptime) {
                    return 0;
                }
                this.m_wakeuptime = 0L;
            }
            if (this.m_isend) {
                return 0;
            }
            block42: do {
                try {
                    int i;
                    while (this.m_ip >= this.m_fb.m_buff.length) {
                        if (this.m_f.pf.isopen()) {
                            long calltime = this.BP_GET_CALLTIME(this.m_bp);
                            this.m_f.pf.add_func_sample(this.m_fb.m_name, System.currentTimeMillis() - calltime);
                        }
                        --this.m_fb.m_use;
                        if (this.m_fb.m_use == 0 && this.m_fb.m_backup != null) {
                            this.m_fb.backup_move();
                        }
                        int oldretnum = this.BP_GET_RETNUM(this.m_bp);
                        int callbp = this.BP_GET_BP(this.m_bp);
                        this.m_fb = this.BP_GET_FB(this.m_bp);
                        this.m_ip = this.BP_GET_IP(this.m_bp);
                        int oldbp = this.m_bp;
                        this.m_sp = this.m_bp - 5 - oldretnum;
                        this.m_bp = callbp;
                        if (this.m_bp == 0) {
                            this.m_isend = true;
                            break block95;
                        }
                        for (i = 0; i < oldretnum; ++i) {
                            int oldretpos = this.BP_GET_RETPOS(oldbp, oldretnum, i);
                            variant ret = this.GET_VARIANT(this.m_fb, this.m_bp, oldretpos);
                            ret.copy_from(this.m_ret.get(i));
                        }
                    }
                    int code = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                    ++this.m_ip;
                    if (this.m_f.pf.isopen()) {
                        this.m_f.pf.add_code_sample(code);
                    }
                    switch (code) {
                        case 0: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter assign error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant varv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(varv) || this.CHECK_CONST_ARRAY_POS(varv)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant valuev = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            varv.copy_from(valuev);
                            break;
                        }
                        case 1: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.plus(left, right);
                            break;
                        }
                        case 2: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.minus(left, right);
                            break;
                        }
                        case 3: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.multiply(left, right);
                            break;
                        }
                        case 4: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.divide(left, right);
                            break;
                        }
                        case 5: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.divide_mod(left, right);
                            break;
                        }
                        case 6: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.string_cat(left, right);
                            break;
                        }
                        case 17: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.and(left, right);
                            break;
                        }
                        case 18: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.or(left, right);
                            break;
                        }
                        case 19: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.less(left, right);
                            break;
                        }
                        case 20: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.more(left, right);
                            break;
                        }
                        case 21: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.equal(left, right);
                            break;
                        }
                        case 22: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.more_equal(left, right);
                            break;
                        }
                        case 23: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.less_equal(left, right);
                            break;
                        }
                        case 24: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.not_equal(left, right);
                            break;
                        }
                        case 25: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math oper error, dest is not stack, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant dest = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            dest.not(left);
                            break;
                        }
                        case 26: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.and_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 27: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.or_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 28: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.less_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 29: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.more_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 30: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.equal_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 31: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.more_equal_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 32: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.less_equal_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 33: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant right = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.not_equal_jne(left, right);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 34: {
                            variant left = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            ++this.m_ip;
                            int destip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            boolean b = variant.not_jne(left);
                            if (b) continue block42;
                            this.m_ip = destip;
                            break;
                        }
                        case 13: {
                            variant cmp = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            int ip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            if (cmp.bool()) continue block42;
                            this.m_ip = ip;
                            break;
                        }
                        case 14: {
                            int ip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            this.m_ip = ip;
                            break;
                        }
                        case 7: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math assign oper error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant var = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(var) || this.CHECK_CONST_ARRAY_POS(var)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant value = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            var.plus(var, value);
                            break;
                        }
                        case 8: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math assign oper error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant var = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(var) || this.CHECK_CONST_ARRAY_POS(var)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant value = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            var.minus(var, value);
                            break;
                        }
                        case 9: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math assign oper error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant var = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(var) || this.CHECK_CONST_ARRAY_POS(var)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant value = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            var.multiply(var, value);
                            break;
                        }
                        case 10: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math assign oper error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant var = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(var) || this.CHECK_CONST_ARRAY_POS(var)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant value = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            var.divide(var, value);
                            break;
                        }
                        case 11: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter math assign oper error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant var = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            if (this.CHECK_CONST_MAP_POS(var) || this.CHECK_CONST_ARRAY_POS(var)) {
                                throw new Exception("interpreter assign error, dest is const container");
                            }
                            ++this.m_ip;
                            variant value = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            var.divide_mod(var, value);
                            break;
                        }
                        case 35: {
                            int calltype = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            variant callpos = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            int retnum = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            ArrayList<Integer> retpos = new ArrayList<Integer>();
                            for (int i2 = 0; i2 < retnum; ++i2) {
                                retpos.add(this.m_ip);
                                ++this.m_ip;
                            }
                            int argnum = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            paramstack ps = this.m_f.ps;
                            ps.clear();
                            for (int i3 = 0; i3 < argnum; ++i3) {
                                variant arg = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                                ++this.m_ip;
                                variant argdest = ps.push_and_get();
                                argdest.copy_from(arg);
                            }
                            if (calltype == 0) {
                                this.call(callpos, retpos);
                                break;
                            }
                            if (calltype == 2) {
                                variant classvar = ps.get(ps.size() - 1);
                                if (classvar == null) {
                                    throw new Exception("interpreter class mem call error, the class ref is null");
                                }
                                Object classptr = classvar.get_pointer();
                                if (classptr == null) {
                                    throw new Exception("interpreter class mem call error, the class ref is null");
                                }
                                String funcname = callpos.get_string();
                                String wholename = classptr.getClass().getName() + funcname;
                                variant tmp = new variant();
                                tmp.set_string(wholename);
                                this.call(tmp, retpos);
                                break;
                            }
                            this.m_processor.start_routine(callpos, retpos);
                            break;
                        }
                        case 12: {
                            int returnnum = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            if (returnnum == 0) {
                                this.m_ip = this.m_fb.m_buff.length;
                                break;
                            }
                            ++this.m_ip;
                            int oldsize = this.m_ret.size();
                            for (i = 0; i < returnnum - oldsize; ++i) {
                                this.m_ret.add(new variant());
                            }
                            for (i = 0; i < returnnum; ++i) {
                                variant ret = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                                ++this.m_ip;
                                variant retv = new variant();
                                retv.copy_from(ret);
                                this.m_ret.set(i, retv);
                            }
                            this.m_ip = this.m_fb.m_buff.length;
                            break;
                        }
                        case 15: {
                            if (!this.CHECK_DST_POS(this.m_fb, this.m_ip)) {
                                throw new Exception("interpreter assign error, dest is not stack or container, type " + this.POS_TYPE_NAME(this.m_fb, this.m_ip));
                            }
                            variant varv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant beginv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant endv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant addv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            int jneip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            varv.copy_from(beginv);
                            if (addv.get_real() > 0.0) {
                                if (!(varv.get_real() >= endv.get_real())) continue block42;
                                this.m_ip = jneip;
                                break;
                            }
                            if (!(varv.get_real() <= endv.get_real())) continue block42;
                            this.m_ip = jneip;
                            break;
                        }
                        case 16: {
                            variant varv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant endv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            variant addv = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            int continueip = command.COMMAND_CODE(this.m_fb.m_buff[this.m_ip]);
                            ++this.m_ip;
                            varv.plus(varv, addv);
                            if (addv.get_real() > 0.0) {
                                if (!(varv.get_real() < endv.get_real())) continue block42;
                                this.m_ip = continueip;
                                break;
                            }
                            if (!(varv.get_real() > endv.get_real())) continue block42;
                            this.m_ip = continueip;
                            break;
                        }
                        case 36: {
                            variant time = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            long sleeptime = (long)time.get_real();
                            this.m_wakeuptime = System.currentTimeMillis() + sleeptime;
                            this.m_sleeping = true;
                            return runcmdnum + 1;
                        }
                        case 37: {
                            variant time = this.GET_VARIANT(this.m_fb, this.m_bp, this.m_ip);
                            ++this.m_ip;
                            this.m_yieldtime = (int)time.get_real();
                            this.m_sleeping = true;
                            return runcmdnum + 1;
                        }
                        default: {
                            throw new Exception("next err code " + code + " " + types.OpCodeStr(code));
                        }
                    }
                }
                catch (Exception e) {
                    this.m_isend = true;
                    int ip = this.m_ip;
                    int bp = this.m_bp;
                    func_binary fb = this.m_fb;
                    while (bp != 0) {
                        --fb.m_use;
                        if (fb.m_use == 0 && fb.m_backup != null) {
                            fb.backup_move();
                        }
                        fb = this.BP_GET_FB(bp);
                        ip = this.BP_GET_IP(bp);
                        int callbp = this.BP_GET_BP(bp);
                        if ((bp = callbp) != 0) continue;
                        break;
                    }
                    throw e;
                }
            } while (!this.m_isend && ++runcmdnum < cmdnum);
        }
        return runcmdnum;
    }

    public String get_running_file_name() {
        return this.m_fb != null ? this.m_fb.m_filename : "";
    }

    public String get_running_func_name() {
        return this.m_fb != null ? this.m_fb.m_name : "";
    }

    public int get_running_file_line() {
        return this.m_fb != null ? this.m_fb.get_binary_lineno(this.m_ip) : 0;
    }

    public String get_running_call_stack() {
        String cur_runinginfo = "";
        if (this.m_fb == null) {
            return "";
        }
        int deps = 0;
        int ip = this.m_ip;
        int bp = this.m_bp;
        func_binary fb = this.m_fb;
        while (bp != 0) {
            cur_runinginfo = cur_runinginfo + "#";
            cur_runinginfo = cur_runinginfo + deps;
            cur_runinginfo = cur_runinginfo + "\t";
            cur_runinginfo = cur_runinginfo + (fb != null ? fb.m_name : "");
            cur_runinginfo = cur_runinginfo + " at ";
            cur_runinginfo = cur_runinginfo + (fb != null ? fb.m_filename : "");
            cur_runinginfo = cur_runinginfo + ":";
            cur_runinginfo = cur_runinginfo + (fb != null ? fb.get_binary_lineno(ip) : 0);
            cur_runinginfo = cur_runinginfo + "\n";
            for (int j = 0; fb != null && j < fb.m_maxstack; ++j) {
                cur_runinginfo = cur_runinginfo + "\t\t";
                String variant_name = "";
                for (int i = 0; i < fb.m_debug_stack_variant_info.length; ++i) {
                    stack_variant_info info = fb.m_debug_stack_variant_info[i];
                    if (info.m_pos != j) continue;
                    variant_name = variant_name + info.m_name;
                    variant_name = variant_name + "(line:";
                    variant_name = variant_name + info.m_line;
                    variant_name = variant_name + ") ";
                }
                if (variant_name.isEmpty()) {
                    variant_name = "(anonymous)";
                }
                cur_runinginfo = cur_runinginfo + variant_name;
                cur_runinginfo = cur_runinginfo + "\t[";
                cur_runinginfo = cur_runinginfo + j;
                cur_runinginfo = cur_runinginfo + "]\t";
                variant v = bp + j < this.m_stack.size() ? this.m_stack.get(bp + j) : new variant();
                cur_runinginfo = cur_runinginfo + v;
                cur_runinginfo = cur_runinginfo + "\n";
            }
            fb = this.BP_GET_FB(bp);
            ip = this.BP_GET_IP(bp);
            int callbp = this.BP_GET_BP(bp);
            if ((bp = callbp) == 0) break;
            ++deps;
        }
        return cur_runinginfo;
    }

    public void get_running_vaiant(int frame, String name, int line, warper value, warper outline) {
        String valueret = "";
        if (this.m_fb == null) {
            return;
        }
        variant gcv = this.m_f.pa.get_const_define(name);
        if (gcv != null) {
            if (gcv.m_type == variant_type.STRING) {
                valueret = valueret + "\"";
                valueret = valueret + gcv.toString();
                valueret = valueret + "\"";
            } else {
                valueret = valueret + gcv.toString();
            }
            value.d = valueret;
            outline.d = this.m_f.pa.get_const_define_lineno(name);
            return;
        }
        int deps = 0;
        int bp = this.m_bp;
        func_binary fb = this.m_fb;
        while (bp != 0) {
            if (deps >= frame) {
                for (int i = 0; i < fb.m_debug_stack_variant_info.length; ++i) {
                    stack_variant_info info = fb.m_debug_stack_variant_info[i];
                    if ((line == -1 || !info.m_name.equals(name) || info.m_line != line) && (line != -1 || !info.m_name.equals(name))) continue;
                    variant v = this.m_stack.get(bp + info.m_pos);
                    if (v.m_type == variant_type.STRING) {
                        valueret = valueret + "\"";
                        valueret = valueret + v.toString();
                        valueret = valueret + "\"";
                    } else {
                        valueret = valueret + v.toString();
                    }
                    value.d = valueret;
                    outline.d = info.m_line;
                    return;
                }
                break;
            }
            fb = this.BP_GET_FB(bp);
            int callbp = 0;
            callbp = this.BP_GET_BP(bp);
            if ((bp = callbp) == 0) break;
            ++deps;
        }
    }

    public void get_running_call_stack_frame_info(int frame, warper stackinfo, warper func, warper file, warper line) {
        String valueret = "";
        if (this.m_fb == null) {
            return;
        }
        int deps = 0;
        int ip = this.m_ip;
        int bp = this.m_bp;
        func_binary fb = this.m_fb;
        while (bp != 0) {
            if (deps >= frame) {
                func.d = fb != null ? fb.m_name : "";
                file.d = fb != null ? fb.m_filename : "";
                line.d = fb != null ? fb.get_binary_lineno(ip) : 0;
                valueret = valueret + "#";
                valueret = valueret + deps;
                valueret = valueret + "\t";
                valueret = valueret + func;
                valueret = valueret + " at ";
                valueret = valueret + file;
                valueret = valueret + ":";
                valueret = valueret + line;
                valueret = valueret + "\n";
                stackinfo.d = valueret;
                return;
            }
            fb = this.BP_GET_FB(bp);
            ip = this.BP_GET_IP(bp);
            int callbp = 0;
            callbp = this.BP_GET_BP(bp);
            if ((bp = callbp) == 0) break;
            ++deps;
        }
    }

    public int get_running_call_stack_length() {
        if (this.m_fb == null) {
            return 0;
        }
        int deps = 0;
        int bp = this.m_bp;
        while (bp != 0) {
            ++deps;
            int callbp = 0;
            callbp = this.BP_GET_BP(bp);
            if ((bp = callbp) != 0) continue;
            break;
        }
        return deps;
    }

    public void set_running_vaiant(int frame, String name, int line, String value) {
        fake f = this.m_f;
        if (this.m_fb == null) {
            return;
        }
        variant gcv = this.m_f.pa.get_const_define(name);
        if (gcv != null) {
            return;
        }
        int deps = 0;
        int bp = this.m_bp;
        func_binary fb = this.m_fb;
        while (bp != 0) {
            if (deps >= frame) {
                for (int i = 0; i < fb.m_debug_stack_variant_info.length; ++i) {
                    stack_variant_info info = fb.m_debug_stack_variant_info[i];
                    if ((line == -1 || !info.m_name.equals(name) || info.m_line != line) && (line != -1 || !info.m_name.equals(name))) continue;
                    variant v = this.m_stack.get(bp + info.m_pos);
                    String valuestr = value;
                    if (valuestr.isEmpty()) {
                        return;
                    }
                    if (valuestr.startsWith("\"")) {
                        valuestr = valuestr.substring(1, valuestr.length() - 1);
                        v.set_string(valuestr);
                    } else {
                        v.set_real(Integer.parseInt(value));
                    }
                    return;
                }
                break;
            }
            fb = this.BP_GET_FB(bp);
            int callbp = 0;
            callbp = this.BP_GET_BP(bp);
            if ((bp = callbp) == 0) break;
            ++deps;
        }
    }
}

