/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.core.impl;

import io.api.etherscan.core.ILogsApi;
import io.api.etherscan.core.impl.BasicProvider;
import io.api.etherscan.error.ApiException;
import io.api.etherscan.executor.IHttpExecutor;
import io.api.etherscan.manager.IQueueManager;
import io.api.etherscan.model.Log;
import io.api.etherscan.model.query.impl.LogQuery;
import io.api.etherscan.model.utility.LogResponseTO;
import io.api.etherscan.util.BasicUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LogsApiProvider
extends BasicProvider
implements ILogsApi {
    private static final String ACT_LOGS_PARAM = "&action=getLogs";

    LogsApiProvider(IQueueManager queue, String baseUrl, IHttpExecutor executor) {
        super(queue, "logs", baseUrl, executor);
    }

    @Override
    @NotNull
    public List<Log> logs(LogQuery query) throws ApiException {
        String urlParams = ACT_LOGS_PARAM + query.getParams();
        LogResponseTO response = this.getRequest(urlParams, LogResponseTO.class);
        BasicUtils.validateTxResponse(response);
        return BasicUtils.isEmpty(response.getResult()) ? Collections.emptyList() : response.getResult();
    }
}

