/*
 * Decompiled with CFR 0.152.
 */
package io.api.etherscan.model;

import io.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

abstract class BaseTx {
    private long blockNumber;
    private String timeStamp;
    private LocalDateTime _timeStamp;
    private String hash;
    private String from;
    private String to;
    private BigInteger value;
    private String contractAddress;
    private String input;
    private BigInteger gas;
    private BigInteger gasUsed;

    BaseTx() {
    }

    public long getBlockNumber() {
        return this.blockNumber;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timeStamp == null && !BasicUtils.isEmpty(this.timeStamp)) {
            this._timeStamp = LocalDateTime.ofEpochSecond(Long.parseLong(this.timeStamp), 0, ZoneOffset.UTC);
        }
        return this._timeStamp;
    }

    public String getHash() {
        return this.hash;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getInput() {
        return this.input;
    }

    public BigInteger getGas() {
        return this.gas;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTx)) {
            return false;
        }
        BaseTx baseTx = (BaseTx)o;
        if (this.blockNumber != baseTx.blockNumber) {
            return false;
        }
        if (!Objects.equals(this.timeStamp, baseTx.timeStamp)) {
            return false;
        }
        if (!Objects.equals(this.hash, baseTx.hash)) {
            return false;
        }
        if (!Objects.equals(this.from, baseTx.from)) {
            return false;
        }
        if (!Objects.equals(this.to, baseTx.to)) {
            return false;
        }
        return Objects.equals(this.value, baseTx.value);
    }

    public int hashCode() {
        int result = (int)(this.blockNumber ^ this.blockNumber >>> 32);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BaseTx{blockNumber=" + this.blockNumber + ", timeStamp='" + this.timeStamp + '\'' + ", hash='" + this.hash + '\'' + ", from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", value=" + this.value + ", contractAddress='" + this.contractAddress + '\'' + ", input='" + this.input + '\'' + ", gas=" + this.gas + ", gasUsed=" + this.gasUsed + '}';
    }
}

