/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.proxy;

import com.google.gson.annotations.Expose;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.model.proxy.TxProxy;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BlockProxy
implements Comparable<BlockProxy> {
    private String number;
    @Expose(deserialize=false, serialize=false)
    private Long _number;
    private String hash;
    private String parentHash;
    private String stateRoot;
    private String size;
    @Expose(deserialize=false, serialize=false)
    private Long _size;
    private String difficulty;
    private String totalDifficulty;
    private String timestamp;
    @Expose(deserialize=false, serialize=false)
    private LocalDateTime _timestamp;
    private String miner;
    private String nonce;
    private String extraData;
    private String logsBloom;
    private String mixHash;
    private String gasUsed;
    @Expose(deserialize=false, serialize=false)
    private Wei _gasUsed;
    private String gasLimit;
    @Expose(deserialize=false, serialize=false)
    private Wei _gasLimit;
    private String sha3Uncles;
    private List<String> uncles;
    private String receiptsRoot;
    private String transactionsRoot;
    private List<TxProxy> transactions;

    protected BlockProxy() {
    }

    public Long getNumber() {
        if (this._number == null && !BasicUtils.isEmpty(this.number)) {
            this._number = BasicUtils.parseHex(this.number).longValue();
        }
        return this._number;
    }

    public String getHash() {
        return this.hash;
    }

    public String getParentHash() {
        return this.parentHash;
    }

    public String getStateRoot() {
        return this.stateRoot;
    }

    public Long getSize() {
        if (this._size == null && !BasicUtils.isEmpty(this.size)) {
            this._size = BasicUtils.parseHex(this.size).longValue();
        }
        return this._size;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public String getTotalDifficulty() {
        return this.totalDifficulty;
    }

    public LocalDateTime getTimeStamp() {
        if (this._timestamp == null && !BasicUtils.isEmpty(this.timestamp)) {
            this._timestamp = LocalDateTime.ofEpochSecond(BasicUtils.parseHex(this.timestamp).longValue(), 0, ZoneOffset.UTC);
        }
        return this._timestamp;
    }

    public String getMiner() {
        return this.miner;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public String getMixHash() {
        return this.mixHash;
    }

    public Wei getGasUsed() {
        if (this._gasUsed == null && !BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = Wei.ofWei(BasicUtils.parseHex(this.gasUsed));
        }
        return this._gasUsed;
    }

    public Wei getGasLimit() {
        if (this._gasLimit == null && !BasicUtils.isEmpty(this.gasLimit)) {
            this._gasLimit = Wei.ofWei(BasicUtils.parseHex(this.gasLimit));
        }
        return this._gasLimit;
    }

    public String getSha3Uncles() {
        return this.sha3Uncles;
    }

    public List<String> getUncles() {
        return this.uncles;
    }

    public String getReceiptsRoot() {
        return this.receiptsRoot;
    }

    public String getTransactionsRoot() {
        return this.transactionsRoot;
    }

    public List<TxProxy> getTransactions() {
        return this.transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockProxy)) {
            return false;
        }
        BlockProxy that = (BlockProxy)o;
        return Objects.equals(this.number, that.number) && Objects.equals(this.hash, that.hash) && Objects.equals(this.parentHash, that.parentHash) && Objects.equals(this.nonce, that.nonce);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.hash, this.parentHash, this.nonce);
    }

    public String toString() {
        return "BlockProxy{number='" + this.number + '\'' + ", hash='" + this.hash + '\'' + ", parentHash='" + this.parentHash + '\'' + ", stateRoot='" + this.stateRoot + '\'' + ", size='" + this.size + '\'' + ", difficulty='" + this.difficulty + '\'' + ", totalDifficulty='" + this.totalDifficulty + '\'' + ", timestamp='" + this.timestamp + '\'' + ", miner='" + this.miner + '\'' + ", nonce='" + this.nonce + '\'' + ", extraData='" + this.extraData + '\'' + ", logsBloom='" + this.logsBloom + '\'' + ", mixHash='" + this.mixHash + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", gasLimit='" + this.gasLimit + '\'' + ", sha3Uncles='" + this.sha3Uncles + '\'' + ", uncles=" + this.uncles + ", receiptsRoot='" + this.receiptsRoot + '\'' + ", transactionsRoot='" + this.transactionsRoot + '\'' + ", transactions=" + this.transactions + '}';
    }

    @Override
    public int compareTo(@NotNull BlockProxy o) {
        return Long.compare(this.getNumber(), o.getNumber());
    }

    public static BlockProxyBuilder builder() {
        return new BlockProxyBuilder();
    }

    public static final class BlockProxyBuilder {
        private Long number;
        private String hash;
        private String parentHash;
        private String stateRoot;
        private Long size;
        private String difficulty;
        private String totalDifficulty;
        private LocalDateTime timestamp;
        private String miner;
        private String nonce;
        private String extraData;
        private String logsBloom;
        private String mixHash;
        private Wei gasUsed;
        private Wei gasLimit;
        private String sha3Uncles;
        private List<String> uncles;
        private String receiptsRoot;
        private String transactionsRoot;
        private List<TxProxy> transactions;

        private BlockProxyBuilder() {
        }

        public BlockProxyBuilder withNumber(Long number) {
            this.number = number;
            return this;
        }

        public BlockProxyBuilder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public BlockProxyBuilder withParentHash(String parentHash) {
            this.parentHash = parentHash;
            return this;
        }

        public BlockProxyBuilder withStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
            return this;
        }

        public BlockProxyBuilder withSize(Long size) {
            this.size = size;
            return this;
        }

        public BlockProxyBuilder withDifficulty(String difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public BlockProxyBuilder withTotalDifficulty(String totalDifficulty) {
            this.totalDifficulty = totalDifficulty;
            return this;
        }

        public BlockProxyBuilder withTimestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BlockProxyBuilder withMiner(String miner) {
            this.miner = miner;
            return this;
        }

        public BlockProxyBuilder withNonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public BlockProxyBuilder withExtraData(String extraData) {
            this.extraData = extraData;
            return this;
        }

        public BlockProxyBuilder withLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
            return this;
        }

        public BlockProxyBuilder withMixHash(String mixHash) {
            this.mixHash = mixHash;
            return this;
        }

        public BlockProxyBuilder withGasUsed(Wei gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public BlockProxyBuilder withGasLimit(Wei gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        public BlockProxyBuilder withSha3Uncles(String sha3Uncles) {
            this.sha3Uncles = sha3Uncles;
            return this;
        }

        public BlockProxyBuilder withUncles(List<String> uncles) {
            this.uncles = uncles;
            return this;
        }

        public BlockProxyBuilder withReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
            return this;
        }

        public BlockProxyBuilder withTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
            return this;
        }

        public BlockProxyBuilder withTransactions(List<TxProxy> transactions) {
            this.transactions = transactions;
            return this;
        }

        public BlockProxy build() {
            BlockProxy blockProxy = new BlockProxy();
            blockProxy.mixHash = this.mixHash;
            blockProxy.totalDifficulty = this.totalDifficulty;
            blockProxy.nonce = this.nonce;
            blockProxy.uncles = this.uncles;
            blockProxy.transactionsRoot = this.transactionsRoot;
            blockProxy.number = String.valueOf(this.number);
            blockProxy.logsBloom = this.logsBloom;
            blockProxy.receiptsRoot = this.receiptsRoot;
            blockProxy.hash = this.hash;
            blockProxy.parentHash = this.parentHash;
            blockProxy._size = this.size;
            blockProxy.difficulty = this.difficulty;
            if (this.gasLimit != null) {
                blockProxy._gasLimit = this.gasLimit;
            }
            if (this.gasUsed != null) {
                blockProxy._gasUsed = this.gasUsed;
            }
            blockProxy.size = String.valueOf(this.size);
            blockProxy.extraData = this.extraData;
            blockProxy.stateRoot = this.stateRoot;
            blockProxy.sha3Uncles = this.sha3Uncles;
            blockProxy.miner = this.miner;
            if (this.timestamp != null) {
                blockProxy.timestamp = String.valueOf(this.timestamp.toEpochSecond(ZoneOffset.UTC));
                blockProxy._timestamp = this.timestamp;
            }
            blockProxy.transactions = this.transactions;
            blockProxy._number = this.number;
            return blockProxy;
        }
    }
}

