/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.Block;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Objects;

public class BlockUncle
extends Block {
    private String blockMiner;
    private List<Uncle> uncles;
    private String uncleInclusionReward;

    protected BlockUncle() {
    }

    public boolean isEmpty() {
        return this.getBlockNumber() == 0L && this.getBlockReward() == null && this.getTimeStamp() == null && BasicUtils.isEmpty(this.blockMiner);
    }

    public String getBlockMiner() {
        return this.blockMiner;
    }

    public List<Uncle> getUncles() {
        return this.uncles;
    }

    public String getUncleInclusionReward() {
        return this.uncleInclusionReward;
    }

    @Override
    public String toString() {
        return "UncleBlock{blockMiner=" + this.blockMiner + ", uncles=" + this.uncles + ", uncleInclusionReward=" + this.uncleInclusionReward + '}';
    }

    public static BlockUncleBuilder builder() {
        return new BlockUncleBuilder();
    }

    public static final class BlockUncleBuilder
    extends Block.BlockBuilder {
        private long blockNumber;
        private BigInteger blockReward;
        private LocalDateTime timeStamp;
        private String blockMiner;
        private List<Uncle> uncles;
        private String uncleInclusionReward;

        private BlockUncleBuilder() {
        }

        @Override
        public BlockUncleBuilder withBlockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        @Override
        public BlockUncleBuilder withBlockReward(BigInteger blockReward) {
            this.blockReward = blockReward;
            return this;
        }

        @Override
        public BlockUncleBuilder withTimeStamp(LocalDateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public BlockUncleBuilder withBlockMiner(String blockMiner) {
            this.blockMiner = blockMiner;
            return this;
        }

        public BlockUncleBuilder withUncles(List<Uncle> uncles) {
            this.uncles = uncles;
            return this;
        }

        public BlockUncleBuilder withUncleInclusionReward(String uncleInclusionReward) {
            this.uncleInclusionReward = uncleInclusionReward;
            return this;
        }

        @Override
        public BlockUncle build() {
            BlockUncle blockUncle = new BlockUncle();
            blockUncle.uncles = this.uncles;
            blockUncle.uncleInclusionReward = this.uncleInclusionReward;
            blockUncle.blockNumber = this.blockNumber;
            blockUncle.blockReward = this.blockReward;
            blockUncle.blockMiner = this.blockMiner;
            if (this.timeStamp != null) {
                blockUncle._timeStamp = this.timeStamp;
                blockUncle.timeStamp = String.valueOf(this.timeStamp.toEpochSecond(ZoneOffset.UTC));
            }
            return blockUncle;
        }
    }

    public static class Uncle {
        private String miner;
        private BigInteger blockreward;
        private int unclePosition;

        protected Uncle() {
        }

        public String getMiner() {
            return this.miner;
        }

        public BigInteger getBlockreward() {
            return this.blockreward;
        }

        public int getUnclePosition() {
            return this.unclePosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Uncle)) {
                return false;
            }
            Uncle uncle = (Uncle)o;
            return this.unclePosition == uncle.unclePosition && Objects.equals(this.miner, uncle.miner) && Objects.equals(this.blockreward, uncle.blockreward);
        }

        public int hashCode() {
            return Objects.hash(this.miner, this.blockreward, this.unclePosition);
        }

        public String toString() {
            return "Uncle{miner=" + this.miner + ", blockreward=" + this.blockreward + ", unclePosition=" + this.unclePosition + '}';
        }

        public static UncleBuilder builder() {
            return new UncleBuilder();
        }

        public static final class UncleBuilder {
            private String miner;
            private BigInteger blockreward;
            private int unclePosition;

            private UncleBuilder() {
            }

            public UncleBuilder withMiner(String miner) {
                this.miner = miner;
                return this;
            }

            public UncleBuilder withBlockreward(BigInteger blockreward) {
                this.blockreward = blockreward;
                return this;
            }

            public UncleBuilder withUnclePosition(int unclePosition) {
                this.unclePosition = unclePosition;
                return this;
            }

            public Uncle build() {
                Uncle uncle = new Uncle();
                uncle.miner = this.miner;
                uncle.blockreward = this.blockreward;
                uncle.unclePosition = this.unclePosition;
                return uncle;
            }
        }
    }
}

