/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.proxy;

import com.google.gson.annotations.Expose;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TxProxy
implements Comparable<TxProxy> {
    private String to;
    private String hash;
    private String transactionIndex;
    @Expose(deserialize=false, serialize=false)
    private Long _transactionIndex;
    private String from;
    private String v;
    private String input;
    private String s;
    private String r;
    private String nonce;
    @Expose(deserialize=false, serialize=false)
    private Long _nonce;
    private String value;
    private String gas;
    @Expose(deserialize=false, serialize=false)
    private Wei _gas;
    private String gasPrice;
    @Expose(deserialize=false, serialize=false)
    private Wei _gasPrice;
    private String blockHash;
    private String blockNumber;
    @Expose(deserialize=false, serialize=false)
    private Long _blockNumber;

    protected TxProxy() {
    }

    public String getTo() {
        return this.to;
    }

    public String getHash() {
        return this.hash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public String getFrom() {
        return this.from;
    }

    public Wei getGas() {
        if (this._gas == null && !BasicUtils.isEmpty(this.gas)) {
            this._gas = Wei.ofWei(BasicUtils.parseHex(this.gas));
        }
        return this._gas;
    }

    public String getV() {
        return this.v;
    }

    public String getInput() {
        return this.input;
    }

    public String getS() {
        return this.s;
    }

    public String getR() {
        return this.r;
    }

    public Long getNonce() {
        if (this._nonce == null && !BasicUtils.isEmpty(this.nonce)) {
            this._nonce = BasicUtils.parseHex(this.nonce).longValue();
        }
        return this._nonce;
    }

    public String getValue() {
        return this.value;
    }

    public Wei getGasPrice() {
        if (this._gasPrice == null && !BasicUtils.isEmpty(this.gasPrice)) {
            this._gasPrice = Wei.ofWei(BasicUtils.parseHex(this.gasPrice));
        }
        return this._gasPrice;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TxProxy)) {
            return false;
        }
        TxProxy txProxy = (TxProxy)o;
        return Objects.equals(this.hash, txProxy.hash) && Objects.equals(this.transactionIndex, txProxy.transactionIndex) && Objects.equals(this.nonce, txProxy.nonce) && Objects.equals(this.blockHash, txProxy.blockHash) && Objects.equals(this.blockNumber, txProxy.blockNumber);
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.transactionIndex, this.nonce, this.blockHash, this.blockNumber);
    }

    public String toString() {
        return "TxProxy{to=" + this.to + ", hash=" + this.hash + ", transactionIndex=" + this.transactionIndex + ", from=" + this.from + ", v=" + this.v + ", input=" + this.input + ", s=" + this.s + ", r=" + this.r + ", nonce=" + this.nonce + ", value=" + this.value + ", gas=" + this.gas + ", gasPrice=" + this.gasPrice + ", blockHash=" + this.blockHash + ", blockNumber=" + this.blockNumber + '}';
    }

    @Override
    public int compareTo(@NotNull TxProxy o) {
        int firstCompare = Long.compare(this.getBlockNumber(), o.getBlockNumber());
        return firstCompare == 0 ? Long.compare(this.getTransactionIndex(), o.getTransactionIndex()) : firstCompare;
    }

    public static TxProxyBuilder builder() {
        return new TxProxyBuilder();
    }

    public static final class TxProxyBuilder {
        private String to;
        private String hash;
        private Long transactionIndex;
        private String from;
        private String v;
        private String input;
        private String s;
        private String r;
        private Long nonce;
        private String value;
        private Wei gas;
        private Wei gasPrice;
        private String blockHash;
        private Long blockNumber;

        private TxProxyBuilder() {
        }

        public TxProxyBuilder withTo(String to) {
            this.to = to;
            return this;
        }

        public TxProxyBuilder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public TxProxyBuilder withTransactionIndex(Long transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public TxProxyBuilder withFrom(String from) {
            this.from = from;
            return this;
        }

        public TxProxyBuilder withV(String v) {
            this.v = v;
            return this;
        }

        public TxProxyBuilder withInput(String input) {
            this.input = input;
            return this;
        }

        public TxProxyBuilder withS(String s) {
            this.s = s;
            return this;
        }

        public TxProxyBuilder withR(String r) {
            this.r = r;
            return this;
        }

        public TxProxyBuilder withNonce(Long nonce) {
            this.nonce = nonce;
            return this;
        }

        public TxProxyBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public TxProxyBuilder withGas(Wei gas) {
            this.gas = gas;
            return this;
        }

        public TxProxyBuilder withGasPrice(Wei gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public TxProxyBuilder withBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public TxProxyBuilder withBlockNumber(Long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public TxProxy build() {
            TxProxy txProxy = new TxProxy();
            txProxy.input = this.input;
            if (this.gas != null) {
                txProxy._gas = this.gas;
            }
            txProxy.s = this.s;
            txProxy.blockHash = this.blockHash;
            txProxy.to = this.to;
            txProxy.r = this.r;
            txProxy.transactionIndex = String.valueOf(this.transactionIndex);
            txProxy._nonce = this.nonce;
            txProxy.value = this.value;
            txProxy.v = this.v;
            txProxy.from = this.from;
            txProxy.nonce = String.valueOf(this.nonce);
            txProxy._transactionIndex = this.transactionIndex;
            txProxy.blockNumber = String.valueOf(this.blockNumber);
            txProxy._blockNumber = this.blockNumber;
            txProxy.hash = this.hash;
            if (this.gasPrice != null) {
                txProxy._gasPrice = this.gasPrice;
            }
            return txProxy;
        }
    }
}

