/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model;

import io.goodforgod.api.etherscan.model.BlockTx;
import io.goodforgod.api.etherscan.model.Wei;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;

public class TxErc1155
extends BlockTx {
    private String tokenID;
    private String tokenName;
    private String tokenSymbol;
    private String tokenValue;

    protected TxErc1155() {
    }

    public String getTokenID() {
        return this.tokenID;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public String getTokenSymbol() {
        return this.tokenSymbol;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TxErc1155)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxErc1155 txErc1155 = (TxErc1155)o;
        return Objects.equals(this.tokenID, txErc1155.tokenID) && Objects.equals(this.tokenName, txErc1155.tokenName) && Objects.equals(this.tokenSymbol, txErc1155.tokenSymbol) && Objects.equals(this.tokenValue, txErc1155.tokenValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenID, this.tokenName, this.tokenSymbol, this.tokenValue);
    }

    public String toString() {
        return "TxErc1155{tokenID=" + this.tokenID + ", tokenName=" + this.tokenName + ", tokenSymbol=" + this.tokenSymbol + ", tokenValue=" + this.tokenValue + ", nonce=" + this.nonce + ", blockHash=" + this.blockHash + ", transactionIndex=" + this.transactionIndex + ", confirmations=" + this.confirmations + ", gasPrice=" + String.valueOf(this.gasPrice) + ", cumulativeGasUsed=" + String.valueOf(this.cumulativeGasUsed) + ", blockNumber=" + this.blockNumber + ", timeStamp=" + this.timeStamp + ", hash=" + this.hash + ", from=" + this.from + ", to=" + this.to + ", contractAddress=" + this.contractAddress + ", input=" + this.input + ", gas=" + String.valueOf(this.gas) + ", gasUsed=" + String.valueOf(this.gasUsed) + "}";
    }

    public static TxErc1155Builder builder() {
        return new TxErc1155Builder();
    }

    public static class TxErc1155Builder {
        private long blockNumber;
        private LocalDateTime timeStamp;
        private String hash;
        private String from;
        private String to;
        private String contractAddress;
        private String input;
        private long nonce;
        private String blockHash;
        private String tokenID;
        private String tokenName;
        private String tokenSymbol;
        private String tokenValue;
        private int transactionIndex;
        private Wei gas;
        private Wei gasUsed;
        private Wei gasPrice;
        private Wei cumulativeGasUsed;
        private long confirmations;

        private TxErc1155Builder() {
        }

        public TxErc1155Builder withBlockNumber(long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public TxErc1155Builder withTimeStamp(LocalDateTime timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public TxErc1155Builder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public TxErc1155Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public TxErc1155Builder withTo(String to) {
            this.to = to;
            return this;
        }

        public TxErc1155Builder withContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public TxErc1155Builder withInput(String input) {
            this.input = input;
            return this;
        }

        public TxErc1155Builder withGas(Wei gas) {
            this.gas = gas;
            return this;
        }

        public TxErc1155Builder withGasUsed(Wei gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public TxErc1155Builder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        public TxErc1155Builder withBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public TxErc1155Builder withTokenID(String tokenID) {
            this.tokenID = tokenID;
            return this;
        }

        public TxErc1155Builder withTokenName(String tokenName) {
            this.tokenName = tokenName;
            return this;
        }

        public TxErc1155Builder withTokenSymbol(String tokenSymbol) {
            this.tokenSymbol = tokenSymbol;
            return this;
        }

        public TxErc1155Builder withTokenDecimal(String tokenDecimal) {
            this.tokenValue = tokenDecimal;
            return this;
        }

        public TxErc1155Builder withTransactionIndex(int transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public TxErc1155Builder withGasPrice(Wei gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public TxErc1155Builder withCumulativeGasUsed(Wei cumulativeGasUsed) {
            this.cumulativeGasUsed = cumulativeGasUsed;
            return this;
        }

        public TxErc1155Builder withConfirmations(long confirmations) {
            this.confirmations = confirmations;
            return this;
        }

        public TxErc1155 build() {
            TxErc1155 txERC1155 = new TxErc1155();
            txERC1155.tokenName = this.tokenName;
            txERC1155.hash = this.hash;
            txERC1155.nonce = this.nonce;
            txERC1155.from = this.from;
            if (this.gas != null) {
                txERC1155.gas = this.gas.asWei();
            }
            if (this.gasUsed != null) {
                txERC1155.gasUsed = this.gasUsed.asWei();
            }
            if (this.gasPrice != null) {
                txERC1155.gasPrice = this.gasPrice.asWei();
            }
            if (this.cumulativeGasUsed != null) {
                txERC1155.cumulativeGasUsed = this.cumulativeGasUsed.asWei();
            }
            txERC1155.contractAddress = this.contractAddress;
            txERC1155.tokenID = this.tokenID;
            if (this.timeStamp != null) {
                txERC1155.timeStamp = String.valueOf(this.timeStamp.toEpochSecond(ZoneOffset.UTC));
                txERC1155._timeStamp = this.timeStamp;
            }
            txERC1155.blockNumber = this.blockNumber;
            txERC1155.tokenValue = this.tokenValue;
            txERC1155.transactionIndex = this.transactionIndex;
            txERC1155.to = this.to;
            txERC1155.confirmations = this.confirmations;
            txERC1155.input = this.input;
            txERC1155.blockHash = this.blockHash;
            txERC1155.tokenSymbol = this.tokenSymbol;
            return txERC1155;
        }
    }
}

