/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.proxy;

import com.google.gson.annotations.Expose;
import io.goodforgod.api.etherscan.model.Log;
import io.goodforgod.api.etherscan.model.Wei;
import io.goodforgod.api.etherscan.util.BasicUtils;
import java.util.List;
import java.util.Objects;

public class ReceiptProxy {
    private String root;
    private String from;
    private String to;
    private String blockNumber;
    @Expose(serialize=false, deserialize=false)
    private Long _blockNumber;
    private String blockHash;
    private String transactionHash;
    private String transactionIndex;
    @Expose(serialize=false, deserialize=false)
    private Long _transactionIndex;
    private String gasUsed;
    @Expose(serialize=false, deserialize=false)
    private Wei _gasUsed;
    private String cumulativeGasUsed;
    @Expose(serialize=false, deserialize=false)
    private Wei _cumulativeGasUsed;
    private String contractAddress;
    private List<Log> logs;
    private String logsBloom;

    protected ReceiptProxy() {
    }

    public String getRoot() {
        return this.root;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Long getBlockNumber() {
        if (this._blockNumber == null && !BasicUtils.isEmpty(this.blockNumber)) {
            this._blockNumber = BasicUtils.parseHex(this.blockNumber).longValue();
        }
        return this._blockNumber;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public Long getTransactionIndex() {
        if (this._transactionIndex == null && !BasicUtils.isEmpty(this.transactionIndex)) {
            this._transactionIndex = BasicUtils.parseHex(this.transactionIndex).longValue();
        }
        return this._transactionIndex;
    }

    public Wei getGasUsed() {
        if (this._gasUsed == null && !BasicUtils.isEmpty(this.gasUsed)) {
            this._gasUsed = Wei.ofWei(BasicUtils.parseHex(this.gasUsed));
        }
        return this._gasUsed;
    }

    public Wei getGasUsedCumulative() {
        if (this._cumulativeGasUsed == null && !BasicUtils.isEmpty(this.cumulativeGasUsed)) {
            this._cumulativeGasUsed = Wei.ofWei(BasicUtils.parseHex(this.cumulativeGasUsed));
        }
        return this._cumulativeGasUsed;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public static ReceiptProxyBuilder builder() {
        return new ReceiptProxyBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptProxy that = (ReceiptProxy)o;
        return Objects.equals(this.root, that.root) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.blockNumber, that.blockNumber) && Objects.equals(this._blockNumber, that._blockNumber) && Objects.equals(this.blockHash, that.blockHash) && Objects.equals(this.transactionHash, that.transactionHash) && Objects.equals(this.transactionIndex, that.transactionIndex) && Objects.equals(this._transactionIndex, that._transactionIndex) && Objects.equals(this.gasUsed, that.gasUsed) && Objects.equals(this._gasUsed, that._gasUsed) && Objects.equals(this.cumulativeGasUsed, that.cumulativeGasUsed) && Objects.equals(this._cumulativeGasUsed, that._cumulativeGasUsed) && Objects.equals(this.contractAddress, that.contractAddress) && Objects.equals(this.logs, that.logs) && Objects.equals(this.logsBloom, that.logsBloom);
    }

    public int hashCode() {
        return Objects.hash(this.root, this.from, this.to, this.blockNumber, this.blockNumber, this.blockHash, this.transactionHash, this.transactionIndex, this.transactionIndex, this.gasUsed, this.gasUsed, this.cumulativeGasUsed, this.cumulativeGasUsed, this.contractAddress, this.logs, this.logsBloom);
    }

    public String toString() {
        return "ReceiptProxy{root=" + this.root + "', from=" + this.from + "', to=" + this.to + "', blockNumber=" + this.blockNumber + "', blockNumber=" + this._blockNumber + ", blockHash=" + this.blockHash + "', transactionHash=" + this.transactionHash + "', transactionIndex=" + this.transactionIndex + "', transactionIndex=" + this._transactionIndex + ", gasUsed=" + this.gasUsed + "', gasUsed=" + String.valueOf(this._gasUsed) + ", cumulativeGasUsed=" + this.cumulativeGasUsed + "', cumulativeGasUsed=" + String.valueOf(this._cumulativeGasUsed) + ", contractAddress=" + this.contractAddress + "', logs=" + String.valueOf(this.logs) + ", logsBloom=" + this.logsBloom + "'}";
    }

    public static class ReceiptProxyBuilder {
        private String root;
        private String from;
        private String to;
        private Long blockNumber;
        private String blockHash;
        private String transactionHash;
        private Long transactionIndex;
        private Wei gasUsed;
        private Wei cumulativeGasUsed;
        private String contractAddress;
        private List<Log> logs;
        private String logsBloom;

        private ReceiptProxyBuilder() {
        }

        public ReceiptProxyBuilder withRoot(String root) {
            this.root = root;
            return this;
        }

        public ReceiptProxyBuilder withFrom(String from) {
            this.from = from;
            return this;
        }

        public ReceiptProxyBuilder withTo(String to) {
            this.to = to;
            return this;
        }

        public ReceiptProxyBuilder withBlockNumber(Long blockNumber) {
            this.blockNumber = blockNumber;
            return this;
        }

        public ReceiptProxyBuilder withBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public ReceiptProxyBuilder withTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public ReceiptProxyBuilder withTransactionIndex(Long transactionIndex) {
            this.transactionIndex = transactionIndex;
            return this;
        }

        public ReceiptProxyBuilder withGasUsed(Wei gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public ReceiptProxyBuilder withCumulativeGasUsed(Wei cumulativeGasUsed) {
            this.cumulativeGasUsed = cumulativeGasUsed;
            return this;
        }

        public ReceiptProxyBuilder withContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public ReceiptProxyBuilder withLogs(List<Log> logs) {
            this.logs = logs;
            return this;
        }

        public ReceiptProxyBuilder withLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
            return this;
        }

        public ReceiptProxy build() {
            ReceiptProxy receiptProxy = new ReceiptProxy();
            receiptProxy.logsBloom = this.logsBloom;
            receiptProxy.transactionHash = this.transactionHash;
            receiptProxy.blockNumber = String.valueOf(this.blockNumber);
            receiptProxy.from = this.from;
            receiptProxy._transactionIndex = this.transactionIndex;
            receiptProxy.blockHash = this.blockHash;
            receiptProxy.root = this.root;
            receiptProxy.contractAddress = this.contractAddress;
            if (this.gasUsed != null) {
                receiptProxy._gasUsed = this.gasUsed;
            }
            receiptProxy.logs = this.logs;
            receiptProxy.to = this.to;
            if (this.cumulativeGasUsed != null) {
                receiptProxy._cumulativeGasUsed = this.cumulativeGasUsed;
            }
            receiptProxy.transactionIndex = String.valueOf(this.transactionIndex);
            receiptProxy._blockNumber = this.blockNumber;
            return receiptProxy;
        }
    }
}

