/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.api.etherscan.model.query;

import io.goodforgod.api.etherscan.error.EtherScanLogQueryException;
import io.goodforgod.api.etherscan.model.query.LogQuery;
import io.goodforgod.api.etherscan.model.query.LogQueryImpl;
import io.goodforgod.api.etherscan.model.query.LogTopicQuadro;
import io.goodforgod.api.etherscan.model.query.LogTopicSingle;
import io.goodforgod.api.etherscan.model.query.LogTopicTriple;
import io.goodforgod.api.etherscan.model.query.LogTopicTuple;
import io.goodforgod.api.etherscan.util.BasicUtils;
import org.jetbrains.annotations.NotNull;

public class LogQueryBuilderImpl
implements LogQuery.Builder {
    static final long MIN_BLOCK = 0L;
    static final long MAX_BLOCK = 99999999999999999L;
    private final String address;
    private final long startBlock;
    private final long endBlock;

    LogQueryBuilderImpl(String address, long startBlock, long endBlock) {
        BasicUtils.validateAddress(address);
        this.address = address;
        this.startBlock = startBlock;
        this.endBlock = endBlock;
    }

    @Override
    @NotNull
    public LogQuery.Builder withBlockFrom(long startBlock) {
        return new LogQueryBuilderImpl(this.address, startBlock, this.endBlock);
    }

    @Override
    @NotNull
    public LogQuery.Builder withBlockTo(long endBlock) {
        return new LogQueryBuilderImpl(this.address, this.startBlock, endBlock);
    }

    @Override
    @NotNull
    public LogTopicSingle withTopic(@NotNull String topic0) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new EtherScanLogQueryException("topic0 can not be empty or non hex.");
        }
        return new LogTopicSingle(this.address, this.startBlock, this.endBlock, topic0);
    }

    @Override
    @NotNull
    public LogTopicTuple withTopic(@NotNull String topic0, @NotNull String topic1) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new EtherScanLogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new EtherScanLogQueryException("topic1 can not be empty or non hex.");
        }
        return new LogTopicTuple(this.address, this.startBlock, this.endBlock, topic0, topic1);
    }

    @Override
    @NotNull
    public LogTopicTriple withTopic(@NotNull String topic0, @NotNull String topic1, @NotNull String topic2) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new EtherScanLogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new EtherScanLogQueryException("topic1 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic2)) {
            throw new EtherScanLogQueryException("topic2 can not be empty or non hex.");
        }
        return new LogTopicTriple(this.address, this.startBlock, this.endBlock, topic0, topic1, topic2);
    }

    @Override
    @NotNull
    public LogTopicQuadro withTopic(@NotNull String topic0, @NotNull String topic1, @NotNull String topic2, @NotNull String topic3) {
        if (BasicUtils.isNotHex(topic0)) {
            throw new EtherScanLogQueryException("topic0 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic1)) {
            throw new EtherScanLogQueryException("topic1 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic2)) {
            throw new EtherScanLogQueryException("topic2 can not be empty or non hex.");
        }
        if (BasicUtils.isNotHex(topic3)) {
            throw new EtherScanLogQueryException("topic3 can not be empty or non hex.");
        }
        return new LogTopicQuadro(this.address, this.startBlock, this.endBlock, topic0, topic1, topic2, topic3);
    }

    @Override
    @NotNull
    public LogQuery build() throws EtherScanLogQueryException {
        return new LogQueryImpl("&address=" + this.address + "&fromBlock=" + this.startBlock + "&toBlock=" + this.endBlock);
    }
}

