/*
 * Decompiled with CFR 0.152.
 */
package com.github.greengerong;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreRenderSEOFilter
implements Filter {
    private static final Logger log;
    private FilterConfig filterConfig;
    private CloseableHttpClient httpClient;
    protected static final HeaderGroup hopByHopHeaders;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        HttpClientBuilder builder = HttpClients.custom();
        String proxy = filterConfig.getInitParameter("proxy");
        if (StringUtils.isNotBlank((String)proxy)) {
            int proxyPort = Integer.parseInt(filterConfig.getInitParameter("proxyPort"));
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxy, proxyPort));
            builder = builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        builder = builder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        this.httpClient = builder.build();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (this.shouldShowPrerenderedPage(request) && this.proxyPrerenderedPageResponse(request, response)) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proxyPrerenderedPageResponse(HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        String apiUrl = this.getApiUrl(this.getFullUrl(request));
        HttpGet getMethod = new HttpGet(apiUrl);
        this.copyRequestHeaders(request, (HttpRequest)getMethod);
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)getMethod);
        try {
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                this.copyResponseHeaders((HttpResponse)httpResponse, response);
                this.copyResponseEntity((HttpResponse)httpResponse, response);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            httpResponse.close();
        }
        return false;
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            try {
                entity.writeTo((OutputStream)servletOutputStream);
            }
            finally {
                this.closeQuietly((Closeable)servletOutputStream);
            }
        }
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) throws URISyntaxException {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    HttpHost host = URIUtils.extractHost((URI)new URI(this.getPrerenderServiceUrl()));
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    public void destroy() {
        this.filterConfig = null;
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> getCrawlerUserAgents() {
        ArrayList crawlerUserAgents = Lists.newArrayList((Object[])new String[]{"googlebot", "yahoo", "bingbot", "baiduspider", "facebookexternalhit", "twitterbot"});
        String crawlerUserAgentsFromConfig = this.filterConfig.getInitParameter("crawlerUserAgents");
        if (StringUtils.isNotBlank((String)crawlerUserAgentsFromConfig)) {
            crawlerUserAgents.addAll(Arrays.asList(crawlerUserAgentsFromConfig.trim().split(",")));
        }
        return crawlerUserAgents;
    }

    private List<String> getExtensionsToIgnore() {
        ArrayList extensionsToIgnore = Lists.newArrayList((Object[])new String[]{".js", ".css", ".less", ".png", ".jpg", ".jpeg", ".gif", ".pdf", ".doc", ".txt", ".zip", ".mp3", ".rar", ".exe", ".wmv", ".doc", ".avi", ".ppt", ".mpg", ".mpeg", ".tif", ".wav", ".mov", ".psd", ".ai", ".xls", ".mp4", ".m4a", ".swf", ".dat", ".dmg", ".iso", ".flv", ".m4v", ".torrent"});
        String extensionsToIgnoreFromConfig = this.filterConfig.getInitParameter("extensionsToIgnore");
        if (StringUtils.isNotBlank((String)extensionsToIgnoreFromConfig)) {
            extensionsToIgnore.addAll(Arrays.asList(extensionsToIgnoreFromConfig.trim().split(",")));
        }
        return extensionsToIgnore;
    }

    private List<String> getWhitelist() {
        String whitelist = this.filterConfig.getInitParameter("whitelist");
        if (StringUtils.isNotBlank((String)whitelist)) {
            return Arrays.asList(whitelist.trim().split(","));
        }
        return null;
    }

    private List<String> getBlacklist() {
        String blacklist = this.filterConfig.getInitParameter("blacklist");
        if (StringUtils.isNotBlank((String)blacklist)) {
            return Arrays.asList(blacklist.trim().split(","));
        }
        return null;
    }

    private boolean shouldShowPrerenderedPage(HttpServletRequest request) throws URISyntaxException {
        String userAgent = request.getHeader("User-Agent");
        String url = request.getRequestURL().toString();
        String referer = request.getHeader("Referer");
        log.trace("checking request for " + url + " from User-Agent " + userAgent + " and referer " + referer);
        if (!"GET".equals(request.getMethod())) {
            log.trace("Request is not HTTP GET; intercept: no");
            return false;
        }
        if (this.hasEscapedFragment(request)) {
            log.trace("Request Has _escaped_fragment_; intercept: yes");
            return true;
        }
        if (StringUtils.isBlank((String)userAgent)) {
            log.trace("Request has blank userAgent; intercept: no");
            return false;
        }
        if (!this.isInSearchUserAgent(userAgent)) {
            log.trace("Request User-Agent is not a search bot; intercept: no");
            return false;
        }
        if (this.isInResources(url)) {
            log.trace("request is for a (static) resource; intercept: no");
            return false;
        }
        List<String> whiteList = this.getWhitelist();
        if (whiteList != null && !this.isInWhiteList(url, whiteList)) {
            log.trace("Whitelist is enabled, but this request is not listed; intercept: no");
            return false;
        }
        List<String> blacklist = this.getBlacklist();
        if (blacklist != null && this.isInBlackList(url, referer, blacklist)) {
            log.trace("Blacklist is enabled, and this request is listed; intercept: no");
            return false;
        }
        log.trace("Defaulting to request intercept: yes");
        return true;
    }

    private boolean hasEscapedFragment(HttpServletRequest request) {
        return request.getParameterMap().containsKey("_escaped_fragment_");
    }

    private String getApiUrl(String url) {
        String prerenderServiceUrl = this.getPrerenderServiceUrl();
        if (!prerenderServiceUrl.endsWith("/")) {
            prerenderServiceUrl = prerenderServiceUrl + "/";
        }
        return prerenderServiceUrl + url;
    }

    private String getPrerenderServiceUrl() {
        String prerenderServiceUrl = this.filterConfig.getInitParameter("prerenderServiceUrl");
        return StringUtils.isNotBlank((String)prerenderServiceUrl) ? prerenderServiceUrl : "http://prerender.herokuapp.com/";
    }

    private boolean isInBlackList(final String url, final String referer, List<String> blacklist) {
        return FluentIterable.from(blacklist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                Pattern pattern = Pattern.compile(regex);
                return pattern.matcher(url).matches() || !StringUtils.isBlank((String)referer) && pattern.matcher(referer).matches();
            }
        });
    }

    private boolean isInWhiteList(final String url, List<String> whitelist) {
        return FluentIterable.from(whitelist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                return Pattern.compile(regex).matcher(url).matches();
            }
        });
    }

    private boolean isInResources(final String url) {
        return FluentIterable.from(this.getExtensionsToIgnore()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return url.contains(item.toLowerCase());
            }
        });
    }

    private boolean isInSearchUserAgent(final String userAgent) {
        return FluentIterable.from(this.getCrawlerUserAgents()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return userAgent.toLowerCase().indexOf(item.toLowerCase()) >= 0;
            }
        });
    }

    static {
        String[] headers;
        log = LoggerFactory.getLogger(PreRenderSEOFilter.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

